//############################################################################
//
// FILE:   F280xx_EEPROM.h
//
// TITLE:  Function Prototypes, Global Variables, Pointer Initialization
//		   and, Bank/Page Status Definitions  
//
//############################################################################
// Authors: Tim Love / Pradeep Shinde
// Release Date: Sep 2009 
//############################################################################


// Include Flash API Header Files
#ifdef F2801x
#include "Flash2801x_API_Config.h" 		
#include "Flash2801x_API_Library.h"		
#else
#include "Flash280x_API_Config.h" 		
#include "Flash280x_API_Library.h"		
#endif

// Project specific defines
//#define SINGLE_BYTE 1
#define MULTI_BYTE  1

// Pointer Initialization
#ifdef F2801x
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x3F4000	// Sector D
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x3F4001
#define END_OF_SECTOR 0x3F4FFF;
#endif

#ifdef F2801
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x3F4000	// Sector D
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x3F4001
#define END_OF_SECTOR 0x3F4FFF;
#endif

#ifdef F2802
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x3F0000	// Sector D
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x3F0001
#define END_OF_SECTOR 0x3F1FFF;
#endif

#ifdef F2806
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x3F0000	// Sector D
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x3F0001
#define END_OF_SECTOR 0x3F1FFF;
#endif

#ifdef F2808
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x3E8000	// Sector D		
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x3E8001
#define END_OF_SECTOR 0x3EBFFF;
#endif

#ifdef F2809
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x3D8000	// Sector H
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x3D8001
#define END_OF_SECTOR 0x3DBFFF;
#endif

// Bank/Page Status Definitions
#define EMPTY_BANK   0xFFFF
#define CURRENT_BANK 0xA00A
#define USED_BANK 	 0x0000
#define BLANK_PAGE 	 0xFFFF
#define CURRENT_PAGE 0x00FF
#define USED_PAGE    0x0000		

// Function Prototypes
extern void EEPROM_GetValidBank();
extern void EEPROM_Erase();
extern void EEPROM_Read();
extern void EEPROM_Write();
extern void EEPROM_UpdateBankStatus();
extern void EEPROM_UpdatePageStatus();
extern void EEPROM_GetSinglePointer(Uint16 First_Call);
extern void EEPROM_ProgramSingleByte(Uint16 data);

// Global Variables
extern Uint16 *Bank_Pointer;
extern Uint16 *Page_Pointer;
extern Uint16 *Sector_End;
extern Uint16 Read_Buffer[64];
extern Uint16 Write_Buffer[64];

