/***********************************************************************************
    Filename: tx.h
***********************************************************************************/

#ifndef TX_H
#define TX_H


//----------------------------------------------------------------------------------
//  Constants 
//----------------------------------------------------------------------------------

// In this example, the threshold value is set such that an interrupt is generated
// when the FIFO is half full. It would be possible to set the threshold value
// differently - and thus get an interrupt earlier (meaning there are room for a
// few bytes in the FIFO) or later (meaning that the FIFO is almost empty).

#define TX_FIFO_THRESHOLD       0x07
#define TX_OCCUPIED_FIF0        32    // Occupied space
#define TX_AVAILABLE_FIFO       32    // Free space
#define TX_FIFO_SIZE            64


#define FIXED_PACKET_LENGTH     0x00
#define INFINITE_PACKET_LENGTH  0x02
#define INFINITE                0
#define FIXED                   1
#define MAX_FIXED_LENGTH        256

#define TX_OK                   0
#define TX_LENGTH_ERROR         1
#define TX_STATE_ERROR          2




//----------------------------------------------------------------------------------
//  Structs
//----------------------------------------------------------------------------------

// Struct. used to hold information used for TX
typedef struct TXinfoDescr {
    uint16 bytesLeft;           // Bytes left that are to be written to the TX FIFO
    uint8 *pByteIndex;          // Pointer to current position in the byte array
    uint8  format;              // Infinite or fixed length packet mode
    uint8  complete;            // Packet Sendt
} TXinfoDescr;



//----------------------------------------------------------------------------------
// Function declarations
//----------------------------------------------------------------------------------
void txInitMode(uint8 mode, const HAL_RF_CONFIG *myRfConfig, const uint8 myPaTable[], const uint8 myPaTableLen);
uint16 txSendPacket(uint8* pPacket, uint8* pBytes, uint8 mode);

#endif


/***********************************************************************************
  Copyright 2008 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
***********************************************************************************/