/********************************************************************
*
* Standard register and bit definitions for the Texas Instruments
* TLC3574/78 Analog to Digital Converter.
*
* This file supports assembler and C development within the IAR
* Workbench environment for MSP430x14x devices.
*
* Texas Instruments, Version 1.0
* Texas Instruments, Version 1.0
********************************************************************/

#ifndef __TLC357X
#define __TLC357X

/************************************************************
* ADC Commands - Upper Byte transfers
************************************************************/
#define PD                  0x008
#define RES                 0x009
#define WRITE               0x0A0
#define TEST1               0x0B0
#define TEST2               0x0C0
#define TEST3               0x0D0
#define FIFO                0x0E0
#define HARDWARE            0x0F0

/************************************************************
* Register Definitions - Upper Byte (Write + ?)
************************************************************/
#define EXT_REF             0x008
#define TWOS                0x004
#define SHORT_SAMP          0x002
#define EXT_CLK             0x001
#define DUMMY               0x000

/************************************************************
* Register Definitions - Lower Byte
************************************************************/
#define PSEUDO              0x080 
#define REP_SWEEP           0x060
#define SWEEP               0x040
#define REPEAT              0x020
#define SINGLE              0x000
#define SEQ3                0x018
#define SEQ2                0x010
#define SEQ1                0x008
#define SEQ0                0x000
#define EOC                 0x004
#define FIFO3               0x003
#define FIFO2               0x002
#define FIFO1               0x001
#define FIFO0               0x000

/************************************************************
* Channel Definitions
************************************************************/
                                    /* TLC3578*/  /*TLC3574*/
#define CH0                 0x000         /*A0*/       /*A0*/
#define CH1                 0x001         /*A1*/       
#define CH2                 0x002         /*A2*/       /*A1*/
#define CH3                 0x003         /*A3*/       
#define CH4                 0x004         /*A4*/       /*A2*/
#define CH5                 0x005         /*A5*/       
#define CH6                 0x006         /*A6*/       /*A3*/
#define CH7                 0x007         /*A7*/       

#endif /* #ifndef __TLC357X */

