/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


/***********************************************************************/
/*  example4.c                                              2018-05-14 */
/*                                                                     */
/* Using Assembler Interrupt Service Routine                           */
/*                                                                     */
/* The interrupt service routine for the watchdog timer is handled by  */
/* an assembler function. Interrupt functions cannot have parameter    */
/* and return values. Because an interrupt can occur anywhere in the   */
/* program execution, any registers used have to be saved and restored */
/* (typically on the stack).                                           */
/*                                                                     */
/* Note 1: project must include assembly file "wdt_int.asm"            */
/*                                                                     */
/*                                                                     */
/* Texas Instruments Incorporated                                      */
/***********************************************************************/
#include  <msp430.h>         /* Processor specific definitions */


/***********************************************************************/
/* main */
/***********************************************************************/
void main( void )
{

// === Initialize system ================================================
#ifdef __MSP430_HAS_SFR__
  SFRIFG1=0;                 /* clear interrupt flag1 */
#else
  IFG1=0;                    /* clear interrupt flag1 */
#endif
  WDTCTL=WDT_MDLY_32;        /* WDT 32ms Interval Timer */
  P1DIR = 0x01;              /* P1.0 is output */
#ifdef LOCKLPM5
  // Disable the GPIO power-on default high-impedance mode to activate
  // previously configured port settings
  PM5CTL0 &= ~LOCKLPM5;
#endif

#ifdef __MSP430_HAS_SFR__
  SFRIFG1 &= ~WDTIFG;        /* Clear pending WDT interrupts */
  SFRIE1  |= WDTIE;          /* Enable WDT Interrupt */
#else
  IFG1 &= ~WDTIFG;           /* Clear pending WDT interrupts */
  IE1  |= WDTIE;             /* Enable WDT Interrupt */
#endif

  __enable_interrupt();

  while(1)
  {
  }
}
// === end of main =====================================================


