/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


/***********************************************************************/
/*  example5.c                                              2018-05-14 */
/*                                                                     */
/* Using Special Interrupt Handler in Assembler                        */
/*                                                                     */
/* This example shows how the interrupt service routine for the        */
/* Timer A, Timer B, and ADC12 is handled effectively within C Code.   */
/*                                                                     */
/* Note 1: project must include assembly file "ta_int.asm"             */
/*                                                                     */
/*                                                                     */
/* Texas Instruments Incorporated                                      */
/***********************************************************************/
#include  <msp430.h>         /* Processor specific definitions */
#include  <stdint.h>                /* stdint  definitions */

uint16_t Count;

/***********************************************************************/
/* main */
/***********************************************************************/
void main( void )
{

// === Initialize system ================================================
#ifdef __MSP430_HAS_SFR__
  SFRIFG1=0;                 /* clear interrupt flag1 */
#else
  IFG1=0;                    /* clear interrupt flag1 */
#endif
  WDTCTL= WDTPW+WDTHOLD;     /* stop WD */
  P1DIR = 0x01;              /* P1.0 is output */
#ifdef LOCKLPM5
  // Disable the GPIO power-on default high-impedance mode to activate
  // previously configured port settings
  PM5CTL0 &= ~LOCKLPM5;
#endif

  TA0CTL =  TASSEL_2+ TACLR; /* CLK = SMCLK ; clear counter*/
  TA0CCR1  =  0x4000;        /* Capture value for CCR1 */
  TA0CCTL1 =  CCIE;          /* enable CCR1 int */

  TA0CTL |= MC_2+ TAIE;      /* start cont. up ; enable TA int. */

  __enable_interrupt();

  while(1)
  {
  }
}
// === end of main =====================================================

/***********************************************************************/
/* TIMOVH_C */
/***********************************************************************/
__interrupt void TIMOVH_C( void )
{
  Count ++;
}
// === end of TIMOVH_C ==================================================


/***********************************************************************/
/* TIMMOD1_C */
/***********************************************************************/
__interrupt void TIMMOD1_C( void )
{
  P1OUT ^= 0x01;             /* Toggle P1.0 */
}
// === end of TIMMOD1_C =================================================
