; THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
; REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
; INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
; FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
; COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
; TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
; POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
; INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
; YOUR USE OF THE PROGRAM.
;
; IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
; CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
; THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
; OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
; EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
; REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
; OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
; USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
; AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
; YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
; (U.S.$500).
;
; Unless otherwise stated, the Program written and copyrighted
; by Texas Instruments is distributed as "freeware".  You may,
; only under TI's copyright in the Program, use and modify the
; Program without any charge or restriction.  You may
; distribute to third parties, provided that you transfer a
; copy of this license to the third party and the third party
; agrees to these terms by its first use of the Program. You
; must reproduce the copyright notice and any other legend of
; ownership on each copy or partial copy, of the Program.
;
; You acknowledge and agree that the Program contains
; copyrighted material, trade secrets and other TI proprietary
; information and is protected by copyright laws,
; international copyright treaties, and trade secret laws, as
; well as other intellectual property laws.  To protect TI's
; rights in the Program, you agree not to decompile, reverse
; engineer, disassemble or otherwise translate any object code
; versions of the Program to a human-readable form.  You agree
; that in no event will you alter, remove or destroy any
; copyright notice included in the Program.  TI reserves all
; rights not specifically granted under this license. Except
; as specifically provided herein, nothing in this agreement
; shall be construed as conferring by implication, estoppel,
; or otherwise, upon you, any license or other right under any
; TI patents, copyrights or trade secrets.
;
; You may not use the Program in non-TI devices.



; *****************************************************************************
; File:     ta_int.asm
; Date:     14. May 2018
;           Texas Instruments Deutschland
;
; Routines to handle Timer A interrupt service
; accessed out of C as interrupt routine (see "Example5.c"):
;
; *****************************************************************************

        .cdecls C,NOLIST, "msp430.h"        ; Processor specific definitions
                 
; -------------------- external Function Prototypes ---------------------
        .ref  TIMOVH_C
        .ref  TIMMOD1_C

;============================================================================
; ta_isr        Watchdog Interrupt service
;============================================================================
        .global  ta_isr                     ; Declare symbol to be exported
        .sect ".text:_isr"                  ; Code is relocatable

; Interrupt handler for Capture/Compare Modules 1 to 4.
; The interrupt flags CCIFGx and TAIFG are reset by
; hardware. Only the flag with the highest priority
; responsible for the interrupt vector word is reset.
ta_isr                                      ; Interrupt latency
             ADD &TA0IV,PC                  ; Add offset to Jump table
             RETI                           ; Vector 0: No interrupt

             JMP TIMMOD1                    ; Vector 2: Module 1
             JMP TIMMOD2                    ; Vector 4: Module 2
             JMP TIMMOD3                    ; Vector 6: Module 3
             JMP TIMMOD4                    ; Vector 8: Module 4
             RETI                           ; Reserved
             RETI                           ; Reserved

        ; fall through

TIMOVH  ; Vector 10: TIMOV Flag
   .if ($defined(__MSP430_HAS_MSP430XV2_CPU__) | $defined(__MSP430_HAS_MSP430X_CPU__))
             BRA #TIMOVH_C                 ; Handle CCR1 interrupt in C
   .else
             BR  #TIMOVH_C                 ; Handle CCR1 interrupt in C
   .endif
             ; RETI ; is handled by the C functon


TIMMOD1 ; Vector 2: Module 1
        ; If JMP could not be executed through the limited jump width
        ; first jump to this position and then branch to the C function
   .if ($defined(__MSP430_HAS_MSP430XV2_CPU__) | $defined(__MSP430_HAS_MSP430X_CPU__))
             BRA #TIMMOD1_C                 ; Handle CCR1 interrupt in C
   .else
             BR  #TIMMOD1_C                 ; Handle CCR1 interrupt in C
   .endif
             ; RETI ; is handled by the C functon

TIMMOD2
        ; If all five CCR registers are not implemented on a
        ; device, the interrupt vectors for the register that are
        ; present must still be handled.

TIMMOD3
TIMMOD4
TIMMOD5
             RETI                           ; Simply return

;============================================================================
;              Interrupt Vectors
;============================================================================

             .sect      TIMER0_A1_VECTOR    ; Timer A CC1-2, TA
             .word      ta_isr

      .end



