/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


/***********************************************************************/
/*  example2.c                                              2018-05-14 */
/*                                                                     */
/* Calling an Assembler Function From a C Program and Passing          */
/* Parameters and a Return Value                                       */
/*                                                                     */
/* This program reads the input of Port1 using a mask that is passed   */
/* to the assembler function.                                          */
/* Depending upon the returned value, port pin P1.0 is toggled or not. */
/*                                                                     */
/* Note 1: project must include assembly file "Port1.asm"              */
/*         and PortAB.asm                                              */
/*                                                                     */
/*                                                                     */
/* Texas Instruments Incorporated                                      */
/***********************************************************************/
#include  <msp430.h>                /* Processor specific definitions */
#include  <stdint.h>                /* stdint  definitions */

/* -------------------- external Function Prototypes --------------------- */
extern char get_port(char mask);    /* Function Prototype for asm function */
extern void set_port(char mask);    /* Function Prototype for asm function */
extern uint32_t get_portAB(uint32_t mask);    /* Function Prototype for asm function */
extern void set_portAB(uint32_t mask);        /* Function Prototype for asm function */



/***********************************************************************/
/* main */
/***********************************************************************/
void main( void )
{

// === Initialize system ================================================
  WDTCTL=WDTPW+WDTHOLD;      /* stop WD */
  P1DIR = 0x01;
#ifdef LOCKLPM5  
  // Disable the GPIO power-on default high-impedance mode to activate
  // previously configured port settings
  PM5CTL0 &= ~LOCKLPM5;
#endif

  while(1) /* Infinite loop*/
  {
   set_port(0x01 ^ get_port(0xFF)) ; /* Toggle value on Port 1.0 */
   set_portAB(0x02ul ^ get_portAB(0xFFFFFFFFul)) ; /* Toggle value on Port AB.1 */
  }
}
// === end of main =====================================================


