/******************************************************************************
* Name: init.h 
* 
* Description: Initialization Header File. Include all device specific
* declarations/definitions in this file. All other files should have generic
* definitions to allow for code portability between devices. 
* 
* Texas Instruments, Inc
* 
* Version: 1.0
******************************************************************************/

/*
 * Copyright (C) {2011} Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef INIT_H_
#define INIT_H_

// Include Header Files
#include "device.h"

// Definitions
#define TIMER_TICK				820			// 25 msec tick -> 0.025s/32768s ~ 820
#define MAX_NUM_LEDS 			7			// Number of LEDs on the board
#define NUM_ADC_CHANNELS		4			// Number of ADC Channels for Voltage/Current

#define NUM_CHECKING_LOOPS      2           	// Number of times to check the SMBus values
#define NUM_BATTERIES			2		

#define ADC_VOLTAGE_RESISTOR_DIVIDER_NUM 	6.65		// 6.65 KOhm resistor between ADC and GND
#define ADC_VOLTAGE_RESISTOR_DIVIDER_DEN	106.65		// 100 kOhm resistor between input and ADC
#define MAX_VOLTAGE_HIGH		51				// Units (V)
#define MAX_CURRENT_HIGH		10				// Amps (A)

#define SLEEP_MODE_DURATION		80				// 2 seconds/25 msec = 80

// Port Address Definitions
#define P1OUT_ADDR				0x0202		// P1OUT Address
#define P1DIR_ADDR				0x0204		// P1DIR Address
#define P2OUT_ADDR				0x0202		// P2OUT Address
#define P2DIR_ADDR				0x0204		// P2DIR Address
#define P4OUT_ADDR				0x0222		// P4OUT Address
#define P4DIR_ADDR				0x0224		// P4DIR Address
#define P4SEL_ADDR				0x022A		// P4SEL Address
#define P6SEL_ADDR				0x024A		// P6SEL Address
#define PJOUT_ADDR				0x0322		// PJOUT Address
#define PJDIR_ADDR				0x0324		// PJDIR Address

// Function prototypes
void UCS_Init(void);
void Timer_Init(void);
void PWM_Init(void);
void ADC_Init(void);

// Initialize structures
// Note that P1/P2 have the same base address as do P3/P4. To address bits in
// P3, address from 0 - 7 and in P4, 8 - F (hex). 

// Define default Fan state & options
#define FAN_DEFAULT_STATE { P2OUT_ADDR, P2DIR_ADDR, BIT8 } 

// Define default SMBus state & options
#define SMBUS_DEFAULT_STATE { P4DIR_ADDR, P4OUT_ADDR, BIT8, P4SEL_ADDR, BIT9, BITA } 

// Define default ADC state & options
#define ADC_DEFAULT_STATE \
{   {BATT_1, CHANNEL_VOLTAGE, P6SEL_ADDR, BITA, ADC10INCH_2}, \
	{BATT_1, CHANNEL_CURRENT, P6SEL_ADDR, BIT8, ADC10INCH_0}, \
	{BATT_2, CHANNEL_VOLTAGE, P6SEL_ADDR, BITB, ADC10INCH_3}, \
	{BATT_2, CHANNEL_CURRENT, P6SEL_ADDR, BIT9, ADC10INCH_1} \
}

// Define default LED state for the 64-pin version of the controller board
#define LED_DEFAULT_STATE \
{	{ P1OUT_ADDR, P1DIR_ADDR, BIT0, 0, 0}, \
	{ P1OUT_ADDR, P1DIR_ADDR, BIT1, 0, 0}, \
	{ P1OUT_ADDR, P1DIR_ADDR, BIT6, 0, 0}, \
	{ P1OUT_ADDR, P1DIR_ADDR, BIT7, 0, 0}, \
	{ P2OUT_ADDR, P2DIR_ADDR, BIT9, 0, 0}, \
	{ P2OUT_ADDR, P2DIR_ADDR, BITA, 0, 0}, \
	{ P2OUT_ADDR, P2DIR_ADDR, BITB, 0, 0}  \
}

#endif /*INIT_H_*/
