/******************************************************************************
* Name: led.h 
* 
* Description: Definitions for LED constants and functions. 
* 
* Texas Instruments, Inc
* 
* Version: 1.0
******************************************************************************/

/*
 * Copyright (C) {2011} Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef LED_H_
#define LED_H_

// Include Header Files
#include "device.h"

// Definitions
#define LED_MODE_OFF				0
#define LED_MODE_ON					1
#define LED_MODE_BLINK				2

#define LED_BLINK_RATE_SLOW			0
#define LED_BLINK_RATE_MEDIUM		1
#define LED_BLINK_RATE_FAST			2

#define LED_NUM_0					0
#define LED_NUM_1					1
#define LED_NUM_2					2
#define LED_NUM_3					3
#define LED_NUM_4					4
#define LED_NUM_5					5
#define LED_NUM_6					6

#define LED_BLINK_PERIOD_SLOW                   10
#define LED_BLINK_PERIOD_MEDIUM                 5
#define LED_BLINK_PERIOD_FAST                   2

// Function prototypes
void LED_Control(unsigned char led_num, unsigned char led_mode, unsigned char \
	led_blink_rate);
	
void LEDTimerISR(void);	

void LED_Init(void);

#endif /*LED_H_*/
