/*
 * PPG.h
 *
 *  Created on: Apr 8, 2020
 *      Author: a0223954
 */

#ifndef PPG_H_
#define PPG_H_

#include "stdint.h"

#define SAMPLE_RATE             100

#define ENABLE_DATA_LOG         0

#define PPG_INITIAL             0x00
#define PPG_MEASURING           0x01
#define PPG_FINGER_OUT          0x02
#define PPG_TIME_OUT            0x03


typedef struct {
    float ir_pi;
    float vs_pi;
    float R;
    uint8_t new_state;
    uint8_t state;
    uint8_t flag;
    uint8_t bpm;
    uint8_t SpO2;
}PPG_Results;

extern uint8_t log_count;
extern uint8_t log_signal;
extern uint16_t log_saturation_count;

void PPG_init(void);
void PPG_appStart(void);
void PPG_appStop(void);
void PPG_appSleep(void);
void PPG_appReInit(PPG_Results *ppgResults);
void PPG_appHandler(PPG_Results *ppgResults);

#endif /* PPG_H_ */
