/*
 * algorithm.h
 *
 *  Created on: Aug 4, 2020
 *      Author: a0223954
 */

#ifndef ALGORITHM_H_
#define ALGORITHM_H_


//*****************************************************************************
// includes
//*****************************************************************************
#include "stdint.h"

//*****************************************************************************
//! \addtogroup ussSwLib
//! @{
//*****************************************************************************

#ifdef __cplusplus

extern "C" {
#endif

//*****************************************************************************
// defines
//*****************************************************************************
#define  HEART_BEATS   25
#define  K             6   // IIR filter coeff


#define  PPG_DATA_READY          0x01
#define  PPG_SIGNAL_SATURATION   0x02
#define  PPG_FALLING_EDGE        0x04

//*****************************************************************************
// typedefs
//*****************************************************************************
typedef struct {
    int offset;
    int32_t buf[32];
}FILTER;

typedef struct {
    uint8_t flag;
    uint8_t beats;
    uint8_t log_beats;
    uint16_t log_sat_count;
    uint16_t i;
    uint16_t x[3];   // x[i-1],x[i],x[i+1]
    int16_t diffMin;
    int16_t thresh;
    uint16_t edge;
    uint16_t peak[2];
    uint16_t onset[2];
    uint16_t onsets[HEART_BEATS][2];
    uint16_t peaks[HEART_BEATS][2];
    uint16_t log_onsets[HEART_BEATS][2];
    uint16_t log_peaks[HEART_BEATS][2];
    float PI[HEART_BEATS-1];
}PPG_Info;


//*****************************************************************************
// globals
//*****************************************************************************

//*****************************************************************************
// the function prototypes
//*****************************************************************************
int32_t mul16(int16_t a, int16_t b);
int32_t mul32(int32_t a, int32_t b);
int16_t average(int16_t *input, uint16_t size);
int32_t dc_estimator(int32_t *p, uint16_t x);
int32_t fir_filter(int32_t input, FILTER *param);
float calculate_pi(PPG_Info *ppgInfo);
uint8_t calculate_bpm(PPG_Info *ppgInfoIR);
uint8_t calculate_spo2(float R);

#ifdef __cplusplus
}
#endif // extern "C"
//@}  // ingroup

#endif /* ALGORITHM_H_ */
