/*
 * hal.c
 *
 *  Created on: Apr 7, 2020
 *      Author: a0223954
 */
#include "msp430.h"

void hal_init(void)
{
    // Disable the GPIO power-on default high-impedance mode
    // to activate previously configured port settings
    PM5CTL0 &= ~LOCKLPM5;

    // Configure two FRAM waitstate as required by the device datasheet for MCLK
    // operation at 24MHz(beyond 8MHz) _before_ configuring the clock system.
    FRCTL0 = FRCTLPW | NWAITS_2;

    __bis_SR_register(SCG0);                           // disable FLL
    CSCTL3 |= SELREF__REFOCLK;                         // Set REFO as FLL reference source
    CSCTL0 = 0;                                        // clear DCO and MOD registers
    CSCTL1 |= DCORSEL_7;                               // Set DCO = 24MHz
    CSCTL2 = FLLD_0 + 731;                             // DCOCLKDIV = 24MHz
    __delay_cycles(3);
    __bic_SR_register(SCG0);                           // enable FLL
    while(CSCTL7 & (FLLUNLOCK0 | FLLUNLOCK1));         // FLL locked

    CSCTL4 = SELMS__DCOCLKDIV | SELA__REFOCLK;         // set default REFO(~32768Hz) as ACLK source, ACLK = 32768Hz
                                                       // default DCOCLKDIV as MCLK and SMCLK source
    CSCTL5 |= DIVM_0 | DIVS_2;                         // MCLK = DCOCLK = 24MHZ, SMCLK = DCOCLK/4 = 6MHz

    // Configure P2.0 for debug
    P2OUT &= ~BIT0;
    P2DIR |= BIT0;

    // Charger pump pwm init
//    P2DIR |= BIT0;
//    P2SEL0 |= BIT0;
//    TB1CCR0 = 6000000/20000 - 1;
//    TB1CCTL1 = OUTMOD_2;
//    TB1CCR1 = 6000000/20000/2;
//    TB1CTL |= TBSSEL__SMCLK|TBCLR|MC__UP;

}
