// includes list of IPs commonly used

module ffas #(parameter width=1)
 (
  output reg [width-1:0] q,
  input      [width-1:0] d,
  input      [width-1:0] init,
  input                clk,
  input                rstn
  `ifndef SYN_TRUE
  ,
  input                debug
  `endif
 );
  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      q <= init;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of init from ffas %0h",$realtime, init);
      `endif
    end
    else begin
      q <= d;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of data from ffas %0h",$realtime, d);
      `endif
    end
endmodule // ffas

module counter #(parameter width=1)
 (
  output reg [width-1:0] cnt,
  output reg             done,
  input      [width-1:0] init,
  input      [width-1:0] thsld,
  input                  clk,
  input                  rstn,
  input                  en,
  input                  round
  `ifndef SYN_TRUE
  ,
  input                  debug
  `endif
 );
  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      cnt <= init;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of init from counter %0h",$realtime, init);
      `endif    end
    else if (en) begin
      if ((cnt == thsld) || (&cnt)) begin
	 if (round) begin
   	   cnt <= init;
         `ifndef SYN_TRUE
         if (debug)
           $display("[DEBUG]%t: Restart of count from counter %0h",$realtime, init);
         `endif
	 end
         else begin
	   cnt <= cnt;
           `ifndef SYN_TRUE
           if (debug)
	     $display("[DEBUG]%t: Holding of count from counter %0h",$realtime, cnt);
           `endif
         end // else: !if(round)
      end // if ((cnt == thsld) || (&cnt))
      else begin
	cnt <= cnt + 1;
	`ifndef SYN_TRUE
        if (debug)
	  $display("[DEBUG]%t: Increment count from counter %0h",$realtime, cnt);
        `endif
      end // else: !if((cnt == thsld) || (&cnt))
    end // if (en)
    else begin
      cnt <= cnt;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of hold from counter %0h",$realtime, cnt);
      `endif
    end // else: !if(en)

  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      done <= 1'b0;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Done reset from counter",$realtime);
      `endif
    end
    else if ((cnt == thsld) || (&cnt)) begin
      done <= 1'b1;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Done set from counter",$realtime);
      `endif
    end
    else begin
      done <= 1'b0;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Done reseted from counter",$realtime);
      `endif
    end
endmodule // counter

// Local Variables:
// verilog-library-directories : (".")
// End:
