module adc1k_if_oddr(
    input dclk,
    output [11:0] Dpin_N,
    output [11:0] Dpin_P,
    input 	 reset,
    input        SET_IN,
    input [11:0] Din_1_r,
    input [11:0] Din_2_r
		);

   wire [11:0] 	  Dpin;
   wire 	  VCC1;
   
   assign VCC1 = 1;

  reg [11:0] Din_1, Din_2;
  
  always @(posedge dclk)
    Din_1   <= Din_1_r;

  always @(posedge dclk)
    Din_2   <= Din_2_r;
  
   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_0_obuf 
     (.I  (Dpin[0]), 
      .O  (Dpin_P[0]), 
      .OB (Dpin_N[0])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_0_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[0]),
      .D2 (Din_2[0]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[0])
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_1_obuf 
     (.I  (Dpin[1]), 
      .O  (Dpin_P[1]), 
      .OB (Dpin_N[1])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_1_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[1]),
      .D2 (Din_2[1]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[1])  
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_2_obuf 
     (.I  (Dpin[2]), 
      .O  (Dpin_P[2]), 
      .OB (Dpin_N[2])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_2_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[2]),
      .D2 (Din_2[2]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[2])  
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_3_obuf 
     (.I  (Dpin[3]), 
      .O  (Dpin_P[3]), 
      .OB (Dpin_N[3])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_3_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[3]),
      .D2 (Din_2[3]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[3])  
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_4_obuf 
     (.I  (Dpin[4]), 
      .O  (Dpin_P[4]), 
      .OB (Dpin_N[4])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_4_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[4]),
      .D2 (Din_2[4]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[4])  
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_5_obuf 
     (.I  (Dpin[5]), 
      .O  (Dpin_P[5]), 
      .OB (Dpin_N[5])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_5_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[5]),
      .D2 (Din_2[5]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[5])
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_6_obuf 
     (.I  (Dpin[6]), 
      .O  (Dpin_P[6]), 
      .OB (Dpin_N[6])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_6_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[6]),
      .D2 (Din_2[6]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[6])
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_7_obuf 
     (.I  (Dpin[7]), 
      .O  (Dpin_P[7]), 
      .OB (Dpin_N[7])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_7_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[7]),
      .D2 (Din_2[7]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[7])  
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_8_obuf 
     (.I  (Dpin[8]), 
      .O  (Dpin_P[8]), 
      .OB (Dpin_N[8])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_8_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[8]),
      .D2 (Din_2[8]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[8])
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_9_obuf 
     (.I  (Dpin[9]), 
      .O  (Dpin_P[9]), 
      .OB (Dpin_N[9])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_9_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[9]),
      .D2 (Din_2[9]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[9])
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_10_obuf 
     (.I  (Dpin[10]), 
      .O  (Dpin_P[10]), 
      .OB (Dpin_N[10])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_10_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[10]),
      .D2 (Din_2[10]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[10])
     );

   OBUFDS #(.IOSTANDARD ("LVDS_25"))
    d_11_obuf 
     (.I  (Dpin[11]), 
      .O  (Dpin_P[11]), 
      .OB (Dpin_N[11])
     );

   ODDR #(.DDR_CLK_EDGE ("SAME_EDGE"), .INIT (1'b0), .SRTYPE ("SYNC"))
    d_11_oddr
     (.C  (dclk), 
      .CE (VCC1), 
      .D1 (Din_1[11]),
      .D2 (Din_2[11]),
      .R(reset), 
      .S(SET_IN), 
      .Q(Dpin[11])
     );

endmodule
