module lmk_spi #(
  parameter REG0 = 32'h0000_0017,
  parameter REG1 = 32'h0000_008d,
  parameter REG2 = 32'h0000_001c,
  parameter REG3 = 32'h2800_1409,
  parameter REG4 = 32'h0111_cf88,
  parameter REG5 = 32'h001f_3326,
  parameter REG6 = 32'ha000_0005,
  parameter REG7 = 32'h0000_2644,
  parameter REG8 = 32'h0180_7703,
  parameter REG9 = 32'h0400_0642,
  parameter REG10 = 32'h0000_0011,
  parameter REG11 = 32'h0000_0200
 )
 (
  input clk10,
  input rstn,
  input restart,
  
  input pclk,
  input pen,
  input pwr,
  input [4:0] paddr,
  input [15:0]  pwdata,
  output [15:0] prdata,
  
  output d,
  output c,
  output enl,
  output lmk_sync,
  output lmk_done
  );

  wire [3:0] clk_cnt;

  reg [15:0]  apb_read_data;
  wire [5:0]  bit_num, bit_num_d;
  wire [3:0]  reg_num;
  wire [31:0] reg_wire[0:11];
  wire 	      bit_done, reg_done, startn;
  reg [31:0]  shift_out;
  wire [31:0]  data_out;
  
/*
  ffas #(32) ff_reg0 (reg_wire[0][31:0], 32'h0000_0017, 32'h0000_0017, clk_cnt[3], rstn);
  ffas #(32) ff_reg1 (reg_wire[1][31:0], 32'h0000_008d, 32'h0000_008d, clk_cnt[3], rstn);
  ffas #(32) ff_reg2 (reg_wire[2][31:0], 32'h0000_001c, 32'h0000_001c, clk_cnt[3], rstn);
  ffas #(32) ff_reg3 (reg_wire[3][31:0], 32'h2800_1409, 32'h2800_1409, clk_cnt[3], rstn);
  ffas #(32) ff_reg4 (reg_wire[4][31:0], 32'h0111_cf88, 32'h0111_cf88, clk_cnt[3], rstn);
  ffas #(32) ff_reg5 (reg_wire[5][31:0], 32'h001f_3326, 32'h001f_3326, clk_cnt[3], rstn);
  ffas #(32) ff_reg6 (reg_wire[6][31:0], 32'ha000_0005, 32'ha000_0005, clk_cnt[3], rstn);
  ffas #(32) ff_reg7 (reg_wire[7][31:0], 32'h0000_1644, 32'h0000_1644, clk_cnt[3], rstn);
  ffas #(32) ff_reg8 (reg_wire[8][31:0], 32'h0180_7c03, 32'h0180_7c03, clk_cnt[3], rstn);
  ffas #(32) ff_reg9 (reg_wire[9][31:0], 32'h0400_0642, 32'h0400_0642, clk_cnt[3], rstn);
ffas #(32) ff_reg10 (reg_wire[10][31:0], 32'h0000_0011, 32'h0000_0011, clk_cnt[3], rstn);
ffas #(32) ff_reg11 (reg_wire[11][31:0], 32'h0000_0140, 32'h0000_0140, clk_cnt[3], rstn);
*/

  always @(*)
    case(reg_num)
      4'h0 : shift_out = 32'h0000_0017;
      4'h1 : shift_out = 32'h0000_008d;
      4'h2 : shift_out = 32'h0000_001c;
      4'h3 : shift_out = 32'h2800_1409;
      4'h4 : shift_out = 32'h0111_cf88;
      4'h5 : shift_out = 32'h001f_3326;
      4'h6 : shift_out = 32'ha000_0005;
      4'h7 : shift_out = 32'h0000_2644;
      4'h8 : shift_out = 32'h0180_7703;
      4'h9 : shift_out = 32'h0400_0642;
      4'hA : shift_out = 32'h0000_0011;
      4'hB : shift_out = 32'h0000_0240;
      default : shift_out = 32'h0000_0017;
    endcase // case(reg_num)
           		 
  counter #(4) clk_cntr (clk_cnt, , 4'h0, 4'hf, pclk, rstn, 1'b1, 1'b1);
  counter #(6) prog_seq_bits (bit_num, bit_done, 6'h0, 6'h3f, clk_cnt[3], (rstn && (!restart)), 1'b1, (reg_num!=4'hB));
  counter #(4) prog_seq_reg (reg_num, reg_done, 4'h0, 4'hB, clk_cnt[3], (rstn && (!restart)), bit_done, 1'b0);
  ffas #(6) bit_num_dly (bit_num_d, bit_num, 6'h0, clk_cnt[3], rstn);
  ffas #(1) start_dly (startn, (rstn && !restart), 1'b0, clk_cnt[3], rstn);

  assign enl = ~(bit_num_d[5] ^ lmk_sync);
  assign c   = (!bit_num_d[5] && startn) && ~clk_cnt[3];
  assign d   = (startn ^ bit_num_d[5]) && shift_out[~bit_num_d[4:0]];
  assign lmk_sync = !(reg_done && (bit_num_d[5] && ((&bit_num_d[2:1]) | (|bit_num_d[4:3]))));
  assign lmk_done = reg_done && bit_done;
  
endmodule // lmk_spi

// Local Variables:
// verilog-library-directories : (".")
// End:
