#if MODBUS_SUPPORT

#define MODBUS_READ_COIL 0x1
#define MODBUS_READ_DISCRETE_INPUT 0x2
#define MODBUS_READ_HOLDING_REGISTERS 0x3
#define MODBUS_READ_INPUT_REGISTERS 0x4
#define MODBUS_WRITE_SINGLE_COIL 0x5
#define MODBUS_WRITE_SINGLE_REGISTERS 0x6
#define MODBUS_WRITE_MULTIPLE_COILS  0x7
#define MODBUS_WRITE_MULTIPLE_REGISTERS 0x8

 typedef enum
{
MODBUS_RTU_STATE_IDLE,
MODBUS_RTU_STATE_INIT,
MODBUS_RTU_STATE_FRAME_START,
MODBUS_RTU_STATE_SLAVE_ID,
MODBUS_RTU_STATE_FUNC_ID,
MODBUS_RTU_STATE_FRAME_LENGTH,
MODBUS_RTU_STATE_FRAME_CRC1,
MODBUS_RTU_STATE_FRAME_CRC2,
MODBUS_RTU_STATE_COIL_ADDRESS_HIGH,
MODBUS_RTU_STATE_COIL_ADDRESS_LOW,
MODBUS_RTU_STATE_WRITE_DATA_HIGH,
MODBUS_RTU_STATE_WRITE_DATA_LOW,
MODBUS_RTU_STATE_FRAME_SENT,        
MODBUS_RTU_STATE_INVALID        
}
tMODBUSRTUState;

tMODBUSRTUState modbusRTUState;

#define RTU_MAX_LENGTH  256

unsigned int  g_serialRecvCount;
unsigned char g_mbapRTU[1024];
unsigned char g_slaveAddressRTU;
unsigned char g_funcIDRTU;
unsigned char g_frameLengthRTU;
unsigned char g_frameDataCount;
unsigned char g_crcRTU[2];
unsigned char g_enableTimer;
unsigned char g_timeOut;

void initModbusRTUStatemachine(void);
void ResetModbusRTUStatemachine(void);
void CheckModbusRTUStatemachine(void);
void SetInitModbusRTUStatemachine(void);

void ModbusRTURecvTCPSend(unsigned char ucChar);

void ModbusTimerInit(void);
void ModbusTimerArm(void);
void ModbusTimerDisArm(void);
#endif 
