//*****************************************************************************
//
// hw_uart.h - Macros and defines used when accessing the UART hardware.
//
// Copyright (c) 2005-2009 Texas Instruments Incorporated. All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 5450 of the Stellaris Firmware Development Package.
//
//*****************************************************************************

#ifndef __HW_UART_H__
#define __HW_UART_H__

//*****************************************************************************
//
// The following are defines for the UART Register offsets.
//
//*****************************************************************************
#define UART_O_DR               0x00000000  // Data Register
#define UART_O_RSR              0x00000004  // Receive Status Register (read)
#define UART_O_ECR              0x00000004  // Error Clear Register (write)
#define UART_O_FR               0x00000018  // Flag Register (read only)
#define UART_O_ILPR             0x00000020  // UART IrDA Low-Power Register
#define UART_O_IBRD             0x00000024  // Integer Baud Rate Divisor Reg
#define UART_O_FBRD             0x00000028  // Fractional Baud Rate Divisor Reg
#define UART_O_LCRH             0x0000002C  // UART Line Control
#define UART_O_CTL              0x00000030  // Control Register
#define UART_O_IFLS             0x00000034  // Interrupt FIFO Level Select Reg
#define UART_O_IM               0x00000038  // Interrupt Mask Set/Clear Reg
#define UART_O_RIS              0x0000003C  // Raw Interrupt Status Register
#define UART_O_MIS              0x00000040  // Masked Interrupt Status Register
#define UART_O_ICR              0x00000044  // Interrupt Clear Register
#define UART_O_DMACTL           0x00000048  // UART DMA Control
#define UART_O_LCTL             0x00000090  // UART LIN Control
#define UART_O_LSS              0x00000094  // UART LIN Snap Shot
#define UART_O_LTIM             0x00000098  // UART LIN Timer

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_DR register.
//
//*****************************************************************************
#define UART_DR_OE              0x00000800  // Overrun Error
#define UART_DR_BE              0x00000400  // Break Error
#define UART_DR_PE              0x00000200  // Parity Error
#define UART_DR_FE              0x00000100  // Framing Error
#define UART_DR_DATA_M          0x000000FF  // Data Transmitted or Received
#define UART_DR_DATA_S          0

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_RSR register.
//
//*****************************************************************************
#define UART_RSR_OE             0x00000008  // Overrun Error
#define UART_RSR_BE             0x00000004  // Break Error
#define UART_RSR_PE             0x00000002  // Parity Error
#define UART_RSR_FE             0x00000001  // Framing Error

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_ECR register.
//
//*****************************************************************************
#define UART_ECR_DATA_M         0x000000FF  // Error Clear
#define UART_ECR_DATA_S         0

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_FR register.
//
//*****************************************************************************
#define UART_FR_RI              0x00000100  // Ring Indicator
#define UART_FR_TXFE            0x00000080  // TX FIFO Empty
#define UART_FR_RXFF            0x00000040  // RX FIFO Full
#define UART_FR_TXFF            0x00000020  // TX FIFO Full
#define UART_FR_RXFE            0x00000010  // RX FIFO Empty
#define UART_FR_BUSY            0x00000008  // UART Busy
#define UART_FR_DCD             0x00000004  // Data Carrier Detect
#define UART_FR_DSR             0x00000002  // Data Set Ready
#define UART_FR_CTS             0x00000001  // Clear To Send

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_ILPR register.
//
//*****************************************************************************
#define UART_ILPR_ILPDVSR_M     0x000000FF  // IrDA Low-Power Divisor
#define UART_ILPR_ILPDVSR_S     0

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_IBRD register.
//
//*****************************************************************************
#define UART_IBRD_DIVINT_M      0x0000FFFF  // Integer Baud-Rate Divisor
#define UART_IBRD_DIVINT_S      0

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_FBRD register.
//
//*****************************************************************************
#define UART_FBRD_DIVFRAC_M     0x0000003F  // Fractional Baud-Rate Divisor
#define UART_FBRD_DIVFRAC_S     0

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_LCRH register.
//
//*****************************************************************************
#define UART_LCRH_SPS           0x00000080  // UART Stick Parity Select
#define UART_LCRH_WLEN_M        0x00000060  // UART Word Length
#define UART_LCRH_WLEN_5        0x00000000  // 5 bits (default)
#define UART_LCRH_WLEN_6        0x00000020  // 6 bits
#define UART_LCRH_WLEN_7        0x00000040  // 7 bits
#define UART_LCRH_WLEN_8        0x00000060  // 8 bits
#define UART_LCRH_FEN           0x00000010  // UART Enable FIFOs
#define UART_LCRH_STP2          0x00000008  // UART Two Stop Bits Select
#define UART_LCRH_EPS           0x00000004  // UART Even Parity Select
#define UART_LCRH_PEN           0x00000002  // UART Parity Enable
#define UART_LCRH_BRK           0x00000001  // UART Send Break

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_CTL register.
//
//*****************************************************************************
#define UART_CTL_CTSEN          0x00008000  // Enable Clear To Send
#define UART_CTL_RTSEN          0x00004000  // Enable Request to Send
#define UART_CTL_RTS            0x00000800  // Request to Send
#define UART_CTL_DTR            0x00000400  // Data Terminal Ready
#define UART_CTL_RXE            0x00000200  // Receive Enable
#define UART_CTL_TXE            0x00000100  // Transmit Enable
#define UART_CTL_LBE            0x00000080  // Loopback Enable
#define UART_CTL_LIN            0x00000040  // LIN Mode Enable
#define UART_CTL_HSE            0x00000020  // High-Speed Enable
#define UART_CTL_EOT            0x00000010  // End of Transmission
#define UART_CTL_SMART          0x00000008  // ISO 7816 Smart Card Support
#define UART_CTL_SIRLP          0x00000004  // SIR (IrDA) Low Power Enable
#define UART_CTL_SIREN          0x00000002  // SIR (IrDA) Enable
#define UART_CTL_UARTEN         0x00000001  // UART Enable

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_IFLS register.
//
//*****************************************************************************
#define UART_IFLS_RX_M          0x00000038  // RX FIFO Level Interrupt Mask
#define UART_IFLS_RX1_8         0x00000000  // 1/8 Full
#define UART_IFLS_RX2_8         0x00000008  // 1/4 Full
#define UART_IFLS_RX4_8         0x00000010  // 1/2 Full
#define UART_IFLS_RX6_8         0x00000018  // 3/4 Full
#define UART_IFLS_RX7_8         0x00000020  // 7/8 Full
#define UART_IFLS_TX_M          0x00000007  // TX FIFO Level Interrupt Mask
#define UART_IFLS_TX1_8         0x00000000  // 1/8 Full
#define UART_IFLS_TX2_8         0x00000001  // 1/4 Full
#define UART_IFLS_TX4_8         0x00000002  // 1/2 Full
#define UART_IFLS_TX6_8         0x00000003  // 3/4 Full
#define UART_IFLS_TX7_8         0x00000004  // 7/8 Full

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_IM register.
//
//*****************************************************************************
#define UART_IM_LME5IM          0x00008000  // LIN Mode Edge 5 Interrupt Mask
#define UART_IM_LME1IM          0x00004000  // LIN Mode Edge 1 Interrupt Mask
#define UART_IM_LMSBIM          0x00002000  // LIN Mode Sync Break Interrupt
                                            // Mask
#define UART_IM_OEIM            0x00000400  // Overrun Error Interrupt Mask
#define UART_IM_BEIM            0x00000200  // Break Error Interrupt Mask
#define UART_IM_PEIM            0x00000100  // Parity Error Interrupt Mask
#define UART_IM_FEIM            0x00000080  // Framing Error Interrupt Mask
#define UART_IM_RTIM            0x00000040  // Receive Timeout Interrupt Mask
#define UART_IM_TXIM            0x00000020  // Transmit Interrupt Mask
#define UART_IM_RXIM            0x00000010  // Receive Interrupt Mask
#define UART_IM_DSRMIM          0x00000008  // UART Data Set Ready Modem
                                            // Interrupt Mask
#define UART_IM_DCDMIM          0x00000004  // UART Data Carrier Detect Modem
                                            // Interrupt Mask
#define UART_IM_CTSMIM          0x00000002  // UART Clear to Send Modem
                                            // Interrupt Mask
#define UART_IM_RIMIM           0x00000001  // UART Ring Indicator Modem
                                            // Interrupt Mask

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_RIS register.
//
//*****************************************************************************
#define UART_RIS_LME5RIS        0x00008000  // LIN Mode Edge 5 Raw Interrupt
                                            // Status
#define UART_RIS_LME1RIS        0x00004000  // LIN Mode Edge 1 Raw Interrupt
                                            // Status
#define UART_RIS_LMSBRIS        0x00002000  // LIN Mode Sync Break Raw
                                            // Interrupt Status
#define UART_RIS_OERIS          0x00000400  // Overrun Error Interrupt Status
#define UART_RIS_BERIS          0x00000200  // Break Error Interrupt Status
#define UART_RIS_PERIS          0x00000100  // Parity Error Interrupt Status
#define UART_RIS_FERIS          0x00000080  // Framing Error Interrupt Status
#define UART_RIS_RTRIS          0x00000040  // Receive Timeout Interrupt Status
#define UART_RIS_TXRIS          0x00000020  // Transmit Interrupt Status
#define UART_RIS_RXRIS          0x00000010  // Receive Interrupt Status
#define UART_RIS_DSRRIS         0x00000008  // UART Data Set Ready Modem Raw
                                            // Interrupt Status
#define UART_RIS_DCDRIS         0x00000004  // UART Data Carrier Detect Modem
                                            // Raw Interrupt Status
#define UART_RIS_CTSRIS         0x00000002  // UART Clear to Send Modem Raw
                                            // Interrupt Status
#define UART_RIS_RIRIS          0x00000001  // UART Ring Indicator Modem Raw
                                            // Interrupt Status

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_MIS register.
//
//*****************************************************************************
#define UART_MIS_LME5MIS        0x00008000  // LIN Mode Edge 5 Masked Interrupt
                                            // Status
#define UART_MIS_LME1MIS        0x00004000  // LIN Mode Edge 1 Masked Interrupt
                                            // Status
#define UART_MIS_LMSBMIS        0x00002000  // LIN Mode Sync Break Masked
                                            // Interrupt Status
#define UART_MIS_OEMIS          0x00000400  // Overrun Error Interrupt Status
#define UART_MIS_BEMIS          0x00000200  // Break Error Interrupt Status
#define UART_MIS_PEMIS          0x00000100  // Parity Error Interrupt Status
#define UART_MIS_FEMIS          0x00000080  // Framing Error Interrupt Status
#define UART_MIS_RTMIS          0x00000040  // Receive Timeout Interrupt Status
#define UART_MIS_TXMIS          0x00000020  // Transmit Interrupt Status
#define UART_MIS_RXMIS          0x00000010  // Receive Interrupt Status
#define UART_MIS_DSRMIS         0x00000008  // UART Data Set Ready Modem Masked
                                            // Interrupt Status
#define UART_MIS_DCDMIS         0x00000004  // UART Data Carrier Detect odem
                                            // Masked Interrupt Status
#define UART_MIS_CTSMIS         0x00000002  // UART Clear to Send Modem Masked
                                            // Interrupt Status
#define UART_MIS_RIMIS          0x00000001  // UART Ring Indicator Modem Masked
                                            // Interrupt Status

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_ICR register.
//
//*****************************************************************************
#define UART_ICR_LME5MIC        0x00008000  // LIN Mode Edge 5 Interrupt Clear
#define UART_ICR_LME1MIC        0x00004000  // LIN Mode Edge 1 Interrupt Clear
#define UART_ICR_LMSBMIC        0x00002000  // LIN Mode Sync Break Interrupt
                                            // Clear
#define UART_ICR_OEIC           0x00000400  // Overrun Error Interrupt Clear
#define UART_ICR_BEIC           0x00000200  // Break Error Interrupt Clear
#define UART_ICR_PEIC           0x00000100  // Parity Error Interrupt Clear
#define UART_ICR_FEIC           0x00000080  // Framing Error Interrupt Clear
#define UART_ICR_RTIC           0x00000040  // Receive Timeout Interrupt Clear
#define UART_ICR_TXIC           0x00000020  // Transmit Interrupt Clear
#define UART_ICR_RXIC           0x00000010  // Receive Interrupt Clear
#define UART_ICR_DSRMIC         0x00000008  // UART Data Set Ready Modem
                                            // Interrupt Clear
#define UART_ICR_DCDMIC         0x00000004  // UART Data Carrier Detect odem
                                            // Interrupt Clear
#define UART_ICR_CTSMIC         0x00000002  // UART Clear to Send Modem
                                            // Interrupt Clear
#define UART_ICR_RIMIC          0x00000001  // UART Ring Indicator Modem
                                            // Interrupt Clear

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_DMACTL register.
//
//*****************************************************************************
#define UART_DMACTL_DMAERR      0x00000004  // DMA on Error
#define UART_DMACTL_TXDMAE      0x00000002  // Transmit DMA Enable
#define UART_DMACTL_RXDMAE      0x00000001  // Receive DMA Enable

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_LCTL register.
//
//*****************************************************************************
#define UART_LCTL_BLEN_M        0x00000030  // Sync Break Length
#define UART_LCTL_BLEN_13T      0x00000000  // Sync break length is 13T bits
                                            // (default)
#define UART_LCTL_BLEN_14T      0x00000010  // Sync break length is 14T bits
#define UART_LCTL_BLEN_15T      0x00000020  // Sync break length is 15T bits
#define UART_LCTL_BLEN_16T      0x00000030  // Sync break length is 16T bits
#define UART_LCTL_MASTER        0x00000001  // LIN Master Enable

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_LSS register.
//
//*****************************************************************************
#define UART_LSS_TSS_M          0x0000FFFF  // Timer Snap Shot
#define UART_LSS_TSS_S          0

//*****************************************************************************
//
// The following are defines for the bit fields in the UART_O_LTIM register.
//
//*****************************************************************************
#define UART_LTIM_TIMER_M       0x0000FFFF  // Timer Value
#define UART_LTIM_TIMER_S       0

//*****************************************************************************
//
// The following definitions are deprecated.
//
//*****************************************************************************
#ifndef DEPRECATED

//*****************************************************************************
//
// The following are deprecated defines for the UART Register offsets.
//
//*****************************************************************************
#define UART_O_LCR_H            0x0000002C  // Line Control Register, HIGH byte
#define UART_O_PeriphID4        0x00000FD0
#define UART_O_PeriphID5        0x00000FD4
#define UART_O_PeriphID6        0x00000FD8
#define UART_O_PeriphID7        0x00000FDC
#define UART_O_PeriphID0        0x00000FE0
#define UART_O_PeriphID1        0x00000FE4
#define UART_O_PeriphID2        0x00000FE8
#define UART_O_PeriphID3        0x00000FEC
#define UART_O_PCellID0         0x00000FF0
#define UART_O_PCellID1         0x00000FF4
#define UART_O_PCellID2         0x00000FF8
#define UART_O_PCellID3         0x00000FFC

//*****************************************************************************
//
// The following are deprecated defines for the bit fields in the UART_O_DR
// register.
//
//*****************************************************************************
#define UART_DR_DATA_MASK       0x000000FF  // UART data

//*****************************************************************************
//
// The following are deprecated defines for the bit fields in the UART_O_IBRD
// register.
//
//*****************************************************************************
#define UART_IBRD_DIVINT_MASK   0x0000FFFF  // Integer baud-rate divisor

//*****************************************************************************
//
// The following are deprecated defines for the bit fields in the UART_O_FBRD
// register.
//
//*****************************************************************************
#define UART_FBRD_DIVFRAC_MASK  0x0000003F  // Fractional baud-rate divisor

//*****************************************************************************
//
// The following are deprecated defines for the bit fields in the UART_O_LCR_H
// register.
//
//*****************************************************************************
#define UART_LCR_H_SPS          0x00000080  // Stick Parity Select
#define UART_LCR_H_WLEN         0x00000060  // Word length
#define UART_LCR_H_WLEN_5       0x00000000  // 5 bit data
#define UART_LCR_H_WLEN_6       0x00000020  // 6 bit data
#define UART_LCR_H_WLEN_7       0x00000040  // 7 bit data
#define UART_LCR_H_WLEN_8       0x00000060  // 8 bit data
#define UART_LCR_H_FEN          0x00000010  // Enable FIFO
#define UART_LCR_H_STP2         0x00000008  // Two Stop Bits Select
#define UART_LCR_H_EPS          0x00000004  // Even Parity Select
#define UART_LCR_H_PEN          0x00000002  // Parity Enable
#define UART_LCR_H_BRK          0x00000001  // Send Break

//*****************************************************************************
//
// The following are deprecated defines for the bit fields in the UART_O_IFLS
// register.
//
//*****************************************************************************
#define UART_IFLS_RX_MASK       0x00000038  // RX FIFO level mask
#define UART_IFLS_TX_MASK       0x00000007  // TX FIFO level mask

//*****************************************************************************
//
// The following are deprecated defines for the bit fields in the UART_O_ICR
// register.
//
//*****************************************************************************
#define UART_RSR_ANY            (UART_RSR_OE | UART_RSR_BE | UART_RSR_PE | \
                                 UART_RSR_FE)

//*****************************************************************************
//
// The following are deprecated defines for the Reset Values for UART
// Registers.
//
//*****************************************************************************
#define UART_RV_CTL             0x00000300
#define UART_RV_PCellID1        0x000000F0
#define UART_RV_PCellID3        0x000000B1
#define UART_RV_FR              0x00000090
#define UART_RV_PeriphID2       0x00000018
#define UART_RV_IFLS            0x00000012
#define UART_RV_PeriphID0       0x00000011
#define UART_RV_PCellID0        0x0000000D
#define UART_RV_PCellID2        0x00000005
#define UART_RV_PeriphID3       0x00000001
#define UART_RV_PeriphID4       0x00000000
#define UART_RV_LCR_H           0x00000000
#define UART_RV_PeriphID6       0x00000000
#define UART_RV_DR              0x00000000
#define UART_RV_RSR             0x00000000
#define UART_RV_ECR             0x00000000
#define UART_RV_PeriphID5       0x00000000
#define UART_RV_RIS             0x00000000
#define UART_RV_FBRD            0x00000000
#define UART_RV_IM              0x00000000
#define UART_RV_MIS             0x00000000
#define UART_RV_ICR             0x00000000
#define UART_RV_PeriphID1       0x00000000
#define UART_RV_PeriphID7       0x00000000
#define UART_RV_IBRD            0x00000000

#endif

#endif // __HW_UART_H__
