//
// Copyright (c) 2012-2021 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
//
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
//
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
//
//
//*****************************************************************************
/*
 * fee.h
 *
 *--------------------------------------------------------------
 * Revision History
 *--------------------------------------------------------------
 * Version Date       Author    Change ID     Description
 *--------------------------------------------------------------
* 00.01.00 21Jan2021 RM Crosby 0000000000000 Initial Version
 */

#ifndef FEE_H_
#define FEE_H_
#if((NUMBER_OF_DATASETS > 6u) || (NUMBER_OF_DATASETS == 0u))
#error("NUMBER_OF_DATASETS must be from 1 to 6")
#endif
#if ((EE_STARTING_BLOCK + (NUMBER_OF_DATASETS * 16u)) > 96u)
#error("EE Starting Block does not leave enough room for all datasets")
#endif
#define MAX_SIZE_DATASET 124u

#define IMAGES_PER_SECTOR0 (128u / (SIZE_DATASET0 + 4u))
#define IMAGES_PER_SECTOR1 (128u / (SIZE_DATASET1 + 4u))
#define IMAGES_PER_SECTOR2 (128u / (SIZE_DATASET2 + 4u))
#define IMAGES_PER_SECTOR3 (128u / (SIZE_DATASET3 + 4u))
#define IMAGES_PER_SECTOR4 (128u / (SIZE_DATASET4 + 4u))
#define IMAGES_PER_SECTOR5 (128u / (SIZE_DATASET5 + 4u))

#if ((SIZE_DATASET0 == 0u) || (SIZE_DATASET0 > MAX_SIZE_DATASET))
#error("Illegal Dataset0 size")
#endif
#define MAX_IMAGES_PER_SECTOR IMAGES_PER_SECTOR0
#if(NUMBER_OF_DATASETS > 1u)
#if ((SIZE_DATASET1 == 0u) || (SIZE_DATASET1 > MAX_SIZE_DATASET))
#error("Illegal Dataset1 size")
#endif
#if (IMAGES_PER_SECTOR1 > MAX_IMAGES_PER_SECTOR)
#undef MAX_IMAGES_PER_SECTOR
#define MAX_IMAGES_PER_SECTOR IMAGES_PER_SECTOR1
#endif
#if(NUMBER_OF_DATASETS > 2u)
#if ((SIZE_DATASET2 == 0u) || (SIZE_DATASET2 > MAX_SIZE_DATASET))
#error("Illegal Dataset2 size")
#endif
#if (IMAGES_PER_SECTOR2 > MAX_IMAGES_PER_SECTOR)
#undef MAX_IMAGES_PER_SECTOR
#define MAX_IMAGES_PER_SECTOR IMAGES_PER_SECTOR2
#endif
#if(NUMBER_OF_DATASETS > 3u)
#if ((SIZE_DATASET3 == 0u) || (SIZE_DATASET3 > MAX_SIZE_DATASET))
#error("Illegal Dataset3 size")
#endif
#if (IMAGES_PER_SECTOR3 > MAX_IMAGES_PER_SECTOR)
#undef MAX_IMAGES_PER_SECTOR
#define MAX_IMAGES_PER_SECTOR IMAGES_PER_SECTOR3
#endif
#if(NUMBER_OF_DATASETS > 4u)
#if ((SIZE_DATASET4 == 0u) || (SIZE_DATASET4 > MAX_SIZE_DATASET))
#error("Illegal Dataset4 size")
#endif
#if (IMAGES_PER_SECTOR4 > MAX_IMAGES_PER_SECTOR)
#undef MAX_IMAGES_PER_SECTOR
#define MAX_IMAGES_PER_SECTOR IMAGES_PER_SECTOR4
#endif
#if(NUMBER_OF_DATASETS > 5u)
#if ((SIZE_DATASET5 == 0u) || (SIZE_DATASET5 > MAX_SIZE_DATASET))
#error("Illegal Dataset5 size")
#endif
#if (IMAGES_PER_SECTOR5 > MAX_IMAGES_PER_SECTOR)
#undef MAX_IMAGES_PER_SECTOR
#define MAX_IMAGES_PER_SECTOR IMAGES_PER_SECTOR5
#endif
#endif // (NUMBER_OF_DATASETS > 5u)
#endif // (NUMBER_OF_DATASETS > 4u)
#endif // (NUMBER_OF_DATASETS > 3u)
#endif // (NUMBER_OF_DATASETS > 2u)
#endif // (NUMBER_OF_DATASETS > 1u)
/* Definitions of the location and size of the EEPROM area used.
 * The ((EE_EEPROM_SIZE + 4) x HE_IMAGES_PER_SECTOR) must be equal to or less
 * than the number of words in the sector. Nothing other than the high endurance
 * EEPROM data should be stored in the two sectors used.
 */
//#define EE_EEPROM_SIZE 32u    /* Number of 32-bit words in the dataset      */
#define EE_BYTES_PER_BLOCK 64u   /* All TM4C parts are 64 bytes per block     */
#define EE_BLANK_CRC 0xFFFFFFFFu /* CRC value for all blank data              */
#define EE_BLOCKS_PER_SECTOR 8u  /* Must be a multiple of the physical blocks
                                   per sector. TM4C129x is multiples of 8     */
#define COUNT1_OFFSET 0u
#define COUNT2_OFFSET 4u
#define COUNT3_OFFSET 8u
#define CRC_OFFSET 12u
#define DATA_OFFSET 16u
#define CONTROL_WORDS 4u
#define SECTOR_SIZE 512u
#define MAX_RETRIES 7u

typedef enum
{
    FEE_UNINIT,
    FEE_IDLE,
    FEE_BUSY,
}tFeeStatus;

typedef enum
{
    FEE_OK,
    FEE_NOT_OK,
    FEE_OLD
}tFeeReturn;

typedef enum
{
    FEE_JOB_OK,
    FEE_JOB_PENDING,
    FEE_JOB_FAILED,
}tFeeJobResult;

typedef enum
{
    EEStateIdle,
    EEStateProgrammingFirstCounter,
    EEStateProgrammingSecondCounter,
    EEStateProgrammingData,
    EEStateProgrammingCRC,
    EEStateProgrammingThirdCounter,
    EEStateInitializeDataset,
    EEStateFinishFormat,
}tEEState;

typedef struct
{
    uint8_t ui8Words;
    uint8_t ui8Images;
}tFeeDataset;


typedef struct
{
    uint8_t ui8ImageNumber;
    uint8_t ui8Dummy; /* for data alignment only */
    uint16_t ui16ImageAddress;
    uint32_t ui32ImageCount3;
}tFeeImageSortList;

typedef struct
{
    uint8_t ui8MajorVersion;
    uint8_t ui8MinorVersion;
}tFeeVersion;

extern tFeeReturn FeeInit(void);
extern tFeeReturn FeeCheckDatasetValid(uint8_t ui8Dataset);
extern void FeeFormat(uint8_t ui8Dataset);
extern tFeeReturn FeeRead(uint8_t ui8Dataset, uint32_t* pui32DataBuffer);
extern tFeeReturn FeeWrite(uint8_t ui8Dataset, uint32_t* pui32DataBuffer);
extern tFeeStatus FeeGetStatus(void);
extern tFeeJobResult FeeGetJobResult(void);
extern void FeeMainFunction(void);
extern uint32_t FeeGetDatasetCounter(uint8_t ui8Dataset);
extern tFeeVersion FeeGetVersionInformation(void);

#endif /* FEE_H_ */
