//
// Copyright (c) 2012-2021 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
//
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
//
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
//
//
//*****************************************************************************
/*
 * feeConfig.h
 *
 *--------------------------------------------------------------
 * Revision History
 *--------------------------------------------------------------
 * Version Date       Author    Change ID     Description
 *--------------------------------------------------------------
* 00.01.00 21Jan2021 RM Crosby 0000000000000 Initial Version
 */

#ifndef FEECONFIG_H_
#define FEECONFIG_H_

/* These values are to be modified by the user to configure the high endurance
 * EEPROM module.
 */
#define NUMBER_OF_DATASETS 2u
/* The size of each dataset in words, unused datasets should have a
 * size of 0, the maximum size is 124 words.*/
#define SIZE_DATASET0 4u
#define SIZE_DATASET1 4u
#define SIZE_DATASET2 0u
#define SIZE_DATASET3 0u
#define SIZE_DATASET4 0u
#define SIZE_DATASET5 0u
/* Define the starting block for the first dataset. The starting block must be
 * a multiple of eight and less than or equal to a value that allows for 16
 * blocks per dataset. For example, if using two datasets, the starting block
 * number must be less than or equal to 64, (96 - (16 * 2).
 */
#define EE_STARTING_BLOCK 64u

/* When using interrupt mode define the symbol EEPROM_INTERRUPTS */
#define EEPROM_INTERRUPTS

/* Define the settings used by the CRC module only if the hardware CRC module
 * is used in the application. This will cause the high endurance EEPROM driver
 * to save the contents of the CRC module before it uses it, and restore it
 * afterwards. The CRC module is used in Fee_Write(), Fee_Read(), Fee_Init(),
 * FeeCheckDatasetValid() and Fee_MainFunction().
 *
 * The Post Processing Result (CRCRSLTPP) cannot be restored after use by the
 * FEE driver. If a FEE driver function is called after the last write to the
 * CRC Data Input (CRCDIN) register and before reading the post processing
 * result register, the contents will be corrupt. In this case, the CRC
 * Seed (CRCSEED) register should be read instead and the post processing
 * performed by the CPU.
 */
//#include "driverlib/crc.h"
//#define CRC_SETTINGS (CRC_CFG_SIZE_8BIT | CRC_CFG_TYPE_P8005)
/* End of Customer changes */

#endif /* FEECONFIG_H_ */
