// TI Release: 28xx eCAN programming example
// Release Date: Fri Aug 4 2017
// Copyright:
// Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/*********************************************************************
* Filename: DBOTX_A.c
*                                                                    
* Description: Illustrates the operation of DBO field for a Transmit mailbox. 	
* Mailbox 11 is used in this example. 32-bits, 16-bits and 8-bit writes are  
* shown in this example. Comment as appropriate to analyze the effect of each.
*
* 
*********************************************************************/

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

void error(int);

long	i;

main() 
{

/* Create a shadow register structure for the CAN control registers. This is
 needed, since, only 32-bit access is allowed to these registers. 16-bit access
 to these registers could potentially corrupt the register contents. This is
 especially true while writing to a bit (or group of bits) among bits 16 - 31 */

struct ECAN_REGS ECanaShadow;

/* Kill Watchdog, Init PLL, Enable peripheral clocks */

    InitSysCtrl();

/* Initialize the CAN module */

    InitECana();
    InitECanGpio();

    EALLOW;

/* Write to the MSGID field  */
    
    ECanaMboxes.MBOX11.MSGID.all = 0x80000011; // Ext Identifier (ID = 11)
    
/* Configure Mailbox under test as a Transmit mailbox */

	ECanaShadow.CANMD.all = ECanaRegs.CANMD.all;	
	ECanaShadow.CANMD.bit.MD11 = 0;
	ECanaRegs.CANMD.all = ECanaShadow.CANMD.all; 
	
/* Enable Mailbox under test */
	
	ECanaShadow.CANME.all = ECanaRegs.CANME.all;	
	ECanaShadow.CANME.bit.ME11 = 1;	
	ECanaRegs.CANME.all = ECanaShadow.CANME.all; 
	
/* Write to Master Control reg */
	
	ECanaMboxes.MBOX11.MSGCTRL.bit.DLC = 8;	
	
	ECanaMboxes.MBOX11.MDH.all = 0x0; // Helps to clear the RAM to zero, so that the
	ECanaMboxes.MBOX11.MDL.all = 0x0; // effect of writes may be observed.
	
/* Write to the mailbox RAM field using 32-bit writes */ // Comment as appropriate
	
	//ECanaMboxes.MBOX11.MDH.all = 0x08070605;
	//ECanaMboxes.MBOX11.MDL.all = 0x04030201;
	
/* Write to the mailbox RAM field using 16-bit writes */ // Comment as appropriate
    
     //ECanaMboxes.MBOX11.MDL.word.LOW_WORD = 0x0201;
     //ECanaMboxes.MBOX11.MDL.word.HI_WORD  = 0x0403;
	 //ECanaMboxes.MBOX11.MDH.word.LOW_WORD = 0x0605;
	 //ECanaMboxes.MBOX11.MDH.word.HI_WORD  = 0x0807;

/* Write to the mailbox RAM field using 8-bit writes */ // Comment as appropriate	 

	 ECanaMboxes.MBOX11.MDL.byte.BYTE0 = 0;
	 ECanaMboxes.MBOX11.MDL.byte.BYTE1 = 1;
	 ECanaMboxes.MBOX11.MDL.byte.BYTE2 = 2;
	 ECanaMboxes.MBOX11.MDL.byte.BYTE3 = 3;
	 ECanaMboxes.MBOX11.MDH.byte.BYTE4 = 4;
	 ECanaMboxes.MBOX11.MDH.byte.BYTE5 = 5;
	 ECanaMboxes.MBOX11.MDH.byte.BYTE6 = 6;
	 ECanaMboxes.MBOX11.MDH.byte.BYTE7 = 7;

/* Configure DBO bit */

	ECanaRegs.CANMC.bit.DBO = 1;			// See Note 2
	
/* Begin transmitting */   
     
     ECanaShadow.CANTRS.all = 0;			// Set TRS bit 
     ECanaShadow.CANTRS.bit.TRS11 = 1;    
     ECanaRegs.CANTRS.all = ECanaShadow.CANTRS.all;
                  
     while(ECanaRegs.CANTA.bit.TA11 == 0 ) {}  // Wait for TA11 bit to be set..
     
     ECanaShadow.CANTA.all = 0; 			  // See Note 1
     ECanaShadow.CANTA.bit.TA11 = 1;		  // Clear TA11     
     ECanaRegs.CANTA.all = ECanaShadow.CANTA.all;
     
     asm("     ESTOP0");             
}


/* 

Note 1: Initialize the "shadow-TA register" to zero before setting any bit(s)
in order to clear it (them) in the TA register. Otherwise, some other TAn bit(s)
that is (are) set could be inadvertently cleared.

Note 2: Following is the effect of DBO bit

Let the mailbox RAM contents be as follows...
615C: 0201
615D: 0403
615E: 0605
615F: 0807

When DBO = 1, the bytes will be transmitted in the following sequence:
01 02 03 04 05 06 07 08

When DBO = 0, the bytes will be transmitted in the following sequence:
04 03 02 01 08 07 06 05

CANalyzer configuration file: 1M80spRx.cfg

*/ 

