/**********************************************************************
* File: DefaultIsr_BIOS.c
* Devices: TMS320F280x, TMS320F280xx
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   12/18/07 - original (D. Alter)
**********************************************************************/
#include "F2808_example.h"				// Main include file


//---------------------------------------------------------------------
void INT13_ISR(void)						// 0x000D1A  INT13 (XINT13 or CPU Timer1)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void RTOSINT_ISR(void)						// 0x000D20  RTOSINT (CPU RTOS interrupt)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EMUINT_ISR(void) 						// 0x000D22  EMUINT (CPU emulation interrupt)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void NMI_ISR(void)							// 0x000D24  NMI (XNMI interrupt)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ILLEGAL_ISR(void)						// 0x000D26  ILLEGAL (Illegal operation trap)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER1_ISR(void)						// 0x000D28  USER1 (Software interrupt #1)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER2_ISR(void)						// 0x000D2A  USER2 (Software interrupt #2)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER3_ISR(void)						// 0x000D2C  USER3 (Software interrupt #3)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER4_ISR(void)						// 0x000D2E  USER4 (Software interrupt #4)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER5_ISR(void)						// 0x000D30  USER5 (Software interrupt #5)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER6_ISR(void)						// 0x000D32  USER6 (Software interrupt #6)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER7_ISR(void)						// 0x000D34  USER7 (Software interrupt #7)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER8_ISR(void)						// 0x000D36  USER8 (Software interrupt #8)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER9_ISR(void)						// 0x000D38  USER9 (Software interrupt #9)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER10_ISR(void)						// 0x000D3A  USER10 (Software interrupt #10)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER11_ISR(void)						// 0x000D3C  USER11 (Software interrupt #11)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void USER12_ISR(void)						// 0x000D3E  USER12 (Software interrupt #12)
{
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SEQ1INT_ISR(void)						// 0x000D40  SEQ1INT (ADC SEQ1)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SEQ2INT_ISR(void)						// 0x000D42  SEQ2INT (ADC SEQ2)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000D44 reserved

//---------------------------------------------------------------------
void XINT1_ISR(void)						// 0x000D46  XINT1
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}     

//---------------------------------------------------------------------
void XINT2_ISR(void)						// 0x000D48  XINT2
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ADCINT_ISR(void)						// 0x000D4A  ADCINT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Must acknowledge the PIE group

	SWI_post(&ADC_swi);						// post a SWI

}

//---------------------------------------------------------------------
void TINT0_ISR(void)						// 0x000D4C  TINT0 (CPU TIMER 0)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void WAKEINT_ISR(void)						// 0x000D4E  WAKEINT (LPM/WD)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	// Must acknowledge the PIE group
  
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM1_TZINT_ISR(void)					// 0x000D50  EPWM1_TZINT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM2_TZINT_ISR(void)					// 0x000D52  EPWM2_TZINT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM3_TZINT_ISR(void)					// 0x000D54  EPWM3_TZINT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;	// Must acknowledge the PIE group
  
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM4_TZINT_ISR(void)					// 0x000D56  EPWM4_TZINT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;	// Must acknowledge the PIE group
  
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM5_TZINT_ISR(void)					// 0x000D58  EPWM5_TZINT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM6_TZINT_ISR(void)					// 0x000D5A  EPWM6_TZINT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000D5C reserved
											// 0x000D5E reserved
     
//---------------------------------------------------------------------
void EPWM1_INT_ISR(void)					// 0x000D60  EPWM1_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM2_INT_ISR(void)					// 0x000D62  EPWM2_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM3_INT_ISR(void)					// 0x000D64  EPWM3_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM4_INT_ISR(void)					// 0x000D66  EPWM4_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM5_INT_ISR(void)					// 0x000D68  EPWM5_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EPWM6_INT_ISR(void)					// 0x000D6A  EPWM6_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000D6C reserved
											// 0x000D6E reserved

//---------------------------------------------------------------------
void ECAP1_INT_ISR(void)					// 0x000D70  ECAP1_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;	// Must acknowledge the PIE group
	ECap1Regs.ECCLR.bit.INT = 1;			// Clear the ECAP1 interrupt flag
	ECap1Regs.ECCLR.bit.CEVT3 = 1;			// Clear the CEVT3 flag

// Compute the PWM duty period (rising edge to falling edge)
	PwmDuty = (int32)ECap1Regs.CAP2 - (int32)ECap1Regs.CAP1;

// Compute the PWM period (rising edge to rising edge)
	PwmPeriod = (int32)ECap1Regs.CAP3 - (int32)ECap1Regs.CAP1;
}

//---------------------------------------------------------------------
void ECAP2_INT_ISR(void)					// 0x000D72  ECAP2_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ECAP3_INT_ISR(void)					// 0x000D74  ECAP3_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ECAP4_INT_ISR(void)					// 0x000D76  ECAP4_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000D78 reserved
											// 0x000D7A reserved
											// 0x000D7C reserved
											// 0x000D7E reserved

//---------------------------------------------------------------------
void EQEP1_INT_ISR(void)					// 0x000D80  EQEP1_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;	// Must acknowledge the PIE group
 
// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void EQEP2_INT_ISR(void)					// 0x000D82  EQEP2_INT
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000D84 reserved
											// 0x000D86 reserved
											// 0x000D88 reserved
											// 0x000D8A reserved
											// 0x000D8C reserved
											// 0x000D8E reserved

//---------------------------------------------------------------------
void SPIRXINTA_ISR(void)					// 0x000D90  SPIRXINTA (SPI-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SPITXINTA_ISR(void)					// 0x000D92  SPITXINTA (SPI-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SPIRXINTB_ISR(void)					// 0x000D94  SPIRXINTB (SPI-B)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SPITXINTB_ISR(void)					// 0x000D96  SPITXINTB (SPI-B)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SPIRXINTC_ISR(void)					// 0x000D98  SPIRXINTC (SPI-C)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SPITXINTC_ISR(void)					// 0x000D9A  SPITXINTC (SPI-C)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SPIRXINTD_ISR(void)					// 0x000D9C  SPIRXINTD (SPI-D)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SPITXINTD_ISR(void)					// 0x000D9E  SPITXINTD (SPI-D)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000DA0 reserved
											// 0x000DA2 reserved
											// 0x000DA4 reserved
											// 0x000DA6 reserved
											// 0x000DA8 reserved
											// 0x000DAA reserved
											// 0x000DAC reserved
											// 0x000DAE reserved

//---------------------------------------------------------------------
void I2CINT1A_ISR(void)						// 0x000DB0  I2CINT1A (I2C-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void I2CINT2A_ISR(void)						// 0x000DB2  I2CINT2A (I2C-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000DB4 reserved
											// 0x000DB6 reserved
											// 0x000DB8 reserved
											// 0x000DBA reserved
											// 0x000DBC reserved
											// 0x000DBE reserved

//---------------------------------------------------------------------
void SCIRXINTA_ISR(void)					// 0x000DC0  SCIRXINTA (SCI-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SCITXINTA_ISR(void)					// 0x000DC2  SCITXINTA (SCI-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SCIRXINTB_ISR(void)					// 0x000DC4  SCIRXINTB (SCI-B)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void SCITXINTB_ISR(void)					// 0x000DC6  SCITXINTB (SCI-B)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ECAN0INTA_ISR(void)					// 0x000DC8  ECAN0_INTA (ECAN-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ECAN1INTA_ISR(void)					// 0x000DCA  ECAN1_INTA (ECAN-A)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ECAN0INTB_ISR(void)					// 0x000DCC  ECAN0_INTB (ECAN-B)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
void ECAN1INTB_ISR(void)					// 0x000DCE  ECAN1_INTB (ECAN-B)
{
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;	// Must acknowledge the PIE group

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");						// Emulator Halt instruction
	while(1);
}

//---------------------------------------------------------------------
											// 0x000DD0 reserved
											// 0x000DD2 reserved
											// 0x000DD4 reserved
											// 0x000DD6 reserved
											// 0x000DD8 reserved
											// 0x000DDA reserved
											// 0x000DDC reserved
											// 0x000DDE reserved

//---------------------------------------------------------------------
											// 0x000DE0 reserved
											// 0x000DE2 reserved
											// 0x000DE4 reserved
											// 0x000DE6 reserved
											// 0x000DE8 reserved
											// 0x000DEA reserved
											// 0x000DEC reserved
											// 0x000DEE reserved

//---------------------------------------------------------------------
											// 0x000DF0 reserved
											// 0x000DF2 reserved
											// 0x000DF4 reserved
											// 0x000DF6 reserved
											// 0x000DF8 reserved
											// 0x000DFA reserved
											// 0x000DFC reserved
											// 0x000DFE reserved

//---------------------------------------------------------------------
interrupt void rsvd_ISR(void)					// Reserved PIE vectors
{
// This ISR is for reserved PIE vectors.  It should never be reached by
// properly executing code.  If you get here, it means something is wrong.

// Next two lines for debug only - remove after inserting your ISR
	asm (" ESTOP0");							// Emulator Halt instruction
	while(1);
}


//--- end of file -----------------------------------------------------
