/**********************************************************************
* File: main_nonBIOS.c
* Devices: TMS320F281x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   12/18/07 - original (D. Alter)
**********************************************************************/
#include "F2812_example.h"				// Main include file

//--- Global Variables
Uint16 AdcBuf[ADC_BUF_LEN];				// ADC data buffer allocation
Uint32 PwmDuty;							// Measured PWM duty cycle
Uint16 PwmFalling;						// Captured falling edge timestamp
Uint16 PwmRising;						// Captured rising edge timestamp


/**********************************************************************
* Function: main()
*
* Description: Main function for F281x example.
**********************************************************************/
void main(void)
{
//--- CPU Initialization
	InitSysCtrl();						// Initialize the CPU
	InitPieCtrl();						// Initialize and enable the PIE
	InitWatchdog();						// Initialize the Watchdog Timer
	InitGpio();							// Initialize the shared GPIO pins
	InitXintf();						// Initialize the external memory interface

#ifdef EXAMPLE_FLASH					// EXAMPLE_FLASH, if defined, is in CCS project options

//--- Copy all Flash sections that need to run from RAM (use memcpy() from RTS library)

// Section secureRamFuncs contains user defined code that runs from CSM secured RAM
	memcpy(&secureRamFuncs_runstart, &secureRamFuncs_loadstart, (Uint32)&secureRamFuncs_loadsize);

//--- Initialize the Flash and OTP
	InitFlash();						// Initialize the Flash

#endif

//--- Peripheral Initialization
	InitAdc();							// Initialize the ADC
	InitEv();							// Initialize the Event Manager

//--- Enable interrupts
    SetDBGIER(IER);						// Configure the DBGIER for realtime debug
	asm(" CLRC INTM, DBGM");			// Enable global interrupts and realtime debug

//--- Main Loop
	while(1)							// Dummy loop.  Wait for an interrupt.
	{
		asm(" NOP");
	}


} // end of main()


//--- end of file -----------------------------------------------------
