

MEMORY
{
    BOOTRAM:       o = 00000000h   l = 00000400h  
    IRAM:          o = 00000400h   l = 0000FA00h                           
    CE0:	       o = 80000000h   l = 01000000h 
    FLASH_BOOT:    o = 0x90000000  l = 00000400h
    FLASH_REST:    o = 0x90000400  l = 0001fc00h
                                                              
}

SECTIONS
{
	.boot_load : load = FLASH_BOOT, run = BOOTRAM   
                                                                   
    /* Initialized User Code Section */
    .text	   : load = FLASH_REST, run = IRAM 
    	LOAD_START(_text_ld_start),
    	RUN_START(_text_rn_start),
    	SIZE(_text_size)
          
    /* This is also a special initialized data section, which could stay
       in ROM, however probably not desirable, due to Slow ROM access times. 
       const values never change, by definition. */
    
    
    .cinit	    > 	FLASH_REST
    
    .const      >       IRAM
    .stack      >       IRAM
    .bss        >       IRAM
    .data       >       IRAM
    .far        >       IRAM
    .switch     >       IRAM
    .sysmem     >       IRAM
    .cio        >       IRAM
}                             

 
