/****************************************************************************/
/* DEMO.CMD - Linker Command file that demonstrates two linker features:    */
/*                                                                          */
/*     - Automatic Section Splitting                                        */
/*     - Copy Tables                                                        */
/*                                                                          */
/* This command file is specific to the C6416 Device Cycle Accurate         */
/* Simulator.  Changes are required to use it on any other device or        */
/* execution platform.                                                      */
/*--------------------------------------------------------------------------*/
/* Do not use any of this code elsewhere without first reading the legal    */
/* disclaimer at the end of the file.                                       */
/****************************************************************************/

-c                                    /* init global variables at boot      */             
-heap  0x2000                         /* size of heap for malloc            */
-stack 0x4000                         /* size of stack                      */

MEMORY
{
    /*----------------------------------------------------------------------*/
    /* By default, all on-chip memory is SRAM, not L2 cache                 */
    /*----------------------------------------------------------------------*/
    L2SRAM   : o = 0x00000020, l = 0x000fffe0
    
    /*----------------------------------------------------------------------*/
    /* Artificially split up first part of external memory to illustrate    */
    /* automatic section splitting                                          */
    /*----------------------------------------------------------------------*/
    EMIFA_M1 : o = 0x80000000, l = 0x00000080
    EMIFA_M2 : o = 0x80000100, l = 0x00000080
    EMIFA_M3 : o = 0x80000200, l = 0x00000100
    EMIFA_M4 : o = 0x80000400, l = 0x00000100
    
    /*----------------------------------------------------------------------*/
    /* The rest of external memory                                          */
    /*----------------------------------------------------------------------*/
    EMIFA    : o = 0x80000800, l = 0x3ffff800
}    

SECTIONS
{
    /*----------------------------------------------------------------------*/
    /* Use a UNION to overlay multiple sections at one run address.  These  */
    /* overlay sections will load at various places in EMIFA and be copied  */
    /* to the same run address in L2SRAM.                                   */
    /*----------------------------------------------------------------------*/
    UNION
    {
        /*------------------------------------------------------------------*/
        /* One function in this overlay section.  The table directive will  */
        /* create a copy table entry in the .ovly section.                  */
        /*------------------------------------------------------------------*/
        .func1_scn: load > EMIFA, table(_func1_ctbl)

        /*------------------------------------------------------------------*/
        /* Two functions in this overlay section.  Note use of section      */
        /* splitting on the load address.  The memory ranges are chosen     */
        /* such that a split really does occur.  This results in multiple   */
        /* entries in the copy table; one for each chunk of code copied     */
        /* from EMIFA to L2SRAM.                                            */
        /*------------------------------------------------------------------*/ 
        .func23_scn:
        {
            *(.func2_scn)
            *(.func3_scn)
        } load >> EMIFA_M1 | EMIFA_M2, table(_func23_ctbl)
        
    } run = L2SRAM
    
    /*----------------------------------------------------------------------*/
    /* A simple example of section splitting.  Each of 2 input sections     */
    /* contains 2 functions, for a total of 4 functions.  In this case the  */
    /* memory ranges are chosen such that M1 and M2 are taken up by funcs 2 */
    /* and 3, leaving M3 and M4 to handle these sections.  Note this code   */
    /* loads and runs in EMIFA memory.  That's good for this example, but   */
    /* bad for performance.                                                 */
    /*----------------------------------------------------------------------*/
    .func4567_scn
    {
        *(.func45_scn)
        *(.func67_scn)
    } >> EMIFA_M3 | EMIFA_M4 | EMIFA_M1 | EMIFA_M2
      
    /*----------------------------------------------------------------------*/    
    /* These ordinary compiler generated sections can go anywhere for this  */
    /* example.  Placing them in on-chip memory makes the simulator run     */
    /* faster.                                                              */
    /*----------------------------------------------------------------------*/    
    .text       >       L2SRAM
    .stack      >       L2SRAM
    .bss        >       L2SRAM
    .cinit      >       L2SRAM
    .cio        >       L2SRAM 
    .const      >       L2SRAM
    .data       >       L2SRAM
    .switch     >       L2SRAM 
    .sysmem     >       L2SRAM
    
    /*----------------------------------------------------------------------*/
    /* Far data in .far normally goes in external memory                    */
    /*----------------------------------------------------------------------*/
    .far        >       EMIFA
    
    /*----------------------------------------------------------------------*/
    /* This section is created by the linker to hold the copy tables.  They */
    /* are usually read infrequently, so it is okay to put them in external */
    /* memory.  Note placing the copy tables at an address very far away    */
    /* from other global variables in .bss is what requires use of the      */
    /* "far" keyword when declaring the constant tables in demo.c.          */
    /*----------------------------------------------------------------------*/
    .ovly       >       EMIFA
}


/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */
