/******************************************************************************
 * Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * * Neither the name of Texas Instruments Incorporated nor the names of
 * its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************/

/******************* PLL registers **********************************/

#define CHIP_LEVEL_REG              0x02620000
/*Boot cfg registers*/
#define KICK0                       *(unsigned int*)(CHIP_LEVEL_REG + 0x0038)
#define KICK1                       *(unsigned int*)(CHIP_LEVEL_REG + 0x003C)
#define KICK0_UNLOCK                (0x83E70B13)
#define KICK1_UNLOCK                (0x95A4F1E0)
#define KICK_LOCK                   0
#define TINPSEL                     *(unsigned int*)(CHIP_LEVEL_REG + 0x0300)
#define TOUTPSEL                    *(unsigned int*)(CHIP_LEVEL_REG + 0x0304)
#define MAINPLLCTL0                 *(unsigned int*)(CHIP_LEVEL_REG + 0x0350) //0x0328)
#define MAINPLLCTL1                 *(unsigned int*)(CHIP_LEVEL_REG + 0x0354) //0x032C)
#define MAIN_PLLD_OFFSET            0
#define MAIN_PLLD_MASK              0xFFFFFFC0
#define MAIN_PLLM_OFFSET            12
#define MAIN_PLLM_MASK              0xFFF80FFF
#define MAIN_BWADJ0_OFFSET          24
#define MAIN_BWADJ0_MASK            0x00FFFFFF
#define MAIN_ENSAT_OFFSET           6
#define MAIN_ENSAT_MASK             0xFFFFFFBF
#define MAIN_BWADJ1_OFFSET          0
#define MAIN_BWADJ1_MASK            0xFFFFFFF0

#define OBSCLKCTL                   *(unsigned int*)(CHIP_LEVEL_REG + 0x0C80)

/* PA PLL Registers */
#define BYPASS_BIT_SHIFT 23
#define CLKF_BIT_SHIFT   6
#define CLKD_BIT_SHIFT   0
#define DEVSTAT    (*((unsigned int *) 0x02620020))
#define PAPLLCTL0                 *(unsigned int*)(CHIP_LEVEL_REG + 0x0358)
#define PAPLLCTL1                 *(unsigned int*)(CHIP_LEVEL_REG + 0x035C)
#define PASSCLKSEL_MASK    (1 << 17)    /* Tells the configuration of the PASSCLKSEL pin */
#define PA_PLL_BYPASS_MASK (1 << BYPASS_BIT_SHIFT)    /* Tells whether the PA PLL is in BYPASS mode or not */
#define PA_PLL_CLKOD_MASK  (0x00780000) /* Tells the output divider value for the PA PLL */
#define PA_PLL_CLKF_MASK   (0x0007FFC0) /* Tells the multiplier value for the PA PLL */
#define PA_PLL_CLKR_MASK   (0x0000003F) /* Tells the divider value for the PA PLL */
#define PA_PLL_RESET_MASK  (0x00004000)


#define CHIP_MISC1                  *(unsigned int*)(CHIP_LEVEL_REG + 0x0C7C)
#define ARMPLL_ENABLE_OFFSET        13


#define DDR3APLLCTL0  			*(unsigned int*)(CHIP_LEVEL_REG + 0x0360)
#define DDR3APLLCTL1  			*(unsigned int*)(CHIP_LEVEL_REG + 0x0364)
#define DDR3BPLLCTL0  			*(unsigned int*)(CHIP_LEVEL_REG + 0x0368)
#define DDR3BPLLCTL1  			*(unsigned int*)(CHIP_LEVEL_REG + 0x036C)

//******************************************************
// PLL 1 definitions (DSP and ARM clock and subsystems)
#define PLL1_BASE                   0x02310000
#define PLL1_PLLCTL                 (*(unsigned int*)(PLL1_BASE + 0x100))   // PLL1 Control
#define PLL1_SECCTL                 (*(unsigned int*)(PLL1_BASE + 0x108))   // PLL1 Secondary Control
#define PLL1_PLLM                   (*(unsigned int*)(PLL1_BASE + 0x110))   // PLL1 Multiplier
#define PLL1_DIV1                   (*(unsigned int*)(PLL1_BASE + 0x118))   // DIV1 divider
#define PLL1_DIV2                   (*(unsigned int*)(PLL1_BASE + 0x11C))   // DIV2 divider
#define PLL1_DIV3                   (*(unsigned int*)(PLL1_BASE + 0x120))   // DIV3 divider
#define PLL1_CMD                    (*(unsigned int*)(PLL1_BASE + 0x138))   // CMD control
#define PLL1_STAT                   (*(unsigned int*)(PLL1_BASE + 0x13C))   // STAT control
#define PLL1_ALNCTL                 (*(unsigned int*)(PLL1_BASE + 0x140))   // ALNCTL control
#define PLL1_DCHANGE                (*(unsigned int*)(PLL1_BASE + 0x144))   // DCHANGE status
#define PLL1_CKEN                   (*(unsigned int*)(PLL1_BASE + 0x148))   // CKEN control
#define PLL1_CKSTAT                 (*(unsigned int*)(PLL1_BASE + 0x14C))   // CKSTAT status
#define PLL1_SYSTAT                 (*(unsigned int*)(PLL1_BASE + 0x150))   // SYSTAT status
#define PLL1_DIV4                   (*(unsigned int*)(PLL1_BASE + 0x160))   // DIV4 divider
#define PLL1_DIV5                   (*(unsigned int*)(PLL1_BASE + 0x164))   // DIV5 divider
#define PLL1_DIV6                   (*(unsigned int*)(PLL1_BASE + 0x168))   // DIV6 divider
#define PLL1_DIV7                   (*(unsigned int*)(PLL1_BASE + 0x16C))   // DIV7 divider
#define PLL1_DIV8                   (*(unsigned int*)(PLL1_BASE + 0x170))   // DIV8 divider
#define PLL1_DIV9                   (*(unsigned int*)(PLL1_BASE + 0x174))   // DIV9 divider
#define PLL1_DIV10                  (*(unsigned int*)(PLL1_BASE + 0x178))   // DIV10 divider
#define PLL1_DIV11                  (*(unsigned int*)(PLL1_BASE + 0x17C))   // DIV11 divider
#define PLL1_DIV12                  (*(unsigned int*)(PLL1_BASE + 0x180))   // DIV12 divider
#define PLL1_DIV13                  (*(unsigned int*)(PLL1_BASE + 0x184))   // DIV13 divider
#define PLL1_DIV14                  (*(unsigned int*)(PLL1_BASE + 0x188))   // DIV14 divider
#define PLL1_DIV15                  (*(unsigned int*)(PLL1_BASE + 0x18C))   // DIV15 divider
#define PLL1_DIV16                  (*(unsigned int*)(PLL1_BASE + 0x190))   // DIV16 divider
#define PLLPWRDN_OFFSET             1
#define PLLPWRDN_MASK               0xFFFFFFFD
#define PLLRST_OFFSET               3
#define PLLRST_MASK                 0xFFFFFFF7
#define PLLENSRC_OFFSET             5
#define PLLENSRC_MASK               0xFFFFFFDF
#define PLLEN_OFFSET                0
#define PLLEN_MASK                  0xFFFFFFFE
#define OUTPUT_DIVIDE_OFFSET        19
#define OUTPUT_DIVIDE_MASK          0xFF87FFFF
#define BYPASS_OFFSET               23
#define BYPASS_MASK                 0xFF7FFFFF
#define PLLM_OFFSET                 0
#define PLLM_MASK                   0xFFFFFFC0
#define GOSET_OFFSET                0
#define GOSET_MASK                  0xFFFFFFFE
#define GOSTAT_OFFSET               0
#define GOSTAT_MASK                 0xFFFFFFFE

/*----------------DDR3A Register definition---------------------*/


/* DDR PLL Definitions -----------------------------------------*/

#define DDR3APLLCTL0  			*(unsigned int*)(CHIP_LEVEL_REG + 0x0360)
#define DDR3APLLCTL1  			*(unsigned int*)(CHIP_LEVEL_REG + 0x0364)
#define DDR3BPLLCTL0  			*(unsigned int*)(CHIP_LEVEL_REG + 0x0368)
#define DDR3BPLLCTL1  			*(unsigned int*)(CHIP_LEVEL_REG + 0x036C)



#define DDR3A_BASE_ADDR (0x21010000)
#define DDR3A_STATUS   (*(int*)(DDR3A_BASE_ADDR + 0x00000004))
#define DDR3A_SDCFG    (*(int*)(DDR3A_BASE_ADDR + 0x00000008))
#define DDR3A_SDRFC    (*(int*)(DDR3A_BASE_ADDR + 0x00000010))
#define DDR3A_SDTIM1   (*(int*)(DDR3A_BASE_ADDR + 0x00000018))
#define DDR3A_SDTIM2   (*(int*)(DDR3A_BASE_ADDR + 0x0000001C))
#define DDR3A_SDTIM3   (*(int*)(DDR3A_BASE_ADDR + 0x00000020))
#define DDR3A_SDTIM4   (*(int*)(DDR3A_BASE_ADDR + 0x00000028))
#define DDR3A_ZQCFG    (*(int*)(DDR3A_BASE_ADDR + 0x000000C8))
#define DDR3A_TMPALRT  (*(int*)(DDR3A_BASE_ADDR + 0x000000CC))
#define DDR3A_DDRPHYC  (*(int*)(DDR3A_BASE_ADDR + 0x000000E4))

#define DDR3A_PHY_CFG_BASE (0x02329000)
#define DDR3A_PIR    (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000004))
#define DDR3A_PGCR0  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000008))
#define DDR3A_PGCR1  (*(int*)(DDR3A_PHY_CFG_BASE + 0x0000000C))
#define DDR3A_PGCR2  (*(int*)(DDR3A_PHY_CFG_BASE + 0x0000008C))
#define DDR3A_PGSR0  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000010))
#define DDR3A_PGSR1  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000014))
#define DDR3A_PLLCR  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000018))
#define DDR3A_PTR0   (*(int*)(DDR3A_PHY_CFG_BASE + 0x0000001C))
#define DDR3A_PTR1   (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000020))
#define DDR3A_PTR2   (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000024))
#define DDR3A_PTR3   (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000028))
#define DDR3A_PTR4   (*(int*)(DDR3A_PHY_CFG_BASE + 0x0000002C))
#define DDR3A_DSGCR  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000040))
#define DDR3A_DCR    (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000044))
#define DDR3A_MR0    (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000054))
#define DDR3A_MR1    (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000058))
#define DDR3A_MR2    (*(int*)(DDR3A_PHY_CFG_BASE + 0x0000005C))
#define DDR3A_DTCR   (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000068))
#define DDR3A_DTPR0  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000048))
#define DDR3A_DTPR1  (*(int*)(DDR3A_PHY_CFG_BASE + 0x0000004C))
#define DDR3A_DTPR2  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000050))

#define DDR3A_ZQ0CR1  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000184))
#define DDR3A_ZQ1CR1  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000194))
#define DDR3A_ZQ2CR1  (*(int*)(DDR3A_PHY_CFG_BASE + 0x000001A4))
#define DDR3A_ZQ3CR1  (*(int*)(DDR3A_PHY_CFG_BASE + 0x000001B4))
#define DDR3A_DXCCR   (*(int*)(DDR3A_PHY_CFG_BASE + 0x0000003C))

#define DDR3A_DX5GCR  (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000300))

#define DDR3A_DATX8_8 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000003C0))


#define DDR3_TEST_START_ADDRESS (*(int*)(0x80000000))

#define IODDRM_MASK            0x00000180
#define ZCKSEL_MASK            0x01800000
#define CL_MASK				   0x00000072
#define WR_MASK				   0x00000E00
#define BL_MASK				   0x00000003
#define RRMODE_MASK            0x00040000
#define UDIMM_MASK             0x20000000
#define BYTEMASK_MASK          0x0000FC00
#define MPRDQ_MASK             0x00000080
#define PDQ_MASK               0x00000070
#define NOSRA_MASK             0x08000000
#define ECC_MASK               0x00000001
#define RRMODE_MASK            0x00040000
#define DXEN_MASK              0x00000001
#define DQSGX_MASK			   0x00000040
#define DTEXG_MASK             0x00800000

#define DDR3A_DX0GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x000001C0)) //0x70
#define DDR3A_DX1GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000200)) //0x80
#define DDR3A_DX2GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000240)) //0x90
#define DDR3A_DX3GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000280)) //0xA0
#define DDR3A_DX4GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x000002C0)) //0xB0
#define DDR3A_DX5GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000300)) //0xC0
#define DDR3A_DX6GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000340)) //0xD0
#define DDR3A_DX7GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000380)) //0xE0
#define DDR3A_DX8GCR (*(int*)(DDR3A_PHY_CFG_BASE + 0x000003C0)) //0xF0

#define DDR3A_DX0GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000001C4)) //0x71
#define DDR3A_DX1GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000204)) //0x81
#define DDR3A_DX2GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000244)) //0x91
#define DDR3A_DX3GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000284)) //0xA1
#define DDR3A_DX4GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000002C4)) //0xB1
#define DDR3A_DX5GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000304)) //0xC1
#define DDR3A_DX6GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000344)) //0xD1
#define DDR3A_DX7GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000384)) //0xE1
#define DDR3A_DX8GSR0 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000003C4)) //0xF1

#define DDR3A_DX0GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000001C8)) //0x72
#define DDR3A_DX1GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000208)) //0x82
#define DDR3A_DX2GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000248)) //0x92
#define DDR3A_DX3GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000288)) //0xA2
#define DDR3A_DX4GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000002C8)) //0xB2
#define DDR3A_DX5GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000308)) //0xC2
#define DDR3A_DX6GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000348)) //0xD2
#define DDR3A_DX7GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000388)) //0xE2
#define DDR3A_DX8GSR1 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000003C8)) //0xF2


#define DDR3A_DX0GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000001F4)) //0x7D
#define DDR3A_DX1GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000234)) //0x8D
#define DDR3A_DX2GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000274)) //0x9D
#define DDR3A_DX3GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000002B4)) //0xAD
#define DDR3A_DX4GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000002F4)) //0xBD
#define DDR3A_DX5GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000334)) //0xCD
#define DDR3A_DX6GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x00000374)) //0xDD
#define DDR3A_DX7GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000003B4)) //0xED
#define DDR3A_DX8GSR2 (*(int*)(DDR3A_PHY_CFG_BASE + 0x000003F4)) //0xFD

#define DDR3A_DX0LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000001E0))
#define DDR3A_DX1LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000220))
#define DDR3A_DX2LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000260))
#define DDR3A_DX3LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000002A0))
#define DDR3A_DX4LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000002E0))
#define DDR3A_DX5LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000320))
#define DDR3A_DX6LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000360))
#define DDR3A_DX7LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000003A0))
#define DDR3A_DX8LCDLR0 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000003E0))

#define DDR3A_DX0LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000001E4))
#define DDR3A_DX1LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000224))
#define DDR3A_DX2LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000264))
#define DDR3A_DX3LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000002A4))
#define DDR3A_DX4LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000002E4))
#define DDR3A_DX5LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000324))
#define DDR3A_DX6LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000364))
#define DDR3A_DX7LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000003A4))
#define DDR3A_DX8LCDLR1 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000003E4))

#define DDR3A_DX0LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000001E8))
#define DDR3A_DX1LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000228))
#define DDR3A_DX2LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000268))
#define DDR3A_DX3LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000002A8))
#define DDR3A_DX4LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000002E8))
#define DDR3A_DX5LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000328))
#define DDR3A_DX6LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x00000368))
#define DDR3A_DX7LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000003A8))
#define DDR3A_DX8LCDLR2 	(*(int*)(DDR3A_PHY_CFG_BASE + 0x000003E8))

//-------------------------DDR3B registers-------------------------

#define DDR3B_BASE_ADDR (0x21020000)
#define DDR3B_STATUS   (*(int*)(DDR3B_BASE_ADDR + 0x00000004))
#define DDR3B_SDCFG    (*(int*)(DDR3B_BASE_ADDR + 0x00000008))
#define DDR3B_SDRFC    (*(int*)(DDR3B_BASE_ADDR + 0x00000010))
#define DDR3B_SDTIM1   (*(int*)(DDR3B_BASE_ADDR + 0x00000018))
#define DDR3B_SDTIM2   (*(int*)(DDR3B_BASE_ADDR + 0x0000001C))
#define DDR3B_SDTIM3   (*(int*)(DDR3B_BASE_ADDR + 0x00000020))
#define DDR3B_SDTIM4   (*(int*)(DDR3B_BASE_ADDR + 0x00000028))
#define DDR3B_ZQCFG    (*(int*)(DDR3B_BASE_ADDR + 0x000000C8))
#define DDR3B_TMPALRT  (*(int*)(DDR3B_BASE_ADDR + 0x000000CC))
#define DDR3B_DDRPHYC  (*(int*)(DDR3B_BASE_ADDR + 0x000000E4))


#define DDR3B_PHY_CFG_BASE (0x02328000)
#define DDR3B_PIR    (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000004))
#define DDR3B_PGCR0  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000008))
#define DDR3B_PGCR1  (*(int*)(DDR3B_PHY_CFG_BASE + 0x0000000C))
#define DDR3B_PGCR2  (*(int*)(DDR3B_PHY_CFG_BASE + 0x0000008C))
#define DDR3B_PGSR0  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000010))
#define DDR3B_PGSR1  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000014))
#define DDR3B_PTR0   (*(int*)(DDR3B_PHY_CFG_BASE + 0x0000001C))
#define DDR3B_PTR1   (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000020))
#define DDR3B_PTR2   (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000024))
#define DDR3B_PTR3   (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000028))
#define DDR3B_PTR4   (*(int*)(DDR3B_PHY_CFG_BASE + 0x0000002C))
#define DDR3B_DSGCR  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000040))
#define DDR3B_DCR    (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000044))
#define DDR3B_MR0    (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000054))
#define DDR3B_MR1    (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000058))
#define DDR3B_MR2    (*(int*)(DDR3B_PHY_CFG_BASE + 0x0000005C))
#define DDR3B_DTCR   (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000068))
#define DDR3B_DTPR0  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000048))
#define DDR3B_DTPR1  (*(int*)(DDR3B_PHY_CFG_BASE + 0x0000004C))
#define DDR3B_DTPR2  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000050))
#define DDR3B_PLLCR  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000018))

#define DDR3B_ZQ0CR1  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000184))
#define DDR3B_ZQ1CR1  (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000194))
#define DDR3B_ZQ2CR1  (*(int*)(DDR3B_PHY_CFG_BASE + 0x000001A4))
#define DDR3B_ZQ3CR1  (*(int*)(DDR3B_PHY_CFG_BASE + 0x000001B4))


//------------------DDR3B

#define DDR3B_DX8GCR (*(int*)(DDR3B_PHY_CFG_BASE + 0x000003C0)) //0xF0

#define DDR3B_DX0GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000001C4)) //0x71
#define DDR3B_DX1GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000204)) //0x81
#define DDR3B_DX2GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000244)) //0x91
#define DDR3B_DX3GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000284)) //0xA1
#define DDR3B_DX4GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000002C4)) //0xB1
#define DDR3B_DX5GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000304)) //0xC1
#define DDR3B_DX6GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000344)) //0xD1
#define DDR3B_DX7GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000384)) //0xE1
#define DDR3B_DX8GSR0 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000003C4)) //0xF1

#define DDR3B_DX0GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000001C8)) //0x72
#define DDR3B_DX1GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000208)) //0x82
#define DDR3B_DX2GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000248)) //0x92
#define DDR3B_DX3GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000288)) //0xA2
#define DDR3B_DX4GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000002C8)) //0xB2
#define DDR3B_DX5GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000308)) //0xC2
#define DDR3B_DX6GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000348)) //0xD2
#define DDR3B_DX7GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000388)) //0xE2
#define DDR3B_DX8GSR1 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000003C8)) //0xF2


#define DDR3B_DX0GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000001F4)) //0x7D
#define DDR3B_DX1GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000234)) //0x8D
#define DDR3B_DX2GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000274)) //0x9D
#define DDR3B_DX3GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000002B4)) //0xAD
#define DDR3B_DX4GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000002F4)) //0xBD
#define DDR3B_DX5GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000334)) //0xCD
#define DDR3B_DX6GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x00000374)) //0xDD
#define DDR3B_DX7GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000003B4)) //0xED
#define DDR3B_DX8GSR2 (*(int*)(DDR3B_PHY_CFG_BASE + 0x000003F4)) //0xFD

/*----------------EDMA3 Register Definitions-------------------*/
#define EDMA3_CC0_BASE_ADDR 	(0x02700000)
#define EDMA3_CC0_PARAM0_ADDR	(EDMA3_CC0_BASE_ADDR + 0x00004000)

#define EDMA_ICR				(*(int*)(EDMA3_CC0_BASE_ADDR+0x1070))
#define EDMA_QEESR				(*(int*)(EDMA3_CC0_BASE_ADDR+0x108C))
#define EDMA_PARAM_0_0			(*(int*)(EDMA3_CC0_PARAM0_ADDR))
#define EDMA_PARAM_0_1			(*(int*)(EDMA3_CC0_PARAM0_ADDR+0x04))
#define EDMA_PARAM_0_2			(*(int*)(EDMA3_CC0_PARAM0_ADDR+0x08))
#define EDMA_PARAM_0_3			(*(int*)(EDMA3_CC0_PARAM0_ADDR+0x0C))
#define EDMA_PARAM_0_4			(*(int*)(EDMA3_CC0_PARAM0_ADDR+0x10))
#define EDMA_PARAM_0_5			(*(int*)(EDMA3_CC0_PARAM0_ADDR+0x14))
#define EDMA_PARAM_0_6			(*(int*)(EDMA3_CC0_PARAM0_ADDR+0x18))
#define EDMA_PARAM_0_7			(*(int*)(EDMA3_CC0_PARAM0_ADDR+0x1C))
#define EDMA_IPR				(*(int*)(EDMA3_CC0_BASE_ADDR+0x1068))
#define EDMA_QCHMAP0			*(int*)(EDMA3_CC0_BASE_ADDR+0x0200)

/*----------------Miscellaneous Definitions--------------------*/

#define XMC_BASE_ADDR 			(0x08000000)
#define XMPAX2_L     			(*(int*)(XMC_BASE_ADDR + 0x00000010))
#define XMPAX2_H     			(*(int*)(XMC_BASE_ADDR + 0x00000014))
#define L1DCFG					(*(int*)(0x01840040))
#define L2CFG					(*(int*)(0x01840000))

#define BOOTCFG_DIEID0			(*(unsigned int*)(0x02620008u))
#define BOOTCFG_DIEID1			(*(unsigned int*)(0x0262000Cu))
#define BOOTCFG_DIEID2			(*(unsigned int*)(0x02620010u))
#define BOOTCFG_DIEID3			(*(unsigned int*)(0x02620014u))

unsigned long long int DATA_PATTERN_inc[256]={
	0x0000000000000000,
	0x0101010101010101,
	0x0202020202020202,
	0x0303030303030303,
	0x0404040404040404,
	0x0505050505050505,
	0x0606060606060606,
	0x0707070707070707,
	0x0808080808080808,
	0x0909090909090909,
	0x0A0A0A0A0A0A0A0A,
	0x0B0B0B0B0B0B0B0B,
	0x0C0C0C0C0C0C0C0C,
	0x0D0D0D0D0D0D0D0D,
	0x0E0E0E0E0E0E0E0E,
	0x0F0F0F0F0F0F0F0F,
	0x1111111111111111,
	0x1212121212121212,
	0x1313131313131313,
	0x1414141414141414,
	0x1515151515151515,
	0x1616161616161616,
	0x1717171717171717,
	0x1818181818181818,
	0x1919191919191919,
	0x1A1A1A1A1A1A1A1A,
	0x1B1B1B1B1B1B1B1B,
	0x1C1C1C1C1C1C1C1C,
	0x1D1D1D1D1D1D1D1D,
	0x1E1E1E1E1E1E1E1E,
	0x1F1F1F1F1F1F1F1F,
	0x2121212121212121,
	0x2222222222222222,
	0x2323232323232323,
	0x2424242424242424,
	0x2525252525252525,
	0x2626262626262626,
	0x2727272727272727,
	0x2828282828282828,
	0x2929292929292929,
	0x2A2A2A2A2A2A2A2A,
	0x2B2B2B2B2B2B2B2B,
	0x2C2C2C2C2C2C2C2C,
	0x2D2D2D2D2D2D2D2D,
	0x2E2E2E2E2E2E2E2E,
	0x2F2F2F2F2F2F2F2F,
	0x3131313131313131,
	0x3232323232323232,
	0x3333333333333333,
	0x3434343434343434,
	0x3535353535353535,
	0x3636363636363636,
	0x3737373737373737,
	0x3838383838383838,
	0x3939393939393939,
	0x3A3A3A3A3A3A3A3A,
	0x3B3B3B3B3B3B3B3B,
	0x3C3C3C3C3C3C3C3C,
	0x3D3D3D3D3D3D3D3D,
	0x3E3E3E3E3E3E3E3E,
	0x3F3F3F3F3F3F3F3F,
	0x4141414141414141,
	0x4242424242424242,
	0x4343434343434343,
	0x4444444444444444,
	0x4545454545454545,
	0x4646464646464646,
	0x4747474747474747,
	0x4848484848484848,
	0x4949494949494949,
	0x4A4A4A4A4A4A4A4A,
	0x4B4B4B4B4B4B4B4B,
	0x4C4C4C4C4C4C4C4C,
	0x4D4D4D4D4D4D4D4D,
	0x4E4E4E4E4E4E4E4E,
	0x4F4F4F4F4F4F4F4F,
	0x5151515151515151,
	0x5252525252525252,
	0x5353535353535353,
	0x5454545454545454,
	0x5555555555555555,
	0x5656565656565656,
	0x5757575757575757,
	0x5858585858585858,
	0x5959595959595959,
	0x5A5A5A5A5A5A5A5A,
	0x5B5B5B5B5B5B5B5B,
	0x5C5C5C5C5C5C5C5C,
	0x5D5D5D5D5D5D5D5D,
	0x5E5E5E5E5E5E5E5E,
	0x5F5F5F5F5F5F5F5F,
	0x6161616161616161,
	0x6262626262626262,
	0x6363636363636363,
	0x6464646464646464,
	0x6565656565656565,
	0x6666666666666666,
	0x6767676767676767,
	0x6868686868686868,
	0x6969696969696969,
	0x6A6A6A6A6A6A6A6A,
	0x6B6B6B6B6B6B6B6B,
	0x6C6C6C6C6C6C6C6C,
	0x6D6D6D6D6D6D6D6D,
	0x6E6E6E6E6E6E6E6E,
	0x6F6F6F6F6F6F6F6F,
	0x7171717171717171,
	0x7272727272727272,
	0x7373737373737373,
	0x7474747474747474,
	0x7575757575757575,
	0x7676767676767676,
	0x7777777777777777,
	0x7878787878787878,
	0x7979797979797979,
	0x7A7A7A7A7A7A7A7A,
	0x7B7B7B7B7B7B7B7B,
	0x7C7C7C7C7C7C7C7C,
	0x7D7D7D7D7D7D7D7D,
	0x7E7E7E7E7E7E7E7E,
	0x7F7F7F7F7F7F7F7F,
	0x8181818181818181,
	0x8282828282828282,
	0x8383838383838383,
	0x8484848484848484,
	0x8585858585858585,
	0x8686868686868686,
	0x8787878787878787,
	0x8888888888888888,
	0x8989898989898989,
	0x8A8A8A8A8A8A8A8A,
	0x8B8B8B8B8B8B8B8B,
	0x8C8C8C8C8C8C8C8C,
	0x8D8D8D8D8D8D8D8D,
	0x8E8E8E8E8E8E8E8E,
	0x8F8F8F8F8F8F8F8F,
	0x9191919191919191,
	0x9292929292929292,
	0x9393939393939393,
	0x9494949494949494,
	0x9595959595959595,
	0x9696969696969696,
	0x9797979797979797,
	0x9898989898989898,
	0x9999999999999999,
	0x9A9A9A9A9A9A9A9A,
	0x9B9B9B9B9B9B9B9B,
	0x9C9C9C9C9C9C9C9C,
	0x9D9D9D9D9D9D9D9D,
	0x9E9E9E9E9E9E9E9E,
	0x9F9F9F9F9F9F9F9F,
	0xA1A1A1A1A1A1A1A1,
	0xA2A2A2A2A2A2A2A2,
	0xA3A3A3A3A3A3A3A3,
	0xA4A4A4A4A4A4A4A4,
	0xA5A5A5A5A5A5A5A5,
	0xA6A6A6A6A6A6A6A6,
	0xA7A7A7A7A7A7A7A7,
	0xA8A8A8A8A8A8A8A8,
	0xA9A9A9A9A9A9A9A9,
	0xAAAAAAAAAAAAAAAA,
	0xABABABABABABABAB,
	0xACACACACACACACAC,
	0xADADADADADADADAD,
	0xAEAEAEAEAEAEAEAE,
	0xAFAFAFAFAFAFAFAF,
	0xB1B1B1B1B1B1B1B1,
	0xB2B2B2B2B2B2B2B2,
	0xB3B3B3B3B3B3B3B3,
	0xB4B4B4B4B4B4B4B4,
	0xB5B5B5B5B5B5B5B5,
	0xB6B6B6B6B6B6B6B6,
	0xB7B7B7B7B7B7B7B7,
	0xB8B8B8B8B8B8B8B8,
	0xB9B9B9B9B9B9B9B9,
	0xBABABABABABABABA,
	0xBBBBBBBBBBBBBBBB,
	0xBCBCBCBCBCBCBCBC,
	0xBDBDBDBDBDBDBDBD,
	0xBEBEBEBEBEBEBEBE,
	0xBFBFBFBFBFBFBFBF,
	0xC1C1C1C1C1C1C1C1,
	0xC2C2C2C2C2C2C2C2,
	0xC3C3C3C3C3C3C3C3,
	0xC4C4C4C4C4C4C4C4,
	0xC5C5C5C5C5C5C5C5,
	0xC6C6C6C6C6C6C6C6,
	0xC7C7C7C7C7C7C7C7,
	0xC8C8C8C8C8C8C8C8,
	0xC9C9C9C9C9C9C9C9,
	0xCACACACACACACACA,
	0xCBCBCBCBCBCBCBCB,
	0xCCCCCCCCCCCCCCCC,
	0xCDCDCDCDCDCDCDCD,
	0xCECECECECECECECE,
	0xCFCFCFCFCFCFCFCF,
	0xD1D1D1D1D1D1D1D1,
	0xD2D2D2D2D2D2D2D2,
	0xD3D3D3D3D3D3D3D3,
	0xD4D4D4D4D4D4D4D4,
	0xD5D5D5D5D5D5D5D5,
	0xD6D6D6D6D6D6D6D6,
	0xD7D7D7D7D7D7D7D7,
	0xD8D8D8D8D8D8D8D8,
	0xD9D9D9D9D9D9D9D9,
	0xDADADADADADADADA,
	0xDBDBDBDBDBDBDBDB,
	0xDCDCDCDCDCDCDCDC,
	0xDDDDDDDDDDDDDDDD,
	0xDEDEDEDEDEDEDEDE,
	0xDFDFDFDFDFDFDFDF,
	0xE1E1E1E1E1E1E1E1,
	0xE2E2E2E2E2E2E2E2,
	0xE3E3E3E3E3E3E3E3,
	0xE4E4E4E4E4E4E4E4,
	0xE5E5E5E5E5E5E5E5,
	0xE6E6E6E6E6E6E6E6,
	0xE7E7E7E7E7E7E7E7,
	0xE8E8E8E8E8E8E8E8,
	0xE9E9E9E9E9E9E9E9,
	0xEAEAEAEAEAEAEAEA,
	0xEBEBEBEBEBEBEBEB,
	0xECECECECECECECEC,
	0xEDEDEDEDEDEDEDED,
	0xEEEEEEEEEEEEEEEE,
	0xEFEFEFEFEFEFEFEF,
	0xF1F1F1F1F1F1F1F1,
	0xF2F2F2F2F2F2F2F2,
	0xF3F3F3F3F3F3F3F3,
	0xF4F4F4F4F4F4F4F4,
	0xF5F5F5F5F5F5F5F5,
	0xF6F6F6F6F6F6F6F6,
	0xF7F7F7F7F7F7F7F7,
	0xF8F8F8F8F8F8F8F8,
	0xF9F9F9F9F9F9F9F9,
	0xFAFAFAFAFAFAFAFA,
	0xFBFBFBFBFBFBFBFB,
	0xFCFCFCFCFCFCFCFC,
	0xFDFDFDFDFDFDFDFD,
	0xFEFEFEFEFEFEFEFE,
	0xFFFFFFFFFFFFFFFF,
	0xA5A5A5A5A5A5A5A5,
	0xC3C3C3C3C3C3C3C3,
	0xA5A5A5A5A5A5A5A5,
	0xC3C3C3C3C3C3C3C3,
	0xA5A5A5A5A5A5A5A5,
	0xC3C3C3C3C3C3C3C3,
	0xA5A5A5A5A5A5A5A5,
	0xC3C3C3C3C3C3C3C3,
	0xA5A5A5A5A5A5A5A5,
	0xC3C3C3C3C3C3C3C3,
	0xA5A5A5A5A5A5A5A5,
	0xC3C3C3C3C3C3C3C3,
	0xA5A5A5A5A5A5A5A5,
	0xC3C3C3C3C3C3C3C3,
	0xA5A5A5A5A5A5A5A5,
};

unsigned long long int DATA_PATTERN_dec[256] ={
		0xFFFFFFFFFFFFFFFF,
		0xFEFEFEFEFEFEFEFE,
		0xFDFDFDFDFDFDFDFD,
		0xFCFCFCFCFCFCFCFC,
		0xFBFBFBFBFBFBFBFB,
		0xFAFAFAFAFAFAFAFA,
		0xF9F9F9F9F9F9F9F9,
		0xF8F8F8F8F8F8F8F8,
		0xF7F7F7F7F7F7F7F7,
		0xF6F6F6F6F6F6F6F6,
		0xF5F5F5F5F5F5F5F5,
		0xF4F4F4F4F4F4F4F4,
		0xF3F3F3F3F3F3F3F3,
		0xF2F2F2F2F2F2F2F2,
		0xF1F1F1F1F1F1F1F1,
		0xEFEFEFEFEFEFEFEF,
		0xEEEEEEEEEEEEEEEE,
		0xEDEDEDEDEDEDEDED,
		0xECECECECECECECEC,
		0xEBEBEBEBEBEBEBEB,
		0xEAEAEAEAEAEAEAEA,
		0xE9E9E9E9E9E9E9E9,
		0xE8E8E8E8E8E8E8E8,
		0xE7E7E7E7E7E7E7E7,
		0xE6E6E6E6E6E6E6E6,
		0xE5E5E5E5E5E5E5E5,
		0xE4E4E4E4E4E4E4E4,
		0xE3E3E3E3E3E3E3E3,
		0xE2E2E2E2E2E2E2E2,
		0xE1E1E1E1E1E1E1E1,
		0xDFDFDFDFDFDFDFDF,
		0xDEDEDEDEDEDEDEDE,
		0xDDDDDDDDDDDDDDDD,
		0xDCDCDCDCDCDCDCDC,
		0xDBDBDBDBDBDBDBDB,
		0xDADADADADADADADA,
		0xD9D9D9D9D9D9D9D9,
		0xD8D8D8D8D8D8D8D8,
		0xD7D7D7D7D7D7D7D7,
		0xD6D6D6D6D6D6D6D6,
		0xD5D5D5D5D5D5D5D5,
		0xD4D4D4D4D4D4D4D4,
		0xD3D3D3D3D3D3D3D3,
		0xD2D2D2D2D2D2D2D2,
		0xD1D1D1D1D1D1D1D1,
		0xCFCFCFCFCFCFCFCF,
		0xCECECECECECECECE,
		0xCDCDCDCDCDCDCDCD,
		0xCCCCCCCCCCCCCCCC,
		0xCBCBCBCBCBCBCBCB,
		0xCACACACACACACACA,
		0xC9C9C9C9C9C9C9C9,
		0xC8C8C8C8C8C8C8C8,
		0xC7C7C7C7C7C7C7C7,
		0xC6C6C6C6C6C6C6C6,
		0xC5C5C5C5C5C5C5C5,
		0xC4C4C4C4C4C4C4C4,
		0xC3C3C3C3C3C3C3C3,
		0xC2C2C2C2C2C2C2C2,
		0xC1C1C1C1C1C1C1C1,
		0xBFBFBFBFBFBFBFBF,
		0xBEBEBEBEBEBEBEBE,
		0xBDBDBDBDBDBDBDBD,
		0xBCBCBCBCBCBCBCBC,
		0xBBBBBBBBBBBBBBBB,
		0xBABABABABABABABA,
		0xB9B9B9B9B9B9B9B9,
		0xB8B8B8B8B8B8B8B8,
		0xB7B7B7B7B7B7B7B7,
		0xB6B6B6B6B6B6B6B6,
		0xB5B5B5B5B5B5B5B5,
		0xB4B4B4B4B4B4B4B4,
		0xB3B3B3B3B3B3B3B3,
		0xB2B2B2B2B2B2B2B2,
		0xB1B1B1B1B1B1B1B1,
		0xAFAFAFAFAFAFAFAF,
		0xAEAEAEAEAEAEAEAE,
		0xADADADADADADADAD,
		0xACACACACACACACAC,
		0xABABABABABABABAB,
		0xAAAAAAAAAAAAAAAA,
		0xA9A9A9A9A9A9A9A9,
		0xA8A8A8A8A8A8A8A8,
		0xA7A7A7A7A7A7A7A7,
		0xA6A6A6A6A6A6A6A6,
		0xA5A5A5A5A5A5A5A5,
		0xA4A4A4A4A4A4A4A4,
		0xA3A3A3A3A3A3A3A3,
		0xA2A2A2A2A2A2A2A2,
		0xA1A1A1A1A1A1A1A1,
		0x9F9F9F9F9F9F9F9F,
		0x9E9E9E9E9E9E9E9E,
		0x9D9D9D9D9D9D9D9D,
		0x9C9C9C9C9C9C9C9C,
		0x9B9B9B9B9B9B9B9B,
		0x9A9A9A9A9A9A9A9A,
		0x9999999999999999,
		0x9898989898989898,
		0x9797979797979797,
		0x9696969696969696,
		0x9595959595959595,
		0x9494949494949494,
		0x9393939393939393,
		0x9292929292929292,
		0x9191919191919191,
		0x8F8F8F8F8F8F8F8F,
		0x8E8E8E8E8E8E8E8E,
		0x8D8D8D8D8D8D8D8D,
		0x8C8C8C8C8C8C8C8C,
		0x8B8B8B8B8B8B8B8B,
		0x8A8A8A8A8A8A8A8A,
		0x8989898989898989,
		0x8888888888888888,
		0x8787878787878787,
		0x8686868686868686,
		0x8585858585858585,
		0x8484848484848484,
		0x8383838383838383,
		0x8282828282828282,
		0x8181818181818181,
		0x7F7F7F7F7F7F7F7F,
		0x7E7E7E7E7E7E7E7E,
		0x7D7D7D7D7D7D7D7D,
		0x7C7C7C7C7C7C7C7C,
		0x7B7B7B7B7B7B7B7B,
		0x7A7A7A7A7A7A7A7A,
		0x7979797979797979,
		0x7878787878787878,
		0x7777777777777777,
		0x7676767676767676,
		0x7575757575757575,
		0x7474747474747474,
		0x7373737373737373,
		0x7272727272727272,
		0x7171717171717171,
		0x6F6F6F6F6F6F6F6F,
		0x6E6E6E6E6E6E6E6E,
		0x6D6D6D6D6D6D6D6D,
		0x6C6C6C6C6C6C6C6C,
		0x6B6B6B6B6B6B6B6B,
		0x6A6A6A6A6A6A6A6A,
		0x6969696969696969,
		0x6868686868686868,
		0x6767676767676767,
		0x6666666666666666,
		0x6565656565656565,
		0x6464646464646464,
		0x6363636363636363,
		0x6262626262626262,
		0x6161616161616161,
		0x5F5F5F5F5F5F5F5F,
		0x5E5E5E5E5E5E5E5E,
		0x5D5D5D5D5D5D5D5D,
		0x5C5C5C5C5C5C5C5C,
		0x5B5B5B5B5B5B5B5B,
		0x5A5A5A5A5A5A5A5A,
		0x5959595959595959,
		0x5858585858585858,
		0x5757575757575757,
		0x5656565656565656,
		0x5555555555555555,
		0x5454545454545454,
		0x5353535353535353,
		0x5252525252525252,
		0x5151515151515151,
		0x4F4F4F4F4F4F4F4F,
		0x4E4E4E4E4E4E4E4E,
		0x4D4D4D4D4D4D4D4D,
		0x4C4C4C4C4C4C4C4C,
		0x4B4B4B4B4B4B4B4B,
		0x4A4A4A4A4A4A4A4A,
		0x4949494949494949,
		0x4848484848484848,
		0x4747474747474747,
		0x4646464646464646,
		0x4545454545454545,
		0x4444444444444444,
		0x4343434343434343,
		0x4242424242424242,
		0x4141414141414141,
		0x3F3F3F3F3F3F3F3F,
		0x3E3E3E3E3E3E3E3E,
		0x3D3D3D3D3D3D3D3D,
		0x3C3C3C3C3C3C3C3C,
		0x3B3B3B3B3B3B3B3B,
		0x3A3A3A3A3A3A3A3A,
		0x3939393939393939,
		0x3838383838383838,
		0x3737373737373737,
		0x3636363636363636,
		0x3535353535353535,
		0x3434343434343434,
		0x3333333333333333,
		0x3232323232323232,
		0x3131313131313131,
		0x2F2F2F2F2F2F2F2F,
		0x2E2E2E2E2E2E2E2E,
		0x2D2D2D2D2D2D2D2D,
		0x2C2C2C2C2C2C2C2C,
		0x2B2B2B2B2B2B2B2B,
		0x2A2A2A2A2A2A2A2A,
		0x2929292929292929,
		0x2828282828282828,
		0x2727272727272727,
		0x2626262626262626,
		0x2525252525252525,
		0x2424242424242424,
		0x2323232323232323,
		0x2222222222222222,
		0x2121212121212121,
		0x1F1F1F1F1F1F1F1F,
		0x1E1E1E1E1E1E1E1E,
		0x1D1D1D1D1D1D1D1D,
		0x1C1C1C1C1C1C1C1C,
		0x1B1B1B1B1B1B1B1B,
		0x1A1A1A1A1A1A1A1A,
		0x1919191919191919,
		0x1818181818181818,
		0x1717171717171717,
		0x1616161616161616,
		0x1515151515151515,
		0x1414141414141414,
		0x1313131313131313,
		0x1212121212121212,
		0x1111111111111111,
		0x0F0F0F0F0F0F0F0F,
		0x0E0E0E0E0E0E0E0E,
		0x0D0D0D0D0D0D0D0D,
		0x0C0C0C0C0C0C0C0C,
		0x0B0B0B0B0B0B0B0B,
		0x0A0A0A0A0A0A0A0A,
		0x0909090909090909,
		0x0808080808080808,
		0x0707070707070707,
		0x0606060606060606,
		0x0505050505050505,
		0x0404040404040404,
		0x0303030303030303,
		0x0202020202020202,
		0x0101010101010101,
		0x0000000000000000,
		0xC3C3C3C3C3C3C3C3,
		0xA5A5A5A5A5A5A5A5,
		0xC3C3C3C3C3C3C3C3,
		0xA5A5A5A5A5A5A5A5,
		0xC3C3C3C3C3C3C3C3,
		0xA5A5A5A5A5A5A5A5,
		0xC3C3C3C3C3C3C3C3,
		0xA5A5A5A5A5A5A5A5,
		0xC3C3C3C3C3C3C3C3,
		0xA5A5A5A5A5A5A5A5,
		0xC3C3C3C3C3C3C3C3,
		0xA5A5A5A5A5A5A5A5,
		0xC3C3C3C3C3C3C3C3,
		0xA5A5A5A5A5A5A5A5,
};

unsigned long long int DATA_PATTERN_zeroes[256]={
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
	0x0000000000000000,
};
