/*=================================================================
 *  sysbfflt.c: BF filters for all angles of interest
 *=================================================================*/

#include <xdc/std.h>
#include <ti/mas/types/types.h>

#include "sysbfflt.h"
#include "codec_pcm186x.h"

#if NUM_OF_MICS==6
/* SYS_BF_ANGLE_P0 */
Fract sysBfFltP0[][SYS_BF_FILTER_LENGTH] = {
		  {  0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 32767,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0},
		  {  4,   -17,    44,   -86,   147,  -236,   366,  -570,   945, -1954, 32534,  2240, -1020,   606,  -388,   251,  -157,    92,   -48,    20,    -5,     0,     0},
		  {-14,    54,  -126,   238,  -401,   636,  -984,  1543, -2632,  6114, 31297, -4320,  2169, -1323,   853,  -549,   341,  -196,    98,   -38,     7,     0,     0},
		  {  5,   -51,   152,  -323,   581,  -955,  1495, -2311,  3691, -6719, 21527, 19967, -6539,  3622, -2273,  1471,  -938,   570,  -315,   147,   -48,     0,     0},
		  {  0,     0,   -48,   147,  -315,   570,  -938,  1471, -2273,  3622, -6539, 19967, 21527, -6719,  3691, -2311,  1495,  -955,   581,  -323,   152,   -51,     5},
		  {  0,     0,     7,   -38,    98,  -196,   341,  -549,   853, -1323,  2169, -4320, 31297,  6114, -2632,  1543,  -984,   636,  -401,   238,  -126,    54,   -14},
};

/* SYS_BF_ANGLE_P60 */
Fract sysBfFltP60[][SYS_BF_FILTER_LENGTH] = {
		  {  -3,    11,   -25,    49,   -84,   133,  -206,   322,  -540,  1169, 32701, -1086,   518,  -312,   200,  -129,    81,   -47,    24,   -10,     2,     0,     0},
		  {  -9,    36,   -85,   161,  -273,   434,  -672,  1051, -1780,  4009, 32080, -3168,  1560,  -947,   609,  -393,   244,  -141,    72,   -28,     6,     0,     0},
		  {   0,   -36,   117,  -259,   476,  -791,  1245, -1924,  3043, -5353, 14278, 26408, -6643,  3534, -2192,  1417,  -908,   557,  -314,   152,   -54,     8,     0},
		  {   0,     0,   -33,   109,  -243,   449,  -747,  1178, -1820,  2874, -5033, 13128, 27251, -6486,  3427, -2121,  1370,  -879,   540,  -305,   149,   -54,     8},
		  {   0,     0,     8,   -42,   110,  -220,   384,  -620,   963, -1494,  2443, -4820, 30795,  7223, -3058,  1786, -1137,   736,  -464,   276,  -147,    64,   -17},
		  {   0,     0,   -17,    62,  -143,   269,  -453,   718, -1109,  1741, -2980,  7016, 30893, -4732,  2394, -1464,   943,  -607,   376,  -216,   108,   -41,     8},
};

/* SYS_BF_ANGLE_P90 */
Fract sysBfFltP90[][SYS_BF_FILTER_LENGTH] = {
		  {  -18,    65,  -149,   281,  -472,   748, -1156,  1816, -3111,  7364, 30727, -4879,  2475, -1514,   976,  -628,   389,  -223,   111,   -42,     8,     0,     0},
		  {    8,   -49,   132,  -268,   470,  -762,  1186, -1838,  2987, -5776, 29341,  9930, -4028,  2328, -1479,   957,  -606,   362,  -194,    86,   -24,     0,     0},
		  {    0,     8,   -50,   136,  -275,   483,  -784,  1220, -1890,  3069, -5913, 29043, 10424, -4193,  2420, -1536,   994,  -630,   376,  -202,    90,   -26,     0},
		  {    0,     0,     4,   -20,    51,  -100,   172,  -275,   427,  -664,  1099, -2263, 32446,  2657, -1202,   713,  -457,   295,  -185,   109,   -57,    24,    -6},
		  {    0,     0,     4,   -20,    51,  -100,   172,  -275,   427,  -664,  1099, -2263, 32446,  2657, -1202,   713,  -457,   295,  -185,   109,   -57,    24,    -6},
		  {    0,     8,   -50,   136,  -275,   483,  -784,  1220, -1890,  3069, -5913, 29043, 10424, -4193,  2420, -1536,   994,  -630,   376,  -202,    90,   -26,     0},
};

/* SYS_BF_ANGLE_P120 */
Fract sysBfFltP120[][SYS_BF_FILTER_LENGTH] = {
		  {  -3,    11,   -25,    49,   -84,   133,  -206,   322,  -540,  1169, 32701, -1086,   518,  -312,   200,  -129,    81,   -47,    24,   -10,     2,     0,     0},
		  {   0,   -16,    59,  -136,   256,  -432,   685, -1059,  1661, -2838,  6645, 31064, -4568,  2304, -1407,   907,  -584,   362,  -208,   104,   -40,     7,     0},
		  {   0,     0,   -17,    62,  -143,   269,  -453,   718, -1109,  1741, -2980,  7016, 30893, -4732,  2394, -1464,   943,  -607,   376,  -216,   108,   -41,     8},
		  {   0,     0,     8,   -42,   110,  -220,   384,  -620,   963, -1494,  2443, -4820, 30795,  7223, -3058,  1786, -1137,   736,  -464,   276,  -147,    64,   -17},
		  {   0,     0,   -33,   109,  -243,   449,  -747,  1178, -1820,  2874, -5033, 13128, 27251, -6486,  3427, -2121,  1370,  -879,   540,  -305,   149,   -54,     8},
		  {   0,   -36,   117,  -259,   476,  -791,  1245, -1924,  3043, -5353, 14278, 26408, -6643,  3534, -2192,  1417,  -908,   557,  -314,   152,   -54,     8,     0},
};

/* SYS_BF_ANGLE_P180 */
Fract sysBfFltP180[][SYS_BF_FILTER_LENGTH] = {
		  {  0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 32767,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0},
		  {  0,     0,    -5,    20,   -48,    92,  -157,   251,  -388,   606, -1020,  2240, 32534, -1954,   945,  -570,   366,  -236,   147,   -86,    44,   -17,     4},
		  {  0,     0,     7,   -38,    98,  -196,   341,  -549,   853, -1323,  2169, -4320, 31297,  6114, -2632,  1543,  -984,   636,  -401,   238,  -126,    54,   -14},
		  {  0,     0,   -48,   147,  -315,   570,  -938,  1471, -2273,  3622, -6539, 19967, 21527, -6719,  3691, -2311,  1495,  -955,   581,  -323,   152,   -51,     5},
		  {  5,   -51,   152,  -323,   581,  -955,  1495, -2311,  3691, -6719, 21527, 19967, -6539,  3622, -2273,  1471,  -938,   570,  -315,   147,   -48,     0,     0},
		  {-14,    54,  -126,   238,  -401,   636,  -984,  1543, -2632,  6114, 31297, -4320,  2169, -1323,   853,  -549,   341,  -196,    98,   -38,     7,     0,     0},
		  {  4,   -17,    44,   -86,   147,  -236,   366,  -570,   945, -1954, 32534,  2240, -1020,   606,  -388,   251,  -157,    92,   -48,    20,    -5,     0,     0}
};

/* SYS_BF_ANGLE_M120 */
Fract sysBfFltM120[][SYS_BF_FILTER_LENGTH] = {
		  {   0,     0,     2,   -10,    24,   -47,    81,  -129,   200,  -312,   518, -1086, 32701,  1169,  -540,   322,  -206,   133,   -84,    49,   -25,    11,    -3},
		  {   0,     0,     6,   -28,    72,  -141,   244,  -393,   609,  -947,  1560, -3168, 32080,  4009, -1780,  1051,  -672,   434,  -273,   161,   -85,    36,    -9},
		  {   0,     8,   -54,   152,  -314,   557,  -908,  1417, -2192,  3534, -6643, 26408, 14278, -5353,  3043, -1924,  1245,  -791,   476,  -259,   117,   -36,     0},
		  {   8,   -54,   149,  -305,   540,  -879,  1370, -2121,  3427, -6486, 27251, 13128, -5033,  2874, -1820,  1178,  -747,   449,  -243,   109,   -33,     0,     0},
		  { -17,    64,  -147,   276,  -464,   736, -1137,  1786, -3058,  7223, 30795, -4820,  2443, -1494,   963,  -620,   384,  -220,   110,   -42,     8,     0,     0},
		  {   8,   -41,   108,  -216,   376,  -607,   943, -1464,  2394, -4732, 30893,  7016, -2980,  1741, -1109,   718,  -453,   269,  -143,    62,   -17,     0,     0},
};
  /* SYS_BF_ANGLE_M90 */
Fract sysBfFltM90[][SYS_BF_FILTER_LENGTH] = {
		  {   0,     0,     8,   -42,   111,  -223,   389,  -628,   976, -1514,  2475, -4879, 30727,  7364, -3111,  1816, -1156,   748,  -472,   281,  -149,    65,   -18 },
		  {   0,     0,   -24,    86,  -194,   362,  -606,   957, -1479,  2328, -4028,  9930, 29341, -5776,  2987, -1838,  1186,  -762,   470,  -268,   132,   -49,     8 },
		  {   0,   -26,    90,  -202,   376,  -630,   994, -1536,  2420, -4193, 10424, 29043, -5913,  3069, -1890,  1220,  -784,   483,  -275,   136,   -50,     8,     0 },
		  {  -6,    24,   -57,   109,  -185,   295,  -457,   713, -1202,  2657, 32446, -2263,  1099,  -664,   427,  -275,   172,  -100,    51,   -20,     4,     0,     0 },
		  {  -6,    24,   -57,   109,  -185,   295,  -457,   713, -1202,  2657, 32446, -2263,  1099,  -664,   427,  -275,   172,  -100,    51,   -20,     4,     0,     0 },
		  {   0,   -26,    90,  -202,   376,  -630,   994, -1536,  2420, -4193, 10424, 29043, -5913,  3069, -1890,  1220,  -784,   483,  -275,   136,   -50,     8,     0 },
 };

/* SYS_BF_ANGLE_M60 */
Fract sysBfFltM60[][SYS_BF_FILTER_LENGTH] = {
		  {   0,     0,     2,   -10,    24,   -47,    81,  -129,   200,  -312,   518, -1086, 32701,  1169,  -540,   322,  -206,   133,   -84,    49,   -25,    11,    -3 },
		  {   0,     7,   -40,   104,  -208,   362,  -584,   907, -1407,  2304, -4568, 31064,  6645, -2838,  1661, -1059,   685,  -432,   256,  -136,    59,   -16,     0 },
		  {   8,   -41,   108,  -216,   376,  -607,   943, -1464,  2394, -4732, 30893,  7016, -2980,  1741, -1109,   718,  -453,   269,  -143,    62,   -17,     0,     0 },
		  { -17,    64,  -147,   276,  -464,   736, -1137,  1786, -3058,  7223, 30795, -4820,  2443, -1494,   963,  -620,   384,  -220,   110,   -42,     8,     0,     0 },
		  {   8,   -54,   149,  -305,   540,  -879,  1370, -2121,  3427, -6486, 27251, 13128, -5033,  2874, -1820,  1178,  -747,   449,  -243,   109,   -33,     0,     0 },
		  {   0,     8,   -54,   152,  -314,   557,  -908,  1417, -2192,  3534, -6643, 26408, 14278, -5353,  3043, -1924,  1245,  -791,   476,  -259,   117,   -36,     0 },
};

/* Table of all available filters */
Fract *sysBfFilters[SYS_BF_ANGLES_MAX] = {
  &sysBfFltP0[0][0],    /* SYS_BF_ANGLE_P0   */
  &sysBfFltP60[0][0],   /* SYS_BF_ANGLE_P60  */
  &sysBfFltP90[0][0],   /* SYS_BF_ANGLE_P90  */
  &sysBfFltP120[0][0],   /* SYS_BF_ANGLE_P120  */
  &sysBfFltP180[0][0],  /* SYS_BF_ANGLE_P180 */
  &sysBfFltM120[0][0],   /* SYS_BF_ANGLE_M120  */
  &sysBfFltM90[0][0],   /* SYS_BF_ANGLE_M90  */
  &sysBfFltM60[0][0],   /* SYS_BF_ANGLE_M60  */
};
#endif

#if NUM_OF_MICS==4
/* SYS_BF_ANGLE_P0 */
Fract sysBfFltP90[][SYS_BF_FILTER_LENGTH] = {
  {    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      5,      0,      0,      0},
  {      0,    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      5,      0,      0},
  {      0,      5,    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      0,      0},
  {      0,      0 ,     5,   -50,     150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      0}
};


/* SYS_BF_ANGLE_P30 */
Fract sysBfFltP30[][SYS_BF_FILTER_LENGTH] = {
  {     8,    -49,    131,   -265,    465,   -753,   1171,  -1815,   2951,  -5714,  29463,   9721,  -3957,   2289,  -1455,    941,   -596,    355,   -191,     84,    -24,      0,      0, 	    0},
  {     0,    -24,     84,   -191,    355,   -596,    941,  -1455,   2289,  -3957,   9721,  29463,  -5714,   2951,  -1815,   1171,   -753,    465,   -265,    131,    -49,      8,      0, 	    0},
  {     0,      8,    -49,    131,   -265,    465,   -753,   1171,  -1815,   2951,  -5714,  29463,   9721,  -3957,   2289,  -1455,    941,   -596,    355,   -191,     84,    -24,      0, 	    0},
  {     0,      0,    -24,     84,   -191,    355,   -596,    941,  -1455,   2289,  -3957,   9721,  29463,  -5714,   2951,  -1815,   1171,   -753,    465,   -265,    131,    -49,      8, 	    0}
};

/* SYS_BF_ANGLE_M30 */
Fract sysBfFltM30[][SYS_BF_FILTER_LENGTH] = {
  {		0,      0,    -24,     84,   -191,    355,   -596,    941,  -1455,   2289,  -3957,   9721,  29463,  -5714,   2951,  -1815,   1171,   -753,    465,   -265,    131,    -49,      8,       0},
  {		0,      8,    -49,    131,   -265,    465,   -753,   1171,  -1815,   2951,  -5714,  29463,   9721,  -3957,   2289,  -1455,    941,   -596,    355,   -191,     84,    -24,      0,       0},
  {	    0,    -24,     84,   -191,    355,   -596,    941,  -1455,   2289,  -3957,   9721,  29463,  -5714,   2951,  -1815,   1171,   -753,    465,   -265,    131,    -49,      8,      0,       0},
  {		8,    -49,    131,   -265,    465,   -753,   1171,  -1815,   2951,  -5714,  29463,   9721,  -3957,   2289,  -1455,    941,   -596,    355,   -191,     84,    -24,      0,      0,       0}
};

/* SYS_BF_ANGLE_M90 */
Fract sysBfFltM90[][SYS_BF_FILTER_LENGTH] = {
  {      0,      0,      5,    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,       0},
  {      0,      5,    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      0,       0},
  {      0,    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      5,      0,       0},
  {    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      5,      0,      0,       0}
};


/* Table of all available filters */
Fract *sysBfFilters[SYS_BF_ANGLES_MAX] = {
  &sysBfFltP90[0][0],   /* SYS_BF_ANGLE_P90   */
  NULL,                 /* SYS_BF_ANGLE_P60  */
  &sysBfFltP30[0][0],   /* SYS_BF_ANGLE_P30  */
  NULL,                 /* SYS_BF_ANGLE_P00  */
  &sysBfFltM30[0][0],   /* SYS_BF_ANGLE_M30  */
  NULL,                 /* SYS_BF_ANGLE_M120  */
  &sysBfFltM90[0][0],   /* SYS_BF_ANGLE_M90  */
  NULL,                 /* SYS_BF_ANGLE_M60  */
};
#endif


#if NUM_OF_MICS==2
/* SYS_BF_ANGLE_P0 */
Fract sysBfFltP0[][SYS_BF_FILTER_LENGTH] = {
  {     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 32767,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,	0},
  {     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 32767,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,	0}
};

/* SYS_BF_ANGLE_P90 */
Fract sysBfFltP90[][SYS_BF_FILTER_LENGTH] = {
  {	   -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      5,     0,      0,      0},
  {      5,    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,     0,      0,      0}
};

/* SYS_BF_ANGLE_P180 */
Fract sysBfFltP180[][SYS_BF_FILTER_LENGTH] = {
  {     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 32767,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,	0},
  {     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 32767,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,	0}
};

/* SYS_BF_ANGLE_M90 */
Fract sysBfFltM90[][SYS_BF_FILTER_LENGTH] = {
  {      5,    -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,     0,      0,      0},
  {	   -50,    150,   -319,    576,   -948,   1485,  -2296,   3662,  -6639,  20754,  20754,  -6639,   3662,  -2296,   1485,   -948,    576,   -319,    150,    -50,      5,     0,      0,      0}
};

/* Table of all available filters */
Fract *sysBfFilters[SYS_BF_ANGLES_MAX] = {
  &sysBfFltP0[0][0],    /* SYS_BF_ANGLE_P0   */
  NULL,                 /* SYS_BF_ANGLE_P60  */
  &sysBfFltP90[0][0],   /* SYS_BF_ANGLE_P90  */
  NULL,                 /* SYS_BF_ANGLE_P120  */
  &sysBfFltP180[0][0],  /* SYS_BF_ANGLE_P180 */
  NULL,                 /* SYS_BF_ANGLE_M120  */
  &sysBfFltM90[0][0],   /* SYS_BF_ANGLE_M90  */
  NULL,                 /* SYS_BF_ANGLE_M60  */
};
#endif

/* nothing past this point */

