//**************************************************************************
//    Port Functions for the FE427
//
//    Stefan Schauer
//    Texas Instruments Freising
//    Date        Comments
//    =====================
//    08/22/03    Code Starts for FE427
//    Changes:
//     - fixed bouncing of Idle key
//
//    Version 1.0 first release for Application Report
//    06/04/04
//    Version 1.2 first release for Application Report
//    03/07/05 added checkKeys function
//
//**************************************************************************

/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */

#include "device.h"
#include "display.h"
#include "emeter.h"

#include "fet4xx_rtclcd.h"
// ************************************************************
// functions
// ************************************************************


//====================================================================
//  * Check Key Function
//====================================================================

void checkKeys(void)
{
  // Test if S1 was pressed
  if (P2IFG & 0x04)
  {
#ifdef withDisplay
      ModeSwitchDelay = 0;    // Set to 0 so that change is accepted
      DisplayNextData();      // next display mode
      ModeSwitchDelay = 3*60; // Hold this display mode for 3 min before
                              // return to auto switch mode
#endif // withDisplay
      P2IFG &= ~0x04;         //clear flag
  }

  // Test if S2 was pressed
  if (P2IFG & 0x08)
  {
      static signed char ESPidle = 0;
      if (ESPidle == 0) {
        ESPidle = 1;
        set_esp_idle();    // Set Embedded Signal Processor into Idle Mode
      }else {
        ESPidle = 0;
        set_esp_active();  // Set ESP back to active mode
        SetArrow(0x00);    // Switch Arrows off
      }
      P2IFG &= ~0x08;      //clear flag
   }
}

//====================================================================
//  * Interrupt service routine for Port 2.
//====================================================================
#ifdef __IAR_SYSTEMS_ICC__
#if __VER__ < 200
interrupt[PORT2_VECTOR] void port2_isr(void)
#else
#pragma vector=PORT2_VECTOR
__interrupt void port2_isr( void )
#endif
#endif

#ifdef __CROSSWORKS_MSP430
void port1_isr(void)   __interrupt[PORT2_VECTOR]
#endif

#ifdef __TI_COMPILER_VERSION__
__interrupt void port2_isr(void);
PORT2_ISR(port2_isr)
__interrupt void port2_isr(void)
#endif

{
}
