//====================================================================
//
//  ESP430CE1 Application Program Example
//
//  This file contains the Basis Routines used by the UART and the ISR
//  for the UART
//
//  author Stefan Schauer
//  date   02/08/2004
//
//  Modified Stefan Schauer
//  date   06/14/2004
//    Changes:
//     - modified TimerA Pulse output for higher Pulse rates
//     - added GetNumberPos function
//
//    Version 1.0 first release for Application Report
//    06/14/04
//    Version 1.2
//    12/23/04  changed calibration function (+/-) to use values instead of
//                steps
//
//====================================================================

/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


#include "uart0.h"
//#include <stdlib.h>
#include "device.h"
#include <ctype.h>

unsigned char UART_RX_Buffer[UART_RX_Buffer_Size];
unsigned int UART_RX_Bytes;
unsigned int UART_Status;

//--------------------------------------------------------------
// Extracts the hexadecimal number out of the received string
//--------------------------------------------------------------
//unsigned int GetNumber(unsigned char * num);
int GetHexNumber(unsigned char * num)
{
   int   val = 0;
   unsigned int chval;
   unsigned char * ptr = num;
   while (*ptr > 0)
   {
      chval = *ptr - '0';
      if (chval >10)
      {
         chval -= 'A' - '0';
      }
      val = (val<<4) + chval;
      ptr++;
   }
   return(val);
}

//--------------------------------------------------------------
// Extracts the decimal number out of the received string
//--------------------------------------------------------------
//unsigned int GetNumber(unsigned char * num);
int GetNumber(unsigned char * num)
{
   int   val = 0;
   int chval;
   unsigned char * ptr = num;
   
   // parse to first digit
   while (*ptr < '0')
   {
       if (*ptr == 0) return(0);
       ptr++;
        }

   while (*ptr >= '0')
   {
      chval = *ptr - '0';
      if ((chval >=0) && (chval<=9))
      {      
         val = (val * 10) + chval;
      }
      ptr++;
   }
   return(val);
}

//--------------------------------------------------------------
// Extracts the decimal number out of the received string and returns actual pos
//--------------------------------------------------------------
//unsigned int GetNumberPos(unsigned char * num, unsigned char * num);
int GetNumberPos(unsigned char * num, unsigned int * eptr)
{
   int   val = 0;
   int chval;
   unsigned char * ptr = num;
   
   // parse to first digit
   while ((*ptr > 0) && (*ptr < '0'))
   {
       ptr++;
        }

   while (*ptr >= '0')
   {
      chval = *ptr - '0';
      if ((chval >=0) && (chval<=9))
      {      
         val = (val * 10) + chval;
      }
      ptr++;
   }
   *eptr = (unsigned int) (*eptr + ptr - num);
   return(val);
}

//--------------------------------------------------------------
// Extracts the BCD number out of the received string
//--------------------------------------------------------------
int GetBCDNumber(unsigned char * num)
{
   int   val = 0;
   int chval;
   unsigned char * ptr = num;
   while (*ptr > 0)
   {
      chval = *ptr - '0';
      if ((chval >=0) && (chval<=9))
      {      
         val = (val*10) + chval;
      }
      ptr++;
   }
   return(val);
}


//------------------------------------------------------------------------------
//      URX0_ISR    ; UART0 Receive Interrupt Routine
//------------------------------------------------------------------------------
#ifdef __IAR_SYSTEMS_ICC__
#if __VER__ < 200
interrupt[UART0RX_VECTOR] void URX0_ISR(void)
#else
#pragma vector=UART0RX_VECTOR
__interrupt void URX0_ISR( void )
#endif
#endif

#ifdef __CROSSWORKS_MSP430
void URX0_ISR(void)   __interrupt[UART0RX_VECTOR]
#endif

#ifdef __TI_COMPILER_VERSION__
#pragma vector=USART0RX_VECTOR
__interrupt void URX0_ISR( void )
#endif

{   
   char   RxChar;
   RxChar = RXBUF0;
   if((UART_Status & LineReceived) == 0)      // ignore if last Buffer has not been processed
   {
      switch   (RxChar)
      {
         
      case 0x00:      //ignore NUL
         break;
      case 0x08:      // Backspace
         if (UART_RX_Bytes >0)
         {   
            UART_RX_Bytes--;      // Dec index if buffer not empty
            UART_RX_Buffer[UART_RX_Bytes] = 0;   // Erase previous char   
         }   
         break;      
      case 0x0A:      //ignore LF
         break;
      case 0x0D:      //Line Received
         UART_Status |= LineReceived;
         LPM3_EXIT;            // Exit Low Power Mode 3
         RxChar = 0;
         UART_RX_Buffer[UART_RX_Bytes] = RxChar;
         break;
      case 0x1B:      //<ESC> -> Clear Buffer
         UART_RX_Bytes = 0;   //Clear RX Buffer
         break;
      default:   // Byte received -> move to Buffer
         if ((RxChar >= 'a') && (RxChar <= 'z'))
            {UART_RX_Buffer[UART_RX_Bytes] = RxChar-0x20;}   // Convert to upper-case
         else
            {UART_RX_Buffer[UART_RX_Bytes] = RxChar;}
         
         if (UART_RX_Bytes < UART_RX_Buffer_Size)
         {   
            UART_RX_Bytes++;   // Inc index if buffer not full
         }
         break;
      }
   }
   return;
}

//------------------------------------------------------------------------------
//      URX0_ISR    ; UART0 Receive Interrupt Routine
//------------------------------------------------------------------------------
#ifdef __IAR_SYSTEMS_ICC__
#if __VER__ < 200
interrupt[UART0TX_VECTOR] void UTX0_ISR(void)
#else
#pragma vector=UART0TX_VECTOR
__interrupt void UTX0_ISR( void )
#endif
#endif

#ifdef __CROSSWORKS_MSP430
void UTX0_ISR(void)   __interrupt[UART0TX_VECTOR]
#endif

#ifdef __TI_COMPILER_VERSION__
#pragma vector=USART0TX_VECTOR
__interrupt void UTX0_ISR( void )
#endif

{   
   U0IE  &= ~UTXIE0;
        U0IFG |= UTXIFG0;
   return;
}
