/******************************************************************************/

/* lnk_msp430fe4272.cmd - LINKER COMMAND FILE FOR LINKING MSP430FE4272 PROGRAMS */

/*                                                                            */

/*  Ver | dd mmm yyyy | Who  | Description of changes                         */

/* =====|=============|======|=============================================   */

/*  0.01| 08 Mar 2004 | A.D. | First prototype                                */

/*  0.02| 26 Mai 2004 | A.D. | Leading symbol underscores removed,            */

/*      |             |      | Interrupt vector definition changed            */

/*  0.03| 22 Jun 2004 | A.D. | File reformatted                               */

/*                                                                            */

/*   Usage:  lnk430 <obj files...>    -o <out file> -m <map file> lnk.cmd     */

/*           cl430  <src files...> -z -o <out file> -m <map file> lnk.cmd     */

/*                                                                            */

/*----------------------------------------------------------------------------*/



/* These linker options are for command line linking only.  For IDE linking,  */

/* you should set your linker options in Project Properties                   */

/* -c                                               LINK USING C CONVENTIONS  */

/* -stack  0x0100                                   SOFTWARE STACK SIZE       */

/* -heap   0x0100                                   HEAP AREA SIZE            */



/*----------------------------------------------------------------------------*/

/* 'Allocate' peripheral registers at given addresses                         */

/*----------------------------------------------------------------------------*/



/************************************************************

* STANDARD BITS

************************************************************/

/************************************************************

* STATUS REGISTER BITS

************************************************************/

/************************************************************

* PERIPHERAL FILE MAP

************************************************************/

/************************************************************

* SPECIAL FUNCTION REGISTER ADDRESSES + CONTROL BITS

************************************************************/

IE1                = 0x0000;

IFG1               = 0x0002;

ME1                = 0x0004;

IE2                = 0x0001;

IFG2               = 0x0003;

/************************************************************

* WATCHDOG TIMER

************************************************************/

WDTCTL             = 0x0120;

/************************************************************

* DIGITAL I/O Port1/2

************************************************************/

P1IN               = 0x0020;

P1OUT              = 0x0021;

P1DIR              = 0x0022;

P1IFG              = 0x0023;

P1IES              = 0x0024;

P1IE               = 0x0025;

P1SEL              = 0x0026;

P2IN               = 0x0028;

P2OUT              = 0x0029;

P2DIR              = 0x002A;

P2IFG              = 0x002B;

P2IES              = 0x002C;

P2IE               = 0x002D;

P2SEL              = 0x002E;

/************************************************************

* BASIC TIMER

************************************************************/

BTCTL              = 0x0040;

BTCNT1             = 0x0046;

BTCNT2             = 0x0047;

/************************************************************

* SYSTEM CLOCK, FLL+ (x41x)

************************************************************/

SCFI0              = 0x0050;

SCFI1              = 0x0051;

SCFQCTL            = 0x0052;

FLL_CTL0           = 0x0053;

FLL_CTL1           = 0x0054;

/************************************************************

* Brown-Out, Supply Voltage Supervision (SVS)

************************************************************/

SVSCTL             = 0x0056;

/************************************************************

* LCD

************************************************************/

LCDCTL             = 0x0090;

LCDM1              = 0x0091;

LCDM2              = 0x0092;

LCDM3              = 0x0093;

LCDM4              = 0x0094;

LCDM5              = 0x0095;

LCDM6              = 0x0096;

LCDM7              = 0x0097;

LCDM8              = 0x0098;

LCDM9              = 0x0099;

LCDM10             = 0x009A;

LCDM11             = 0x009B;

LCDM12             = 0x009C;

LCDM13             = 0x009D;

LCDM14             = 0x009E;

LCDM15             = 0x009F;

LCDM16             = 0x00A0;

LCDM17             = 0x00A1;

LCDM18             = 0x00A2;

LCDM19             = 0x00A3;

LCDM20             = 0x00A4;

/************************************************************

* USART

************************************************************/

/************************************************************

* USART 0

************************************************************/

U0CTL              = 0x0070;

U0TCTL             = 0x0071;

U0RCTL             = 0x0072;

U0MCTL             = 0x0073;

U0BR0              = 0x0074;

U0BR1              = 0x0075;

U0RXBUF            = 0x0076;

U0TXBUF            = 0x0077;

/************************************************************

* Timer A3

************************************************************/

TAIV               = 0x012E;

TACTL              = 0x0160;

TACCTL0            = 0x0162;

TACCTL1            = 0x0164;

TACCTL2            = 0x0166;

TAR                = 0x0170;

TACCR0             = 0x0172;

TACCR1             = 0x0174;

TACCR2             = 0x0176;

/*************************************************************

* Flash Memory

*************************************************************/

FCTL1              = 0x0128;

FCTL2              = 0x012A;

FCTL3              = 0x012C;

/************************************************************

* HARDWARE MULTIPLIER

************************************************************/

MPY                = 0x0130;

MPYS               = 0x0132;

MAC                = 0x0134;

MACS               = 0x0136;

OP2                = 0x0138;

RESLO              = 0x013A;

RESHI              = 0x013C;

SUMEXT             = 0x013E;

/************************************************************

* SD16 - Sigma Delta 16 Bit

************************************************************/

SD16INCTL0         = 0x00B0;

SD16INCTL1         = 0x00B1;

SD16PRE0           = 0x00B8;

SD16PRE1           = 0x00B9;

SD16CONF0          = 0x00B7;

SD16CONF1          = 0x00BF;

                                      /* Please use only the recommended settings */

SD16CTL            = 0x0100;

SD16CCTL0          = 0x0102;

SD16CCTL1          = 0x0104;

SD16IV             = 0x0110;

SD16MEM0           = 0x0112;

SD16MEM1           = 0x0114;

/************************************************************

* ESP430E

************************************************************/

ESPCTL             = 0x0150;

MBCTL              = 0x0152;

MBIN0              = 0x0154;

MBIN1              = 0x0156;

MBOUT0             = 0x0158;

MBOUT1             = 0x015A;

ESP430_STAT0       = 0x01C0;

ESP430_STAT1       = 0x01C2;

WAVEFSV1           = 0x01C4;

RET3               = 0x01C6;

RET4               = 0x01C8;

WAVEFSI1           = 0x01CA;

RET7               = 0x01CE;

ACTENERGY1_LO      = 0x01D0;

ACTENERGY1_HI      = 0x01D2;

REACTENERGY_LO     = 0x01D8;

REACTENERGY_HI     = 0x01DA;

APPENERGY_LO       = 0x01DC;

APPENERGY_HI       = 0x01DE;

ACTENSPER1_LO      = 0x01E0;

ACTENSPER1_HI      = 0x01E2;

IRMS_2_LO          = 0x01E4;

IRMS_2_HI          = 0x01E6;

POWERFCT           = 0x01E8;

MAINSPERIOD        = 0x01EC;

V1RMS              = 0x01EE;

IRMS_LO            = 0x01F0;

IRMS_HI            = 0x01F2;

VPEAK              = 0x01F4;

IPEAK              = 0x01F6;

LINECYCLCNT_LO     = 0x01F8;

LINECYCLCNT_HI     = 0x01FA;

NMBMEAS_LO         = 0x01FC;

NMBMEAS_HI         = 0x01FE;

                                      /* 1: Rogowski coil (not yet implemented) */

/************************************************************

* Interrupt Vectors (offset from 0xFFE0)

************************************************************/

/************************************************************

* End of Modules

************************************************************/



/****************************************************************************/

/* SPECIFY THE SYSTEM MEMORY MAP                                            */

/****************************************************************************/



MEMORY

{

    SFR                     : origin = 0x0000, length = 0x0010

    PERIPHERALS_8BIT        : origin = 0x0010, length = 0x00F0

    PERIPHERALS_16BIT       : origin = 0x0100, length = 0x0100

    RAM                     : origin = 0x0200, length = 0x0400

    INFOA                   : origin = 0x1080, length = 0x0080

    INFOB                   : origin = 0x1000, length = 0x0080

    FLASH                   : origin = 0x8000, length = 0x7FE0

    INT00                   : origin = 0xFFE0, length = 0x0002

    INT01                   : origin = 0xFFE2, length = 0x0002

    INT02                   : origin = 0xFFE4, length = 0x0002

    INT03                   : origin = 0xFFE6, length = 0x0002

    INT04                   : origin = 0xFFE8, length = 0x0002

    INT05                   : origin = 0xFFEA, length = 0x0002

    INT06                   : origin = 0xFFEC, length = 0x0002

    INT07                   : origin = 0xFFEE, length = 0x0002

    INT08                   : origin = 0xFFF0, length = 0x0002

    INT09                   : origin = 0xFFF2, length = 0x0002

    INT10                   : origin = 0xFFF4, length = 0x0002

    INT11                   : origin = 0xFFF6, length = 0x0002

    INT12                   : origin = 0xFFF8, length = 0x0002

    INT13                   : origin = 0xFFFA, length = 0x0002

    INT14                   : origin = 0xFFFC, length = 0x0002

    RESET                   : origin = 0xFFFE, length = 0x0002

}



/****************************************************************************/

/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */

/****************************************************************************/



SECTIONS

{

    .bss       : {} > RAM                /* GLOBAL & STATIC VARS              */

    .sysmem    : {} > RAM                /* DYNAMIC MEMORY ALLOCATION AREA    */

    .stack     : {} > RAM (HIGH)         /* SOFTWARE SYSTEM STACK             */



    .text      : {} > FLASH              /* CODE                              */

    .cinit     : {} > FLASH              /* INITIALIZATION TABLES             */

    .const     : {} > FLASH              /* CONSTANT DATA                     */

    .cio       : {} > RAM                /* C I/O BUFFER                      */



    .pinit     : {} > FLASH              /* C++ CONSTRUCTOR TABLES            */



    .infoA     : {} > INFOA              /* MSP430 INFO FLASH MEMORY SEGMENTS */

    .infoB     : {} > INFOB



    .int00   : {} > INT00                /* MSP430 INTERRUPT VECTORS          */

    .int01   : {} > INT01

    .int02   : {} > INT02

    .int03   : {} > INT03

    .int04   : {} > INT04

    .int05   : {} > INT05

    .int06   : {} > INT06

    .int07   : {} > INT07

    .int08   : {} > INT08

    .int09   : {} > INT09

    .int10   : {} > INT10

    .int11   : {} > INT11

    .int12   : {} > INT12

    .int13   : {} > INT13

    .int14   : {} > INT14

    .reset   : {} > RESET              /* MSP430 RESET VECTOR               */ 

}



