//====================================================================
//    File: parameter.h
//
//    Version 1.0 first release for Application Report
//    06/04/04
//
//    Version 1.1
//    09/02/04    adopted for new Excel parameter generation
//    Version 1.3
//    11/27/07    added support for different Energy Pulse outputs
//    11/27/07    added support for ESP_V2
//
//
//====================================================================
#ifndef __parameter_h
#define __parameter_h

#include "device.h"

#ifndef IAR_KS
#define withUARTComm
#define withCalibration
#endif

#define withDisplay

#define TI_BOARD  1
#define SB_BOARD  2
// Set the PCB value to TI_BOARD for the PCB shown in the App.Report
//                      SB_BOARD for the PCB available from Softbaugh
#define PCB   TI_BOARD
//#define PCB   SB_BOARD

#if PCB == SB_BOARD
#define LCDOFFSET 1
#else
#define LCDOFFSET 0
#endif

#define LCD_SIZE   7      // Softbaugh SBLCDA2/SBLCDA4
#define LCD_TEST_PATTERN   1

// if following definition is set the Energy is only calculated it
// the current is above the defined start current
//#define WITH_START_CURRENT

#define MAINCPU_ENERGYPULSE
#ifdef MAINCPU_ENERGYPULSE
 #define ACTEN_PULSE   0
 #define REACTEN_PULSE 1
 #define APPEN_PULSE   2
#endif
#define TIMERA_PULSE_OUTPUT
#define INVERT_PULSE

#define SHUNT     0
#define CT        1
#define ROG_COIL  2


#define DDMMYY 0
#define MMDDYY 1
//#define date_format  MMDDYY
#define date_format  DDMMYY

// -----------------------------------------------------------------

// if following definition is set the PhaseShift value is corrected
// dependent on the temperature measured by the MSP430

//#define withTempCorrection
#ifdef withTempCorrection
  #pragma message (" ==> Temp. Correction enabled")
  #define PHI_Temp_Ratio 0.01  /* 0.01 Degree Phase shift per 1 Degree C */
                               /* From CT Datasheet */
                               /* if this is not linear it could be modified or entered */
                               /* directly in the emeter.c file */
#endif
// -----------------------------------------------------------------


#ifndef __CROSSWORKS_MSP430
#ifndef TIMERA_PULSE_OUTPUT
  #pragma message (" ==> Direct pulse enabled")
#else
  #pragma message (" ==> TimerA pulse output enabled")
#endif
#endif

/* 1 : Generate Interrupt after spec. number of measurements */
/* 0 : Generate Interrupt after interrupt level has been reached*/
  #define xIGT 0

#include "ESP_Parameter.h"

#ifndef __PI
#define __PI            3.141592653589793238462643
#endif


// Set event message request flags:
#define defSET_EVENT \
                0 * WFSRDYME +    /* Interrupt on "New WFS"*/\
                1 * ILREACHEDME + /* Interrupt on "Interrupt Level reached"*/\
                1 * ENRDYME +     /* Interrupt on "Energy samples ready (1sec)"*/\
                0 * ZXLDME +      /* Interrupt on "leading zero cross"*/\
                0 * ZXTRME +      /* Interrupt on "trailing zero cross"*/\
                0 * CALRDYME +    /* Interrupt on "Calibration Data ready"*/\
                0 * TAMPME +      /* Interrupt on "Tampering detected" */\
                0 * NEGENME +     /* Interrupt on "Neg. Energy measuered" */\
                0 * VDROPME +     /* Interrupt on "V drop event" */\
                0 * VPEAKME +     /* Interrupt on "V Peak Level reached" */\
                0 * I1PEAKME +    /* Interrupt on "I1 Peak Level reached" */\
                0


// OFFSET for V, I1, I2
#define   defSET_V1OFFSET (0)
#define   defSET_I1OFFSET (0)
#define   defSET_I2OFFSET (0)


// Default Gain Settings:
// 1.0  =  #10*4000h/10    Foramt (+1.14)
#define   defSET_GAINCORR1  (1 * POW_2_14)
#define   defSET_GAINCORR2  (1 * POW_2_14)


//  * \possilbe settings for Control 0:
//  * - Use current channel I2 - tamper-detection
//  * - Count absolute active energy
//  *   (negative energy is considered as tampering)
//  * - Switch DC removal alorithm on for I1
//  * - Switch DC removal alorithm on for I2
//  NEx = 00 : Negative Energy set to Zero
//  NEx = 01 : Absolute Energy set used
//  NEx = 10 : Negative Energy set used
//  NEx = 11 : Not used

#if I1SENSOR == ROG_COIL
#define xI1  1
#else
#define xI1  0
#endif

#if I2SENSOR != NONE
#define xI2  1
#else
#define xI2  0
#endif

#define  xdefSET_CTRL0 \
                xI2  * BIT0 +  /* - 0: disabled 2. Current path*/\
                xI1  * BIT1 +  /* - 0: I1 = CT or Shunt  /  1: I1 = RogCoil  */\
                xIGT * BIT2 +  /* 1 : Generate Interrupt after spec. number of measurements (-> 50*4096 =1 sec)*/\
                            /* 0 : Generate Interrupt after interrupt level has been reached*/\
                0 * BIT3 +  /* - NE0: Count absolute active energy p1 */\
                1 * BIT4 +  /* - NE1 Count absolute active energy p2 */\
                1 * BIT5 +  /* - Dis/Enable DC removal alorithm on for V1*/\
                0 * BIT6 +  /* - Dis/Enable DC removal alorithm on for I1*/\
                0 * BIT7    /* - Dis/Enable DC removal alorithm on for I2*/

#if I1SENSOR == ROG_COIL
     // enalbe RogCoil and DC removal on I1
#define defSET_CTRL0 (xdefSET_CTRL0 | (BIT1 + BIT6))
#else
#define defSET_CTRL0 xdefSET_CTRL0
#endif


/*    After certain energy is consumed:
      Irms(ESP)*Vrms(ESP)*1000*1000/(Vcal(mV)*Ical(mA))
      Irms(ESP) = measured I at Cal point
      Vrms(ESP) = measured V at Cal point
*/
// 10.000 imp/kWh
#ifdef TIMERA_PULSE_OUTPUT
//#define   TimerAClock                     TASSEL_1       /* ACLK = 32kHz */
//#define   TACLOCK                         32768ul
//#define   CLOCKSPERPERIOD                 (TACLOCK/defSET_NOMFREQ)

#define   TimerAClock                     TASSEL_2 | ID_3  /* SMCLK / 8 = 524kHz */
#define   TACLOCK                         MCLK_FREQ*32*32768/8ul
#define   CLOCKSPERPERIOD                 (TACLOCK/defSET_NOMFREQ)

//This is for the LED pulse
#define   ENERGY_PULSE_DURATION           (CLOCKSPERPERIOD/5)
#define   ENERGY_PULSE_THRESHOLD          (defSET_INTRPTLEVL_REPEAT)

#endif // TIMERA_PULSE_OUTPUT


// Adjustment parameters for DC Removal Periods:
//      max. Value = 32 !!!
#define   DCREMPER  10

// Shift Count for Rogowski Coil Integrator:
//      max. Value = 6 !!!
#define   SHNRC     3

#define   defSET_DCREMPER (DCREMPER + SHNRC*256)


/// MCLK frequency [MHz] - Valid values: 2, 4, 8
//#define   MCLK_FREQ 4
#define   MCLK_FREQ 8
#define defSystemFreq 1024*MCLK_FREQ
#define defFlashFreq  ((unsigned char)(((((float)defSystemFreq)/350)+1.5)) & 0x3f)

/// 2 raised to the power of 14 - Required for parameter calculations
#define   POW_2_14 0x004000
/// 2 raised to the power of 16 - Required for parameter calculations
#define   POW_2_16 0x010000
/// 2 raised to the power of 20 - Required for parameter calculations
#define   POW_2_20 0x100000ul
/// 2 raised to the power of 20 - Required for parameter calculations
//#define   POW_2_32 0x100000000ul

#define   defTempGain    (1168 / (1.257 * 0xFFFF) * 10000L)
#define   defTempOffset  (273 * 100)
//#define   defTemp_repeat 10    /* repeat temp measurement every 10 sec */
#define   defTemp_repeat 60    /* repeat temp measurement every 60 sec */
//#define   defTemp_repeat 0     /* temp measurement disabled */
#define   defCalTemp     2400  /* Room Temp at Calibraton in x100 Degree C */

#endif  // __parameter_h
