//====================================================================
//    File: fet4xx_rtclcd.h
//
//    Version 1.0 first release for Application Report
//    06/04/04
//    Version 1.3
//    07/11/27  added support for IAR V4
//
//====================================================================

#if !defined(_fet4xx_rtclcd_h_)
#define _fet4xx_rtclcd_h_

#include "parameter.h"

#ifndef __STDC__ /* Begin #defines for assembler */

  #ifdef       _def_clock
   #define _imp_exp PUBLIC
  #else
   #define _imp_exp EXTERN
  #endif

  #ifdef __CROSSWORKS_MSP430
            _imp_exp  _SEC
            _imp_exp  _MIN
            _imp_exp  _HOUR
            _imp_exp  _DAY
            _imp_exp  _MONTH
            _imp_exp  _YEAR
            _imp_exp  _SetupClock
            _imp_exp  _SetupLCD
            _imp_exp  _Dis_Clock
            _imp_exp  _Dis_Date
            _imp_exp  _Display_BCD
            _imp_exp  _Char2LCD
            _imp_exp  _BCD2LCD
            _imp_exp  _Direct2LCD
            _imp_exp  _CHAR_SPACE
            _imp_exp  _CHAR_MINUS
            _imp_exp  _LCD_Tab
#if PCB == TI_BOARD
            _imp_exp  _TLCD_Tab
#endif
            _imp_exp  _setPoint
            _imp_exp  _setColon
            _imp_exp  _SetArrow
           .IMPORT    _DisplayNextData
           .IMPORT    _sys_status
#define ReInit      0x04
  #else
            _imp_exp  SEC
            _imp_exp  MIN
            _imp_exp  HOUR
            _imp_exp  DAY
            _imp_exp  MONTH
            _imp_exp  YEAR
            _imp_exp  SetupClock
            _imp_exp  SetupLCD
            _imp_exp  Dis_Clock
            _imp_exp  Dis_Date
            _imp_exp  Display_BCD
            _imp_exp  Char2LCD
            _imp_exp  BCD2LCD
            _imp_exp  Direct2LCD
            _imp_exp  CHAR_SPACE
            _imp_exp  CHAR_MINUS
            _imp_exp  LCD_Tab
#if PCB == TI_BOARD
            _imp_exp  TLCD_Tab
#endif
            _imp_exp  setPoint
            _imp_exp  setColon
            _imp_exp  SetArrow
            EXTERN    DisplayNextData
            EXTERN    sys_status
#define ReInit      0x04
#define SecTick     0x20


  #endif
#else

// C part

#include "emeter-toolkit.h"
#include "emeter.h"


#define LCDchar(x,y) Char2LCD(x,y)
#define lcd_digit_table LCD_Tab

extern unsigned char SEC;
extern unsigned char MIN;
extern unsigned char HOUR;
extern unsigned char DAY;
extern unsigned char MONTH;
extern unsigned char YEAR;

extern const unsigned int CHAR_SPACE;
extern const unsigned int CHAR_MINUS;

extern const uint8_t TLCD_Tab[16];

extern unsigned int sys_status;

__cc_version1 void SetupClock(void);
#define SetupLCD SetupClock
__cc_version1 void Dis_Clock(void);
__cc_version1 void Dis_Date(void);
__cc_version1 void Display_BCD (unsigned char, unsigned char pos);
__cc_version1 void Char2LCD (unsigned char, unsigned char pos);
__cc_version1 void BCD2LCD (unsigned char, unsigned char pos);
__cc_version1 void Direct2LCD (unsigned int, unsigned char pos);
__cc_version1 void setPoint (unsigned char pos);
__cc_version1 void setColon (unsigned char pos);
__cc_version1 void SetArrow (unsigned char pos);
extern void DisplayNextData(void);

//void DisplayNextData(void);
#endif

#endif

