//--------------------------------------------------------------------------
//
//  Software for MSP430 based e-meters.
//
//  THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
//  REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
//  INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
//  FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
//  COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
//  TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
//  POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
//  INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
//  YOUR USE OF THE PROGRAM.
//
//  IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
//  CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
//  THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
//  OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
//  OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
//  EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
//  REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
//  OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
//  USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
//  AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
//  YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
//  (U.S.$500).
//
//  Unless otherwise stated, the Program written and copyrighted 
//  by Texas Instruments is distributed as "freeware".  You may, 
//  only under TI's copyright in the Program, use and modify the 
//  Program without any charge or restriction.  You may 
//  distribute to third parties, provided that you transfer a 
//  copy of this license to the third party and the third party 
//  agrees to these terms by its first use of the Program. You 
//  must reproduce the copyright notice and any other legend of 
//  ownership on each copy or partial copy, of the Program.
//
//  You acknowledge and agree that the Program contains 
//  copyrighted material, trade secrets and other TI proprietary 
//  information and is protected by copyright laws, 
//  international copyright treaties, and trade secret laws, as 
//  well as other intellectual property laws.  To protect TI's 
//  rights in the Program, you agree not to decompile, reverse 
//  engineer, disassemble or otherwise translate any object code 
//  versions of the Program to a human-readable form.  You agree 
//  that in no event will you alter, remove or destroy any 
//  copyright notice included in the Program.  TI reserves all 
//  rights not specifically granted under this license. Except 
//  as specifically provided herein, nothing in this agreement 
//  shall be construed as conferring by implication, estoppel, 
//  or otherwise, upon you, any license or other right under any 
//  TI patents, copyrights or trade secrets.
//
//  You may not use the Program in non-TI devices.
//
//	File: LCDdec16.c
//
//  Steve Underwood <steve-underwood@ti.com>
//  Texas Instruments Hong Kong Ltd.
//
//  Date        Comments
//  =====================
//	2002-09-16	Initial version
//      2004-05-28      Adopted for FE427 Demo (UPSF)
//
//    Version 1.0 first release for Application Report
//    06/04/04
//
//
//--------------------------------------------------------------------------
#include <stdint.h>
#include "emeter-toolkit.h"
#include "fet4xx_rtclcd.h"

//Display a signed 16 bit integer, as a decimal number,
//with leading zero suppression. "after" is the number
//of digits which are after the decimal point. The leading
//zero suppression allows for this.
void LCDdec16(int16_t value, int pos, int digits, int after)
{
	int i;
   	int flag;
   	unsigned int digit;
   	uint8_t bcd[3];

        if (pos > LCD_SIZE) pos = LCD_SIZE;
        if (digits > LCD_SIZE) digits = LCD_SIZE ;

	if (value < 0)
	{
		flag = 2;
		value = -value;
	}
	else
	{
		flag = 1;
                Direct2LCD(CHAR_SPACE, --digits);
	}
	bin2bcd16(bcd, value);
        while (digits >= pos)
        {
                  Direct2LCD(CHAR_SPACE, digits--);
        }        
        digits++;

        pos--;
	after = 5 - after;
   	for (i = 6 - digits;  i < 6;  i++)
   	{
   		digit = bcd[i >> 1];
   		if ((i & 1) == 0)
   			digit >>= 4;
   		if ((digit & 0x0F)  ||  i >= after)
   		{
   			if (flag == 2)
	   			Direct2LCD(CHAR_MINUS, pos+1);
   			flag = 0;
   	   	}
              (flag == 0)  ?  BCD2LCD((digit & 0xF),pos)  :  Direct2LCD(CHAR_SPACE, pos);
	      pos--;
  	}
      	after = 5 - after - 1;
        if (after > 0) setPoint(after);
}   
