// Created with Excel Table
// Date:  12/04/2008        Time:  10:15:12



#define  V_Gain   SD16GAIN_1
#define  I1_Gain  SD16GAIN_1
#define  I2_Gain  SD16GAIN_1

#define  SHUNT    0
#define  CT       1
#define  ROG_COIL 2
#define  NONE     3

#define      I1SENSOR                      CT
#define      I2SENSOR                      NONE

#define      defVRatio                     12.2133211261158
#define      defIRatio                     3.66216525520714
#define      defEnergyRatio                44.7272002787487

#define      defSET_CALVOLTAGE             240
#define      defSET_CALCURRENT             10
#define      defCalPhi                     60
#define      defCalCosPhi                  0.5
#define      defCalFreq                    50

// Phase Error Correction:
#define      defSET_PHASECORR1             242
#define      defSET_PHASECORR2             242

#define      PULSE_PER_KWH                 6400
#define      defSET_INTRPTLEVL_REPEAT      12
#define      _defSET_INTRPTLEVL            0xFFDD3FD8
#ifndef WITH_AVERAGING
#define      defSET_INTRPTLEVL_LO          (_defSET_INTRPTLEVL & 0xFFFF)
#define      defSET_INTRPTLEVL_HI          ((_defSET_INTRPTLEVL >> 16) & 0xFFFF)
#endif

/** Adjustment parameters for the two currents:  */
#define      defSET_ADAPTI1                16384
#define      defSET_ADAPTI2                16384

//   Nominal Mains Frequency: 
#define      defSET_NOMFREQ                50


/** Adjustment parameters start up currents: */
/* as Factor of calCurrent */
#ifdef WITH_START_CURRENT
#define      defSET_STARTCURR              (0.004 * defSET_CALCURRENT)
#define      defSET_STARTCURR_INT          (unsigned int)((defSET_STARTCURR * 1000 / defIRatio))
#define      defSET_STARTCURR_FRAC         (unsigned int)((defSET_STARTCURR * POW_2_16 * 1000 / defIRatio) - (POW_2_16 * defSET_STARTCURR_INT))
#else
#define      defSET_STARTCURR              0
#define      defSET_STARTCURR_INT          0
#define      defSET_STARTCURR_FRAC         0
#endif  // WITH_START_CURRENT
