//====================================================================
//  MSP430FE427 Application Program Example
//
//  This file send the data from the ESP430 via the serial communication
//  port
//
//  author Stefan Schauer
//  date   04/29/2003
//  fixed  calculation error within MainPeriod calculation
//
//
//    Version 1.0 first release for Application Report
//    06/04/04
//    Version 1.2
//    04/26/05  Fixed display of sign for cosphi
//    Version 1.3
//    11/26/07  Added more output modes
//    11/26/07  Added support for ESP_V2
//
//====================================================================

/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


#include "device.h"
#include "comms_uart.h"
#include "SendData.h"
#include "fet4xx_rtclcd.h"
#include "emeter.h"
#include "parameter.h"

#include <stdio.h>
#include <math.h>


#ifdef withUARTComm


#define	ldfs	"%ld"

// const and var definition
unsigned int TX_Mode = tx_off;  // Transmit mode

float avg_energy = 0;


volatile unsigned long ix = 10000;


void SendData(void)
{
  static unsigned int value;
  static signed int svalue;
  static unsigned long lvalue;
  static char strbuf[20];

  switch (TX_Mode)
  {
//    static unsigned i =0;
    case tx_off: break;
    case tx_ch1:

            _DINT();
//            SendResult((unsigned char*) &wfs1, 2);
//            SendString("\r");
            _EINT(); // Enable Interrupts
            break;
    case tx_ch2:
            _DINT();
//            SendResult((unsigned char*) &wfs2, 2);
//            SendString("\r");

//          while ((U0IFG&UTXIFG0)==0);            // wait till TX buf empty
//          TXBUF0=(wfs2>>8) & 0xFF;                        // transmit ch
//          while ((U0IFG&UTXIFG0)==0);            // wait till TX buf empty
//          TXBUF0=(wfs2) & 0xFF;                        // transmit ch
//extern unsigned int offset;
//          while ((U0IFG&UTXIFG0)==0);            // wait till TX buf empty
//          TXBUF0=(offset>>8) & 0xFF;                        // transmit ch
//          while ((U0IFG&UTXIFG0)==0);            // wait till TX buf empty
//          TXBUF0=(offset) & 0xFF;                        // transmit ch

//          while ((U0IFG&UTXIFG0)==0);            // wait till TX buf empty
//          TXBUF0=0xa5;                        // transmit ch


            _EINT(); // Enable Interrupts
            break;
    case tx_ch3:
            _DINT();
            SendResult((unsigned char*) &wfs3, 2);
            SendString("\r");
            _EINT(); // Enable Interrupts
            break;
    case tx_temp:
            SendString("\rTemp: ");
            SendResult((unsigned char*) &temperature, 2);
            SendString("\r");
            break;
    case tx_dump:
            SendChar(0x0C);
            SendString("Active Energy1: ");
            SendResult((unsigned char*) &energy, 4);
            SendChar('\r');

            energy.w[0] = REACTENERGY_LO;
            energy.w[1] = REACTENERGY_HI;
            SendString("Reactive Energy: ");
            SendResult((unsigned char*) &energy, 4);
            SendChar('\r');

            energy.w[0] = APPENERGY_LO;
            energy.w[1] = APPENERGY_HI;
            SendString("Apparent Energy: ");
            SendResult((unsigned char*) &energy, 4);
            SendChar('\r');

            value = V1RMS;
            SendString("V(RMS): ");
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

            value = IRMS_HI;
            SendString("I(RMS): ");
            SendResult((unsigned char*) &value, 2);
            SendChar('.');
            value = IRMS_LO;
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

            value = VPEAK;
            SendString("V(Peak): ");
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

            value = IPEAK;
            SendString("I(Peak): ");
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

            value = POWERFCT;
            SendString("PF: ");
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

//            value = (unsigned int)((unsigned char)CAPIND);
//            SendString("CapInd: ");
//            SendResult((unsigned char*) &value, 2);
            SendString("  Energy: ");
            if (negenfg != 0) { SendChar('-'); } else { SendChar('+'); }
            SendChar('\r');

            value = MAINSPERIOD;
            SendString("f: ");
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

            lvalue = LINECYCLCNT_LO;
            lvalue += (unsigned long)LINECYCLCNT_HI << 16;
            SendString("Cycles: ");
            SendResult((unsigned char*) &lvalue, 4);
            SendChar('\r');

            lvalue = NMBMEAS_LO;
            lvalue += (unsigned long)NMBMEAS_HI << 16;
            SendString("Num of Meas.: ");
            SendResult((unsigned char*) &lvalue, 4);
            SendChar('\r');

            value = eventFlags;
            SendString("Flags: ");
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

            SendChar('\r');
            break;
    case tx_energy:
            lvalue = (unsigned long)((float) energy.l * (s_parameters.EnergyRatio/1000));
            SendString("Active Energy1 (mW): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');
            break;
    case tx_cal:
            SendResult((unsigned char*) &energy, 4);
            SendChar('\r');
            energy.w[0] = ACTENERGY1_LO;
            energy.w[1] = ACTENERGY1_HI;
            SendResult((unsigned char*) &energy, 4);
            SendChar('\r');

            TX_Mode = tx_off;
            if ( OP_Mode == done) {
              stop_measurement();
              start_measurement();
            }
            break;

    case tx_values:
            SendChar(0x0C);

            SendString("Time: ");
            SendResult((unsigned char*) &HOUR, 1);
            SendString(":");
            SendResult((unsigned char*) &MIN, 1);
            SendString(":");
            SendResult((unsigned char*) &SEC, 1);
            SendString("    ");
            SendResult((unsigned char*) &DAY, 1);
            SendString(".");
            SendResult((unsigned char*) &MONTH, 1);
            SendString(".");
            SendResult((unsigned char*) &YEAR, 1);
            SendChar('\r');

            lvalue = ((unsigned long) (V1RMS * (s_parameters.VRatio*1000))/1000);
            SendString("V(RMS/mV): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = ((unsigned long) (IRMS_HI * (s_parameters.IRatio*1000))/1000);
            SendString("I(RMS/mA): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = ((unsigned long) (VPEAK * (s_parameters.VRatio*1000))/1000);
            SendString("V(Peak/mV): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = ((unsigned long) (IPEAK * s_parameters.IRatio*1000))/1000;
            SendString("I(peak/mA): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            svalue = POWERFCT;
            svalue = (signed int)((((signed long)svalue*1000)/POW_2_14));
            SendString("cosPhi(*1000): ");
            //if ((signed char)CAPIND > 0) SendChar('-');
            sprintf(strbuf, "%d",svalue);
            SendString(strbuf);
            SendChar('\r');

/*            value = (unsigned int)((unsigned char)CAPIND);
            SendString("CapInd: ");
            if (((signed char)CAPIND) < 0)
                SendString("Ind = ");
            else
                SendString("Cap = ");
            SendResult((unsigned char*) &value, 2);
            SendString("  Energy: ");
            if (negenfg == 0) { SendChar('+'); } else { SendChar('-'); }

            SendString("  Quad: I");
            if (((signed char)CAPIND) < 0)
            {
              	if (negenfg == 0) { }
                else { SendChar('I'); }
            }
            else
            {
              	if (negenfg == 0) { SendChar('V'); }
                else { SendChar('I');SendChar('I');}
            }

            SendChar('\r');
*/
            value = POWERFCT;
            SendString("PF: ");
            SendResult((unsigned char*) &value, 2);
            SendString("   ");

            value = s_parameters.pSET_PHASECORR1;
            SendString("PhaseCorr1: ");
            SendResult((unsigned char*) &value, 2);
            SendString("   ");
            value = s_parameters.pSET_PHASECORR2;
            SendString("PhaseCorr2: ");
            SendResult((unsigned char*) &value, 2);
            SendChar('\r');

            value = (unsigned int)((float)MAINSPERIOD*((float)(1000000)/((float)(1048576))));
            SendString("Main Period(us): ");
            sprintf(strbuf, "%d",value);
            SendString(strbuf);
            SendChar('\r');

            SendString("Frequency(mHz): ");
            lvalue = (unsigned long)((float)(1000000*1000/((float)value)));
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = (unsigned long)((float) energy.l * (s_parameters.EnergyRatio/1000));
            SendString("Active Energy1 (mW): ");
            if (negenfg != 0) { SendChar('-'); }
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = (unsigned long)REACTENERGY_HI << 16;
            lvalue += REACTENERGY_LO;
            lvalue = (unsigned long)((float) lvalue * (s_parameters.EnergyRatio/1000));
            SendString("Reactive Energy1 (mVAR): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = (unsigned long)APPENERGY_HI << 16;
            lvalue += APPENERGY_LO;
            lvalue = (unsigned long)((float) lvalue * (s_parameters.EnergyRatio/1000));
            SendString("Apparent Energy1 (mVA): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = (unsigned long)((float) total_energy * (float)(s_parameters.EnergyRatio)/(float)((float)1000000*(float)3600));
            SendString("Active TotalEnergy1 (Wh): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = (unsigned long) (((unsigned long)temperature * (s_parameters.ulTempGain))/100 - (s_parameters.ulTempOffset));
            SendString("Temperature(*100/degree): ");
            sprintf(strbuf, ldfs,lvalue);
            SendString(strbuf);
            SendChar('\r');

            lvalue = LINECYCLCNT_LO;
            lvalue += (unsigned long)LINECYCLCNT_HI << 16;
            SendString("Cycles: ");
            SendResult((unsigned char*) &lvalue, 4);
            SendChar('\r');

            lvalue = NMBMEAS_LO;
            lvalue += (unsigned long)NMBMEAS_HI << 16;
            SendString("Num of Meas.: ");
            SendResult((unsigned char*) &lvalue, 4);
            SendChar('\r');

            break;
    case tx_test:
            {
/*              static char count = 0;
              count ++;
              if (count >= 1)
              {
                count =0;

//                lvalue = (unsigned long)energy.l;
//                SendString("Energy = ");

//                SendString("Frequency(mHz) = ");
//                lvalue = (unsigned long)((float)(1000)*(float)(1048576)/(float)MAINSPERIOD );

//                sprintf(strbuf, ldfs,lvalue);
//                SendString(strbuf);
//                SendChar('\r');

                value = IRMS_HI;
                SendString("I(RMS): ");
                SendResult((unsigned char*) &value, 2);
                SendChar('.');
                value = IRMS_LO;
                SendResult((unsigned char*) &value, 2);
                SendChar('\r');
              }
*/
                   unsigned int data;
                SendString("Time: ");
                SendResult((unsigned char*) &HOUR, 1);
                SendString(":");
                SendResult((unsigned char*) &MIN, 1);
                SendString(":");
                SendResult((unsigned char*) &SEC, 1);
                SendString("    ");
                   data = read_parameter(694);   // DCoffsetU1
                   SendString("0x");
                   SendResult((unsigned char*) &data, 2);
                   SendChar('\r');
            }
            break;
    case tx_test1:
            {
                 lvalue = (unsigned long)energy.l;
                 SendString("Energy = ");

                 sprintf(strbuf, ldfs,lvalue);
                 SendString(strbuf);
                 SendChar('\r');
            }
            break;
    case tx_test2:
            {
                static int new_valueCount = 0;
                if  (new_valueCount++ ==8)
                {
                   new_valueCount = 0;
                   avg_energy = (long)(fabs(total_energy))>>3;
                   total_energy = 0;
                   lvalue = (unsigned long)avg_energy;
                   SendString("Energy = ");

                   sprintf(strbuf, ldfs,lvalue);
                   SendString(strbuf);
                   SendChar('\r');
                }
            }
            break;
    case tx_test3:
            {
                static int new_valueCount = 0;
                static float sumActE1 = 0;

                energy.w[0] = ACTENERGY1_LO;
                energy.w[1] = ACTENERGY1_HI;
                sumActE1 +=  energy.l;
                new_valueCount++;
                if  (new_valueCount ==8)
                {
                   new_valueCount = 0;

                   avg_energy = (long)(fabs(sumActE1))>>3;
                   lvalue = (unsigned long)avg_energy;
                   SendString("P1 = ");
                   sprintf(strbuf, ldfs,lvalue);
                   SendString(strbuf);
                   sumActE1 = 0;

                   SendChar('\r');
                }
            }
            break;

    case tx_test4:
            {

                 volatile unsigned long i = ix;
                 while (i-- >0);
                 lvalue = (unsigned long)IRMS_HI;
                 SendString("IRMS = ");

                 sprintf(strbuf, ldfs,lvalue);
                 SendString(strbuf);
                 SendChar('\r');
            }
            break;
    case tx_test5:   // t13
            {
              static char count = 0;
			  static double act_avg = 0;
			  static double rea_avg = 0;
			  static double app_avg = 0;
              count ++;
              lvalue = (unsigned long)ACTENERGY1_HI << 16;
              lvalue += ACTENERGY1_LO;
              act_avg += lvalue;

              lvalue = (unsigned long)REACTENERGY_HI << 16;
              lvalue += REACTENERGY_LO;
              rea_avg += lvalue;

              lvalue = (unsigned long)APPENERGY_HI << 16;
              lvalue += APPENERGY_LO;
              app_avg += lvalue;

              if (count == 60)
              {

				count =0;

				lvalue = (unsigned long)(act_avg / 60);
                SendString("Active Energy: ");
                SendResult((unsigned char*) &lvalue, 4);
                SendChar('\r');
				act_avg = 0;

				lvalue = (unsigned long)(rea_avg / 60);
                SendString("Reactive Energy: ");
                SendResult((unsigned char*) &lvalue, 4);
                SendChar('\r');
				rea_avg = 0;

				lvalue = (unsigned long)(app_avg / 60);
                SendString("Apparent Energy: ");
                SendResult((unsigned char*) &lvalue, 4);
                SendChar('\r');
				app_avg = 0;

              }
            }
            break;

    case tx_test6:   // t15
            {
              static char count = 0;
              static double act_avg = 0;
              static double rea_avg = 0;
              static double app_avg = 0;

              count ++;
              lvalue = (long)ACTENERGY1_HI << 16;
              lvalue += ACTENERGY1_LO;
              act_avg += lvalue;

              lvalue = (long)REACTENERGY_HI << 16;
              lvalue += REACTENERGY_LO;
              rea_avg += lvalue;

              lvalue = (long)APPENERGY_HI << 16;
              lvalue += APPENERGY_LO;
              app_avg += lvalue;

              if (count == 5)
              {

				count =0;

				lvalue = (unsigned long)(act_avg / 5);
                SendString("Active Energy: ");
                SendResult((unsigned char*) &lvalue, 4);
                SendChar('\r');
				act_avg = 0;

				lvalue = (unsigned long)(rea_avg / 5);
                SendString("Reactive Energy: ");
                SendResult((unsigned char*) &lvalue, 4);
                SendChar('\r');
				rea_avg = 0;

				lvalue = (unsigned long)(app_avg / 5);
                SendString("Apparent Energy: ");
                SendResult((unsigned char*) &lvalue, 4);
                SendChar('\r');
				app_avg = 0;

              }
            }
            break;


  default:
            break;
  }

}



void SendValue(unsigned int parm)
{
  unsigned int value;
  unsigned long lvalue;
  float fvalue;
  unsigned long activeEnergy;

    activeEnergy = (unsigned long)((float) total_energy * (float)(s_parameters.EnergyRatio)/((float)1000000*(float)3600));

    switch (parm)
    {
      case send_clock:
            //SendString("Time: ");
            SendChar(Digit1(HOUR));	// High digit
            SendChar(Digit0(HOUR));	// Low digit
            SendChar(':');
            SendChar(Digit1(MIN));	// High digit
            SendChar(Digit0(MIN));	// Low digit
            SendChar(':');
            SendChar(Digit1(SEC));	// High digit
            SendChar(Digit0(SEC));	// Low digit
            break;
      case send_date:
            #if date_format == MMDDYY		// US Format
              SendChar(Digit1(MONTH));	// High digit
              SendChar(Digit0(MONTH));	// Low digit
              SendChar('/');
              SendChar(Digit1(DAY));	// High digit
              SendChar(Digit0(DAY));	// Low digit
              SendChar('/');
              SendChar(Digit1(YEAR));	// High digit
              SendChar(Digit0(YEAR));	// Low digit
            #else							// European Format
              SendChar(Digit1(DAY));	// High digit
              SendChar(Digit0(DAY));	// Low digit
              SendChar('.');
              SendChar(Digit1(MONTH));	// High digit
              SendChar(Digit0(MONTH));	// Low digit
              SendChar('.');
              SendChar(Digit1(YEAR));	// High digit
              SendChar(Digit0(YEAR));	// Low digit
            #endif
            break;
      case send_volt:
            lvalue = ((unsigned long) ((V1RMS) * (s_parameters.VRatio*1000))/1000);
            SendFloat(lvalue,3);
            break;
      case send_current:
            lvalue = ((unsigned long) (IRMS_HI * s_parameters.IRatio*1000))/1000;
            SendFloat(lvalue,3);
            break;
      case send_vpeak:
            lvalue = ((unsigned long) ((VPEAK) * (s_parameters.VRatio*1000))/1000);
            SendFloat(lvalue,3);
            break;
      case send_ipeak:
            lvalue = ((unsigned long) (IPEAK * s_parameters.IRatio*1000))/1000;
            SendFloat(lvalue,3);
            break;
      case send_freq:
            lvalue = (unsigned long)((float)((long)1000*(long)256*(long)4096))/((float)MAINSPERIOD);
            SendFloat(lvalue,3);
            break;
      case send_cosphi:
            value = (unsigned int)((((unsigned long)POWERFCT*1000)/POW_2_14));
            lvalue = ((((unsigned long)POWERFCT*1000)/POW_2_14));
//            if ((signed char)CAPIND < 0)
//            { SendChar('-'); }
//            else
//            { SendChar('+'); }
            SendFloat(lvalue,3);
            break;
/*      case send_ch1:
                LCDdecu16(wfs1, 5, 7, 0);
              break;
      case send_ch2:
                LCDdecu16(wfs2, 5, 7, 0);
              break;
      case send_ch3:
                LCDdecu16(wfs3, 5, 7, 0);
              break;  */
      case send_temp:
            lvalue = (unsigned long) (((unsigned long)temperature * (s_parameters.ulTempGain))/100 - (s_parameters.ulTempOffset));
            SendFloat(lvalue,2);
            break;
      case send_power:
            if (negenfg != 0) { SendChar('-'); }
            fvalue = ((float) energy.l * (float)(s_parameters.EnergyRatio)/(1000000));
            if (fvalue <= 1000)
            {
		lvalue = (unsigned long)(fvalue*1000);// Active Power (kW);
		SendFloat(lvalue,6);	
            }
            else
            {
                lvalue = (unsigned long)fvalue;
                SendFloat(value,3);
            }
            break;
      case send_energy:
            lvalue = activeEnergy;		// Active Energy1 (kWh):
            SendFloat(lvalue,3);		
            break;
	  case send_msgin:
      case send_last:
      default:
           break;
    }

	SendChar('\r');		// End the string with carriage return

}

#endif // withUARTComm
