//**************************************************************************
//    Calibration Routines for the FE427
//
//    Stefan Schauer
//    Texas Instruments Freising
//    Date        Comments
//    =====================
//    01/09/03    Code Starts for FE427
//    03/28/04    Fixed error in Phase Error Correction
//    05/06/04    Fixed error in Phase Error Correction
//
//    Version 1.0 first release for Application Report
//    06/04/04
//    Version 1.1
//    08/19/04  added calibration of POFFSETx
//    Version 1.2
//    12/23/04  changed calibration function (+/-) to use values instead of
//                steps
//    01/25/05  changed sign of Phase shift calibration
//    Version 1.3
//    11/23/07  added calibration of IADAPTx value
//              added calibration of CORRCOMP value
//
//**************************************************************************

/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */

#include "device.h"
#include "calibration.h"
#include "emeter.h"
#include "SendData.h"
#include "parameter.h"
#include "emeter-toolkit.h"
#include "subroutines.h"

#include <math.h>

#ifdef withCalibration
int   calCurrent = defSET_CALCURRENT;
int   calVoltage = defSET_CALVOLTAGE;

void CalPlus(unsigned char Cal_Mode, unsigned int value)
{
    if (Cal_Mode == 1) s_parameters.pSET_INTRPTLEVL.l -= (s_parameters.pSET_INTRPTLEVL.l/1000)*value;
    if (Cal_Mode == 2) s_parameters.pSET_PHASECORR1 -= value;
    if (Cal_Mode == 3) s_parameters.pSET_PHASECORR2 -= value;

    if (Cal_Mode == 4) s_parameters.pSET_V1OFFSET += value;  //
    if (Cal_Mode == 5) s_parameters.pSET_I1OFFSET += value;    //
    if (Cal_Mode == 6) s_parameters.pSET_I2OFFSET += value;    //
    if (Cal_Mode == 7) s_parameters.pSET_GAINCORR1 += (unsigned int)(((long)s_parameters.pSET_GAINCORR1*value)/1000);    //   - 0.5%
    if (Cal_Mode == 8) s_parameters.pSET_GAINCORR2 += (unsigned int)(((long)s_parameters.pSET_GAINCORR2*value)/1000);    //   - 0.5%

    if (Cal_Mode == 10) s_parameters.VRatio += s_parameters.VRatio*value/1000;  // dec by 0.1%
    if (Cal_Mode == 11) s_parameters.IRatio += s_parameters.IRatio*value/1000;  // dec by 0.1%
    if (Cal_Mode == 12) s_parameters.EnergyRatio += s_parameters.EnergyRatio*value/1000;  // dec by 0.1%

    if (Cal_Mode == 13) s_parameters.pSET_POFFSET1.l += value;
    if (Cal_Mode == 14) s_parameters.pSET_POFFSET2.l += value;
//    if (Cal_Mode == 15) s_parameters.pSET_POFFSET1.l += (unsigned int)(((long)s_parameters.pSET_POFFSET1.l*value)/1000);
//    if (Cal_Mode == 16) s_parameters.pSET_POFFSET2.l += (unsigned int)(((long)s_parameters.pSET_POFFSET2.l*value)/1000);
    if (Cal_Mode == 17) s_parameters.pSET_ADAPTI1 += (unsigned int)(((long)s_parameters.pSET_ADAPTI1*value)/1000);    //   - 0.5%
    if (Cal_Mode == 18) s_parameters.pSET_ADAPTI2 += (unsigned int)(((long)s_parameters.pSET_ADAPTI2*value)/1000);    //   - 0.5%
#ifdef ESP_V2
    if (Cal_Mode == 19) s_parameters.pSET_CORRCOMP += value;
#endif

    // Init. Embedded Signal Processing parameters
    init_esp_parameters(0);
    // Init. event generation and start measurement
    start_measurement();
}

void CalMinus(unsigned char Cal_Mode, unsigned int value)
{
    if (Cal_Mode == 1) s_parameters.pSET_INTRPTLEVL.l += (s_parameters.pSET_INTRPTLEVL.l/1000)*value;
    if (Cal_Mode == 2) s_parameters.pSET_PHASECORR1 += value;
    if (Cal_Mode == 3) s_parameters.pSET_PHASECORR2 += value;

    if (Cal_Mode == 4) s_parameters.pSET_V1OFFSET -= value;  //
    if (Cal_Mode == 5) s_parameters.pSET_I1OFFSET -= value;    //
    if (Cal_Mode == 6) s_parameters.pSET_I2OFFSET -= value;    //
    if (Cal_Mode == 7) s_parameters.pSET_GAINCORR1 -= (unsigned int)(((long)s_parameters.pSET_GAINCORR1*value)/1000);    //   - 0.5%
    if (Cal_Mode == 8) s_parameters.pSET_GAINCORR2 -= (unsigned int)(((long)s_parameters.pSET_GAINCORR2*value)/1000);    //   - 0.5%

    if (Cal_Mode == 10) s_parameters.VRatio -= s_parameters.VRatio*value/1000;  // dec by 0.1%
    if (Cal_Mode == 11) s_parameters.IRatio -= s_parameters.IRatio*value/1000;  // dec by 0.1%
    if (Cal_Mode == 12) s_parameters.EnergyRatio -= s_parameters.EnergyRatio*value/1000;  // dec by 0.1%

    if (Cal_Mode == 13) s_parameters.pSET_POFFSET1.l -= value;
    if (Cal_Mode == 14) s_parameters.pSET_POFFSET2.l -= value;
//    if (Cal_Mode == 15) s_parameters.pSET_POFFSET1.l -= (unsigned int)(((long)s_parameters.pSET_POFFSET1.l*value)/1000);
//    if (Cal_Mode == 16) s_parameters.pSET_POFFSET2.l -= (unsigned int)(((long)s_parameters.pSET_POFFSET2.l*value)/1000);
    if (Cal_Mode == 17) s_parameters.pSET_ADAPTI1 -= (unsigned int)(((long)s_parameters.pSET_ADAPTI1*value)/1000);    //   - 0.5%
    if (Cal_Mode == 18) s_parameters.pSET_ADAPTI2 -= (unsigned int)(((long)s_parameters.pSET_ADAPTI2*value)/1000);    //   - 0.5%
#ifdef ESP_V2
    if (Cal_Mode == 19) s_parameters.pSET_CORRCOMP -= value;
#endif

    // Init. Embedded Signal Processing parameters
    init_esp_parameters(0);
    // Init. event generation and start measurement
    start_measurement();
}

void CalMode(unsigned char Cal_Mode)
{
    float fvalue;
    unsigned int i = 0;
#ifdef withUARTComm
    unsigned char saved_tx_mode;
#endif

    LCDM16 |= 0xF0;      // Turn on all unused segments of LCD
    if (Cal_Mode == 0)
    {
#ifdef withUARTComm
        saved_tx_mode = TX_Mode; // save tx_mode
#endif
        // Init. Embedded Signal Processing parameters
        s_parameters.IRatio = 1;
        s_parameters.VRatio = 1;
        s_parameters.EnergyRatio = 1;
        s_parameters.pSET_STARTCURR_INT = 0;
        s_parameters.pSET_STARTCURR_FRAC = 0;
        s_parameters.pSET_GAINCORR1 = defSET_GAINCORR1;
        s_parameters.pSET_GAINCORR2 = defSET_GAINCORR2;
//        s_parameters.pSET_INTRPTLEVL.l = 0x80000000;
        init_esp_parameters(0);
        // Init. event generation and start measurement
        start_measurement();
        while ((i++) < 3)
      {
         WaitLPM();   // Wait in Low-Power mode.  Handle other interrupts.
      } // wait for values
        fvalue = (float)((((float)POWERFCT)/POW_2_14));
        fvalue = acos(fvalue);
        fvalue = fvalue*180/__PI;  // convert to degree
        fvalue = fvalue + defCalPhi;
        fvalue = fvalue * (POW_2_20 / (360ul * defCalFreq));
        s_parameters.pSET_PHASECORR1 = s_parameters.pSET_PHASECORR1 + (int) fvalue;
//        s_parameters.pSET_PHASECORR2 = (int) 0;

        #define CalTime 5
        CalCyclCnt = CalTime * 50;    // Set Cycles to CalTime * 1 sec (@50Hz)
        // Init. event generation and start measurement
        start_calibration();

        i=0;
      while ((OP_Mode != done) && (i++ <= CalTime))
      {
         WaitLPM();   // Wait in Low-Power mode.  Handle other interrupts.
      } // wait for stable values
        s_parameters.VRatio = (float) ((long)calVoltage * 1000) / V1RMS;
        #define scale (float)( (float)1000 * (float)1000 * (float)calCosPhi * (float)CalTime / (float)16 )
        s_parameters.IRatio = (float) ((long)calCurrent * 1000) / IRMS_HI;
        s_parameters.pSET_GAINCORR1 = (unsigned int)((float) s_parameters.VRatio/defVRatio * (float)s_parameters.IRatio/defIRatio * (float)POW_2_14);
        s_parameters.EnergyRatio = defEnergyRatio;

        s_parameters.pSET_STARTCURR_INT  = (unsigned int)((defSET_STARTCURR * calCurrent * 1000 / s_parameters.IRatio));
        s_parameters.pSET_STARTCURR_FRAC = (unsigned int)((defSET_STARTCURR * calCurrent * POW_2_16 * 1000 / s_parameters.IRatio) - (defSET_STARTCURR_INT * POW_2_16));

        // Set Temperature Gain
        s_parameters.ulTempGain = ((unsigned long)defCalTemp*100 + s_parameters.ulTempOffset*100)/((unsigned long)temperature);

        // Init. Embedded Signal Processing parameters
        init_esp_parameters(0);
        // Init. event generation and start measurement
        start_measurement();
#ifdef withUARTComm
        TX_Mode = saved_tx_mode;
#endif
    }

    if (Cal_Mode == 9)
    {
        // save Parameters
        flash_clr((int *) (&s_parameters_flash));
        {
           unsigned int ssize = sizeof(s_parameters);
           i = 0;
           while (i < ssize)
           {
              char * ptemp = ((char *) &s_parameters);
              flash_write_int8((int8_t *)(((char *)&s_parameters_flash + i)), (int) ptemp[i]);
              i++;
           }
        }
        // Init. Embedded Signal Processing parameters
        init_esp_parameters(1);
        // Init. event generation and start measurement
        start_measurement();

        _EINT();  // Interrupts has been disabled during Flash write/erase
    }

   LCDM16 &= ~(0xF0);      // Turn off unused segments of LCD

}
#endif // withCalibration
