#ifndef __emeter
#define __emeter

#include "parameter.h"


enum {idle, measure, calibration, done, request_cal};
extern unsigned int OP_Mode;  // operation mode
extern unsigned int eventFlags;

extern unsigned int CalCyclCnt;     // Register for Cycle calculation of Calibration

extern unsigned int sys_status;   // System status bits
#define NewValues   0x01
#define DoCalc      0x02
#define ReInit      0x04
#define RequestTemp 0x08
#define NewTemp     0x10
#define SecTick     0x20

extern const int phasecorr_table[];


/// Saves firmware version during initialization.
extern unsigned int firmware_version;
/// global flag for Negative Energy
extern unsigned char negenfg;
/// Cumulated active energy.
extern float total_energy;
/// Last temperature measurement result.
extern unsigned int temperature;
/// Set Mask for Events which should be displayed at a port pin (P1.0)
extern unsigned int testBitMask;


extern unsigned int wfs1;
extern unsigned int wfs2;
extern unsigned int wfs3;

union tu_long_word{unsigned long l; unsigned int w[2];};
union tu_ulong_word{unsigned int w[2]; unsigned long l;};
union ts_long_word{signed long l; unsigned int w[2];};

extern union ts_long_word energy;

extern unsigned long P_reading;

#ifdef WITH_AVERAGING
extern union tu_long_word tcenergy;
extern unsigned long tc;
extern float fAverageFactor;
#endif  // WITH_AVERAGING

#ifdef MAINCPU_ENERGYPULSE
extern char cMainCPU_EnPulseMode;
#endif

struct ts_parameters{
          float VRatio;
          float IRatio;
          float EnergyRatio;
          int pSET_PHASECORR1;
          int pSET_PHASECORR2;
          unsigned int pSET_GAINCORR1;
          unsigned int pSET_GAINCORR2;
          int pSET_V1OFFSET;
          int pSET_I1OFFSET;
          int pSET_I2OFFSET;
          unsigned int pSET_ADAPTI1;
          unsigned int pSET_ADAPTI2;
          unsigned int pSET_STARTCURR_INT;
          unsigned int pSET_STARTCURR_FRAC;
          union tu_ulong_word pSET_INTRPTLEVL;
          unsigned long ulTempGain;
          unsigned long ulTempOffset;
          union ts_long_word pSET_POFFSET1;
          union ts_long_word pSET_POFFSET2;
#ifdef ESP_V2
          unsigned int pSET_CORRCOMP;
#endif
          };

extern struct ts_parameters s_parameters;

#ifdef __IAR_SYSTEMS_ICC__
#if __VER__ < 200
#pragma memory=constseg(INFOA)
#else
#pragma constseg=INFOA
#endif
#endif

#ifdef __CROSSWORKS_MSP430
#pragma constseg("INFO")
#endif
extern const struct ts_parameters s_parameters_flash;
#ifdef __IAR_SYSTEMS_ICC__
#if __VER__ < 200
#pragma memory=default
#else
#pragma constseg=default
#endif
#endif

#ifdef __CROSSWORKS_MSP430
#pragma constseg(default)
#endif


// forward declarations
void init_system(void);
void init_analog_front_end(void);
void init_esp(unsigned char flashvars);
void init_esp_parameters(unsigned char flashvars);
void start_measurement(void);
void stop_measurement(void);
void start_calibration(void);
void set_esp_active(void);
void set_esp_idle(void);
void set_parameter(unsigned int param, unsigned int data);
unsigned int read_parameter(unsigned int param);

#endif /* __emeter */
