//====================================================================
//
//  ESP430CE1 Application Program Example
//
//  This file contains the TimerA routines which are used to generate
//  gitter free Energy output pulses
//
//  author Stefan Schauer
//  date   02/08/2004
//
//  Modified Stefan Schauer
//  date   03/23/2004
//    Changes:
//     - modified TimerA Pulse output for higher Pulse rates
//
//    Version 1.0 first release for Application Report
//    06/04/04
//    Version 1.2
//    03/07/05  Removed Averaging function
//
//====================================================================

/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted
* by Texas Instruments is distributed as "freeware".  You may,
* only under TI's copyright in the Program, use and modify the
* Program without any charge or restriction.  You may
* distribute to third parties, provided that you transfer a
* copy of this license to the third party and the third party
* agrees to these terms by its first use of the Program. You
* must reproduce the copyright notice and any other legend of
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains
* copyrighted material, trade secrets and other TI proprietary
* information and is protected by copyright laws,
* international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's
* rights in the Program, you agree not to decompile, reverse
* engineer, disassemble or otherwise translate any object code
* versions of the Program to a human-readable form.  You agree
* that in no event will you alter, remove or destroy any
* copyright notice included in the Program.  TI reserves all
* rights not specifically granted under this license. Except
* as specifically provided herein, nothing in this agreement
* shall be construed as conferring by implication, estoppel,
* or otherwise, upon you, any license or other right under any
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


#include "emeter.h"
#include "parameter.h"
#include "TimerA.h"
#include "device.h"

#ifdef TIMERA_PULSE_OUTPUT

signed long pulsesumenergy = 0;

void Init_TimerA(void)
{
    TACCR0 = CLOCKSPERPERIOD/100;
    TACTL = TACLR | MC_1 | TimerAClock;
    TACCTL0 = OUTMOD_3+CCIE;
}

//------------------------------------------------------------------------------
//      TA_ISR    ; TimerA Interrupt Routine
//------------------------------------------------------------------------------
#ifdef __IAR_SYSTEMS_ICC__
#if __VER__ < 200
interrupt[TIMERA0_VECTOR] void TimerA0_ISR(void)
#else
#pragma vector=TIMERA0_VECTOR
__interrupt void TimerA0_ISR( void )
#endif
#endif

#ifdef __CROSSWORKS_MSP430
void TimerA0_ISR(void)   __interrupt[TIMERA0_VECTOR]
#endif

#ifdef __TI_COMPILER_VERSION__
__interrupt void TimerA0_ISR(void);
TIMERA0_ISR(TimerA0_ISR)
__interrupt void TimerA0_ISR(void)
#endif

{
        static unsigned int total_energy_led_remaining_time = 0;
        if (P_reading >= ENERGY_PULSE_THRESHOLD)
        {
#ifdef INVERT_PULSE
          P1OUT &= ~(BIT1);
#else
          P1OUT |= BIT1;
#endif
          total_energy_led_remaining_time = CLOCKSPERPERIOD/ENERGY_PULSE_DURATION;
          pulsesumenergy += P_reading;
          P_reading -= ENERGY_PULSE_THRESHOLD;
        }

        if (total_energy_led_remaining_time  &&  --total_energy_led_remaining_time == 0)
        {
#ifdef INVERT_PULSE
          P1OUT |= BIT1;
#else
          P1OUT &= ~(BIT1);
#endif
        }
}


#endif  // TIMERA_PULSE_OUTPUT
