//--------------------------------------------------------------------------
//
//  Software for MSP430 based e-meters.
//
//  THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
//  REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
//  INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
//  FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
//  COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
//  TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
//  POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
//  INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
//  YOUR USE OF THE PROGRAM.
//
//  IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
//  CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
//  THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
//  OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
//  OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
//  EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
//  REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
//  OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
//  USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
//  AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
//  YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
//  (U.S.$500).
//
//  Unless otherwise stated, the Program written and copyrighted 
//  by Texas Instruments is distributed as "freeware".  You may, 
//  only under TI's copyright in the Program, use and modify the 
//  Program without any charge or restriction.  You may 
//  distribute to third parties, provided that you transfer a 
//  copy of this license to the third party and the third party 
//  agrees to these terms by its first use of the Program. You 
//  must reproduce the copyright notice and any other legend of 
//  ownership on each copy or partial copy, of the Program.
//
//  You acknowledge and agree that the Program contains 
//  copyrighted material, trade secrets and other TI proprietary 
//  information and is protected by copyright laws, 
//  international copyright treaties, and trade secret laws, as 
//  well as other intellectual property laws.  To protect TI's 
//  rights in the Program, you agree not to decompile, reverse 
//  engineer, disassemble or otherwise translate any object code 
//  versions of the Program to a human-readable form.  You agree 
//  that in no event will you alter, remove or destroy any 
//  copyright notice included in the Program.  TI reserves all 
//  rights not specifically granted under this license. Except 
//  as specifically provided herein, nothing in this agreement 
//  shall be construed as conferring by implication, estoppel, 
//  or otherwise, upon you, any license or other right under any 
//  TI patents, copyrights or trade secrets.
//
//  You may not use the Program in non-TI devices.
//
//  File: emeter-rtc.c
//
//  Steve Underwood <steve-underwood@ti.com>
//  Texas Instruments Hong Kong Ltd.
//
//  $Id: emeter-rtc.c,v 1.5 2009/04/23 07:32:08 a0754793 Exp $
//
/*! \file emeter-structs.h */
//
//--------------------------------------------------------------------------
#include <stdint.h>
#include <stdlib.h>
#if !defined(__MSP430__)
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#endif
#if defined(__GNUC__)
#include <signal.h>
#endif
#if defined(__MSP430__)
#include <io.h>
#endif
#include <emeter-toolkit.h>

#include "emeter-structs.h"
unsigned char RF_Tx[17], XOR_res=0;
#if !defined(NULL)
#define NULL    (void *) 0
#endif

#if defined(CORRECTED_RTC_SUPPORT)
int32_t rtc_correction;
#endif

/* We need a small seconds counter, so we can do things like a display update every 2 seconds. */
uint8_t seconds;

#if defined(RTC_SUPPORT)
void rtc_bumper(void)
{
    int i;

    i = bump_rtc();
    /* And now, a series of optional routines to get actions to take
       place at various intervals. Remember, we are in an interrupt
       routine. Do not do anything very complex here. If a complex action
       is needed set a flag in a simple routine and do the main work in
       the non-interrupt code's main loop. */
    #if defined(PER_YEAR_ACTIVITY_SUPPORT)
    if (i >= RTC_CHANGED_YEAR)
        per_year_activity();    
    #endif
    #if defined(PER_MONTH_ACTIVITY_SUPPORT)
    if (i >= RTC_CHANGED_MONTH)
        per_month_activity();
    #endif
    #if defined(PER_DAY_ACTIVITY_SUPPORT)  ||  defined(MULTI_RATE_SUPPORT)
    if (i >= RTC_CHANGED_DAY)
    {
        #if defined(PER_MINUTE_ACTIVITY_SUPPORT)
        per_day_activity();
        #endif
        #if defined(MULTI_RATE_SUPPORT)
        tariff_flags |= TARIFF_NEW_DAY;
        #endif
    }
    #endif
    #if defined(PER_HOUR_ACTIVITY_SUPPORT)
    if (i >= RTC_CHANGED_HOUR)
        per_hour_activity();
    #endif
    #if defined(PER_MINUTE_ACTIVITY_SUPPORT)  ||  defined(MULTI_RATE_SUPPORT)  ||  defined(BATTERY_MONITOR_SUPPORT)
    if (i >= RTC_CHANGED_MINUTE)
    {
        #if defined(PER_MINUTE_ACTIVITY_SUPPORT)
        per_minute_activity();
        #endif
        #if defined(MULTI_RATE_SUPPORT)
        tariff_flags |= TARIFF_NEW_MINUTE;
        #endif
        #if defined(BATTERY_MONITOR_SUPPORT)
        test_battery();
        #endif
    }
    #endif
    #if defined(PER_SECOND_ACTIVITY_SUPPORT)
    if (i >= RTC_CHANGED_SECOND)
        per_second_activity();
    #endif
    //adc_interrupts = 0;
}
#endif

#if (defined(RTC_SUPPORT)  ||  defined(CUSTOM_RTC_SUPPORT))  &&  defined(CORRECTED_RTC_SUPPORT)
void correct_rtc(void)
{
    int32_t temp;

    /* Correct the RTC to allow for basic error in the crystal, and
       temperature dependant changes. This is called every two seconds,
       so it must accumulate two seconds worth of error at the current
       temperature. */
    if (nv_parms.seg_a.s.temperature_offset)
    {
        temp = temperature - nv_parms.seg_a.s.temperature_offset;
        temp *= nv_parms.seg_a.s.temperature_scaling;
        temp >>= 16;

        /* The temperature is now in degrees C. */
        /* Subtract the centre point of the crystal curve. */
        temp -= 25;
        /* Do the parabolic curve calculation, to find the current ppm of
           error due to temperature, and then the scaled RTC correction
           value for 2 seconds at this temperature. */
        temp = temp*temp*(2589L*4295L >> 5);
        temp >>= 11;
        temp = -temp;
    }
    else
    {
        temp = 0;
    }
    /* Allow for the basic manufacturing tolerance error of the crystal, found
       at calibration time. */
    temp += nv_parms.seg_a.s.crystal_base_correction;
    if (rtc_correction >= 0)
    {
        rtc_correction += temp;
        if (rtc_correction < 0)
        {
            rtc_correction -= 0x80000000;
            /* We need to add an extra second to the RTC */
    #if defined(CUSTOM_RTC_SUPPORT)
            custom_rtc();
    #else
            rtc_bumper();
    #endif
        }
    }
    else
    {
        rtc_correction += temp;
        if (rtc_correction >= 0)
        {
            rtc_correction += 0x80000000;
            /* We need to drop a second from the RTC */
            meter_status |= SKIP_A_SECOND;
        }
    }
}
#endif

#if defined(__MSP430__)
    #if defined(__MSP430_HAS_BT__)  ||  defined(__MSP430_HAS_BT_RTC__)
ISR(BASICTIMER, one_second_ticker)
    #else
ISR(WDT, one_second_ticker)
    #endif
{
    unsigned volatile int i=0;
    //unsigned char RF_Tx[17], XOR_res=0;
    extern char Send_flag;
    extern char char_gen[];
    long long temp=0;
    static int thou,hun,ten,unit,ten_thou;
    volatile unsigned int LCD_reg; 
    //unsigned static Send_flag=0;
    #if defined(POWER_DOWN_SUPPORT)  &&  defined(POWER_UP_BY_SUPPLY_SENSING)
        #if defined(__MSP430_HAS_COMPA__)  ||  (defined(POWER_GOOD_SENSE)  &&  defined(POWER_GOOD_THRESHOLD_HIGH))
    int i;
    int j;
        #endif
    #endif
    kick_watchdog();
    RF_Tx[0]=0xFE;
    RF_Tx[1]=0x0C;
    RF_Tx[2]=0x29;
    RF_Tx[3]=0x00;
    RF_Tx[4]=0x09;
    RF_Tx[5]=0x00;
    RF_Tx[6]=0x00;
    RF_Tx[7]=0x00;
    RF_Tx[8]=0x00;
    RF_Tx[9]=0x00;
    RF_Tx[10]=0x05;
    RF_Tx[11]=0x01;
    /*total_active_power+=0x3C;
    if (total_active_power > 0x4000000)
      total_active_power=0;*/
    //total_active_power=0xF623;
   // total_active_power-=100;
    RF_Tx[12]=total_active_power & 0xFF;
    RF_Tx[13]=(total_active_power >> 8) & 0xFF;
    RF_Tx[14]=(total_active_power >> 16) & 0xFF;
    RF_Tx[15]=(total_active_power >> 24) & 0xFF;
    XOR_res=0;
    for(i=1;i<16;i++)
    {
        XOR_res^=RF_Tx[i];
    }
    RF_Tx[16]=XOR_res;
    for (i=0;i<17;i++)
    {
        UCA0TXBUF=RF_Tx[i];
        while(!(IFG2&UCA0TXIFG));
    }
    UC1IE |= UCA1TXIE;
   // total_active_power=0x7234;
    // LCD display
    ten_thou=0;
    thou=0;
    hun=0;
    ten=0;
    unit=0; 
     if (total_active_power <0)
            temp=-(total_active_power);
          else
            temp=total_active_power;
          while (temp >=10000)
          {
              ten_thou++;
              temp-=10000;
          }
          while (temp >=1000)
          {
              thou++;
              temp-=1000;
          }
          while (temp >=100)
          {
              hun++;
              temp-=100;
          }
          while (temp >=10)
          {
              ten++;
              temp-=10;
          }
          while (temp >=1)
          {
              unit++;
              temp--;
          }

      for( LCD_reg = 0; LCD_reg < 8; LCD_reg ++)
      {
        LCDMEM[LCD_reg] = 0;                          // Clear LCD
      }
      LCDMEM[0] = char_gen[unit];
      LCDMEM[1] = char_gen[ten]|h_seg;
      LCDMEM[2] = char_gen[hun];
      LCDMEM[3] = char_gen[thou];
      LCDMEM[4] = char_gen[ten_thou];  
      LCDMEM[9] |= 0x10;
      LCDMEM[9] ^= 0xE0;
      LCDMEM[10]= 0x22;
            
    #if defined(RTC_SUPPORT)
        #if defined(CORRECTED_RTC_SUPPORT)
    /* Allow for RTC correction. */
    if ((meter_status & SKIP_A_SECOND))
        meter_status &= ~SKIP_A_SECOND;
    else
        rtc_bumper();
        #else
    rtc_bumper();
        #endif
    #endif
   
    if (++seconds & 1)
        meter_status |= TICKER;  /* Kick every 2 seconds */

    kick_watchdog();
}
#endif
