// ComPort.cpp : implementation file
//
#include "stdafx.h"
#include "ComPort.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CComPort constructor/destructor
CComPort::CComPort()
{
	m_hRcvEvt=NULL;
	m_hSndEvt=NULL;
	m_hWaitEvt=NULL;
	m_ComHandle=INVALID_HANDLE_VALUE;
	m_name.Empty();
	memset(&m_RcvOvrlpd,0,sizeof(OVERLAPPED));
	memset(&m_SndOvrlpd,0,sizeof(OVERLAPPED));
	memset(&m_WaitOvrlpd,0,sizeof(OVERLAPPED));

	m_BaudRate=9600;
	m_DataBits=8;
	m_Parity=NOPARITY;
	m_StopBits=ONESTOPBIT;
	m_FlowControl=0;
}

CComPort::~CComPort()
{
	Release();
}

/////////////////////////////////////////////////////////////////////////////
// Initialize
int CComPort::InitPort(int PortNum,int BaudRate)
{
    if (m_ComHandle!=INVALID_HANDLE_VALUE) {
		CloseHandle(m_ComHandle); m_ComHandle=INVALID_HANDLE_VALUE;
	}
	m_name.Format(_T("\\\\.\\COM%d"),PortNum);
//gp    m_ComHandle = CreateFile((LPCSTR)m_name,GENERIC_READ|GENERIC_WRITE,
    m_ComHandle = CreateFile(m_name,GENERIC_READ|GENERIC_WRITE,
        0L, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED, NULL);
    if (m_ComHandle!=INVALID_HANDLE_VALUE)
	{
		DCB	dcb;
		memset(&dcb,0,sizeof(dcb));
		dcb.DCBlength=sizeof(DCB);
	    SetCommMask(m_ComHandle,EV_RXCHAR|EV_CTS|EV_DSR|EV_RING);
		GetCommState(m_ComHandle,&dcb);
        dcb.BaudRate = m_BaudRate = BaudRate;
		dcb.ByteSize = m_DataBits;
		dcb.StopBits = m_StopBits;
		dcb.Parity = m_Parity;
		dcb.fRtsControl = RTS_CONTROL_DISABLE;
		dcb.fDtrControl = DTR_CONTROL_DISABLE;
		dcb.fAbortOnError = false;
        SetCommState(m_ComHandle,&dcb);
        SetupComm(m_ComHandle,16*1024L,1024L);
		COMMTIMEOUTS	TimeOuts;
        TimeOuts.ReadIntervalTimeout = 0;
        TimeOuts.ReadTotalTimeoutMultiplier = 0;
        TimeOuts.ReadTotalTimeoutConstant = 0;
        TimeOuts.WriteTotalTimeoutMultiplier = 0;
        TimeOuts.WriteTotalTimeoutConstant = 0;
        SetCommTimeouts(m_ComHandle,&TimeOuts);

		if (m_hRcvEvt==NULL) m_hRcvEvt=CreateEvent(NULL, FALSE, FALSE, NULL);
		if (m_hSndEvt==NULL) m_hSndEvt=CreateEvent(NULL, FALSE, FALSE, NULL);
		if (m_hWaitEvt==NULL) m_hWaitEvt=CreateEvent(NULL, FALSE, FALSE, NULL);
		
		m_RcvOvrlpd.hEvent = m_hRcvEvt;
		m_SndOvrlpd.hEvent = m_hSndEvt;
		m_WaitOvrlpd.hEvent = m_hWaitEvt;
    }
	else m_name.Empty();
	return (m_ComHandle!=INVALID_HANDLE_VALUE);
}
/////////////////////////////////////////////////////////////////////////////
void CComPort::Release()
{
	if (m_hRcvEvt != NULL) { CloseHandle(m_hRcvEvt); m_hRcvEvt=NULL; }
	if (m_hSndEvt != NULL) { CloseHandle(m_hSndEvt); m_hSndEvt=NULL; }
	if (m_hWaitEvt != NULL) { CloseHandle(m_hWaitEvt); m_hWaitEvt=NULL; }
    if (m_ComHandle!=INVALID_HANDLE_VALUE) {
		CloseHandle(m_ComHandle); m_ComHandle=INVALID_HANDLE_VALUE;
		m_name.Empty();
	}
}
/////////////////////////////////////////////////////////////////////////////
int	CComPort::Send(UCHAR *buf,int length,DWORD tmout,BOOL bPurgeRcv)
{
	if (m_ComHandle==INVALID_HANDLE_VALUE) return FALSE;
	ULONG	bwritten;
	if (bPurgeRcv) PurgeComm(m_ComHandle,PURGE_RXCLEAR);
	ResetEvent(m_hSndEvt);
	if (FALSE==WriteFile(m_ComHandle,buf,length,&bwritten,&m_SndOvrlpd)) {
		if (GetLastError() != ERROR_IO_PENDING) return FALSE;
		if (WAIT_TIMEOUT==WaitForSingleObject(m_hSndEvt,tmout)) {
			PurgeComm(m_ComHandle,PURGE_TXABORT);
            return FALSE;
		}
	}
	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
int	CComPort::Receive(UCHAR *buf,int length,DWORD tmout)
{
	if (m_ComHandle==INVALID_HANDLE_VALUE) return FALSE;
	ULONG	err, bread;
	if (ClearCommError(m_ComHandle, &err, NULL) && err) {
		PurgeComm(m_ComHandle,PURGE_RXCLEAR);
	}
	ResetEvent(m_hRcvEvt);
	if (FALSE==ReadFile(m_ComHandle,buf,length,&bread,&m_RcvOvrlpd)) {
		if (GetLastError() != ERROR_IO_PENDING)	return FALSE;
		if (WAIT_TIMEOUT==WaitForSingleObject(m_hRcvEvt,tmout)) {
			PurgeComm(m_ComHandle,PURGE_RXABORT);
			return FALSE;
		}
	}
	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
int	CComPort::GetEvent(LPDWORD lpEvtMask,DWORD tmout)
{
	if (m_ComHandle==INVALID_HANDLE_VALUE) return FALSE;
	ResetEvent(m_hWaitEvt);
	if (FALSE==WaitCommEvent(m_ComHandle,lpEvtMask,&m_WaitOvrlpd)) {
		if (GetLastError() != ERROR_IO_PENDING)	return FALSE;
		if (WAIT_TIMEOUT==WaitForSingleObject(m_hWaitEvt,tmout))
			return FALSE;
	}
	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
void CComPort::SetControl(int rts, int dtr)
{
	DCB	dcb;
	memset(&dcb,0,sizeof(dcb));
	dcb.DCBlength=sizeof(DCB);
	GetCommState(m_ComHandle,&dcb);
	dcb.BaudRate = m_BaudRate;
	dcb.ByteSize = m_DataBits;
	dcb.StopBits = m_StopBits;
	dcb.Parity = m_Parity;
	dcb.fRtsControl = rts;
	dcb.fDtrControl = dtr;
	dcb.fAbortOnError = false;
	SetCommState(m_ComHandle,&dcb);
}
/////////////////////////////////////////////////////////////////////////////
