#if !defined(AFX_COMPORT_H__DA4599C8_FD03_11D3_9DF7_C29EFE3FD72D__INCLUDED_)
#define AFX_COMPORT_H__DA4599C8_FD03_11D3_9DF7_C29EFE3FD72D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ComPort.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CComPort
class CComPort
{
// Attributes
private:
	HANDLE	m_ComHandle;
	HANDLE	m_hRcvEvt;
	HANDLE	m_hSndEvt;
	HANDLE	m_hWaitEvt;
	OVERLAPPED	m_RcvOvrlpd;
	OVERLAPPED	m_SndOvrlpd;
	OVERLAPPED	m_WaitOvrlpd;
	CString m_name;

	int	m_BaudRate;
	int	m_DataBits;
	int m_Parity;
	int m_StopBits;
	int	m_FlowControl;

// Operations
public:
	CComPort();
	~CComPort();

	int InitPort(int PortNum,int BaudRate);
	void Release();
	int	Send(UCHAR *buf,int length,DWORD tmout=700,BOOL bPurgeRcv=false);
	int	Receive(UCHAR *buf,int length,DWORD tmout=1500);
	HANDLE GetHandle() { return m_ComHandle; }
	CString GetName() { return m_name; }
	
	int GetBaudRate() { return m_BaudRate; }
	void SetBaudRate(int BaudRate) { m_BaudRate=BaudRate; }

	int GetDataBits() { return m_DataBits; }
	void SetDataBits(int DataBits) { m_DataBits=DataBits; }

	int GetParity() { return m_Parity; }
	void SetParity(int Parity) { m_Parity=Parity; }

	int GetStopBits() { return m_StopBits; }
	void SetStopBits(int StopBits) { m_StopBits=StopBits; }

	int GetFlowControl() { return m_FlowControl; }
	void SetFlowControl(int FlowControl) { /*m_FlowControl=FlowControl;*/ }

	int	GetEvent(LPDWORD lpEvtMask,DWORD tmout=500);

	void SetControl(int rts, int dtr);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_COMPORT_H__DA4599C8_FD03_11D3_9DF7_C29EFE3FD72D__INCLUDED_)
