// SOMConsole.cpp : Defines the entry point for the console application.
//
//*****************************************************************
// History: 
//	V1.6	Serghei Druta (ADD Grup)		originator
//	V1.8	Greg Peake (TI)					Changed get_info, added mode change, added TX and RX message.
//  V1.10   Peake							Source Release
//*****************************************************************

#include "stdafx.h"
#include "SOMConsole.h"
#include "Comport.h"
//#include "Somy.h"
#include <conio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#define DEBUG_GP
#endif
#define VER (int)110

// The one and only application object
CWinApp theApp;

// COM port object
CComPort comp;

#define	F_REQUEST	0x80
#define	F_ANSWER	0x00

using namespace std;

//////////////////////////////////////////////////////////////////////////
// Calculates CRC16 for the given buffer
WORD CalcCRC16(BYTE *buf, int len)
{
	WORD	crc = 0;
	WORD	c;
	BYTE	i;

	while ( len-- ) {
		c = ((*buf++) ^ crc) & 0xFF;
		i = 8;
		do {
			if ( c & 1 ) {
				c >>= 1;
				c ^= 0xA001;
			}
			else c >>= 1;
		} while( --i );
		crc = (crc>>8) ^ c;
	}
	return crc;
}

//*****************************************************************
// Formats and sends a command to the modem and waits for an answer
//*****************************************************************
int SendCommand(TCommand cmd, BYTE *buf, int *length)
{
	BYTE	p[256];
	int		timeout=1000;
	int		len=1+(*length);	// add Command field

	p[0]=0xA1;					// Prefix
	memcpy(&p[1],&len,2);		// Length
	p[3]=cmd | F_REQUEST;		// Command
	if (*length) memcpy(&p[4],buf,*length);	// Data
	len+=2;						// add Length field
	WORD crc=CalcCRC16(p+1,len);
	memcpy(&p[1+len],&crc,2);	// CRC
	len+=3;						// add Prefix and CRC fields

	*length=0;

	if (cmd)
	{
		// Send command
		if (!comp.Send(p, len, 1000, true))
		{
			return 0;
		}
	}
	else						// No command to send, just wait for some frame
	{
		timeout=5000;
		printf("No command to send, just wait for some frame ...");
	}
//*****************************************************************
// Waits, Receives a command from the modem and sends a response
//*****************************************************************
// Get answer
	int		i=0, eof=0;
	BYTE	b, *ptr=p;
	while (!eof)
	{
		if (comp.Receive(&b,1,timeout))			// get 1 byte from COM
		{
			switch (i)							// check step
			{
				case 0:		// Prefix
					if (b==0xA1) i++;
					break;
				case 1:		// Length low
					len=b; *ptr=b; i++;
					break;
				case 2:		// Length high
					len|=((WORD)b)<<8;
					if ((len<1) || (len>250))
					{ 
						i=0; 
					}
					else
					{
						ptr++; *ptr++=b;
						*length=len;
						len+=2;					// add CRC length
						i++;
					}
					break;
				case 3:		// Data + CRC
					*ptr++=b; len--;
					if (!len)
					{
						if (!CalcCRC16(p,len))	// check CRC
						{
							memcpy(buf,p+2,*length+2);
							return 1;			// answer received OK
						}
						eof=1;
					}
					break;
			}
		}
		else
		{
			break;
		}
	}

	return 0;
}

//*************************************************
// Main
//*************************************************
int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 1;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		return nRetCode;
	}
	else
	{
		printf("SOMConsole v%2.2f (c) 2009 Texas Instruments\n", float(VER)/100);		
	}

	if (argc<2) {
		printf("Parameters:\n");
		printf("  -bX			- set baud rate (X) (by default 38400)\n");
		printf("  -cX			- specify COM port number (X)\n");
		printf("  -dXY			- drive pin Y to state X\n");
		printf("  -eF			- write file (F) to EEPROM\n");
		printf("  -mMODE		- Set MODE to SPY,MAS,SLV,P2P\n");
		printf("  -ptX			- send TEST frame (X times)\n");
		printf("  -ppX			- send PING frames to MAC address X\n");
		printf("  -pgX			- set Generator mode X\n");
		printf("  -s			- request modem state\n");
		printf("  -tX			- run self test (mode X)\n");
		printf("Usage examples:\n");
		printf("  SOMy -c1 -b38400 -eProm.bin    // write Prom.bin to EEPROM\n");
		printf("  SOMy -c1 -s -t0                // get modem state and perform self test\n");
		printf("  SOMy -c1 -d017                 // set pin 17 to state 0\n");
		printf("  SOMy -c1 -pt10                 // send 10 TEST frames\n");
		printf("  SOMy -c1 -pp1                  // send PING frames to MAC 1\n");
		return 2;
	}

	int		nLength=0;
	int		port=0, rate=38400, modType=0;
	int		bWriteEeprom=0, iSelfTest=-1, bGetState=0, iDrivePIO=0;
	int		iPhService=0, iPhParam=0, iCarrier=28;
	int		bGetOpMode=0, bSetOpMode=0, bGetInfo=0;
	int		iMibWr=0, iMibValue=0;
	int		iFeatures=0, iFeaturesValue=0xFFFF;
	int		iDLService = 0, iOpMode=0;
	int		iMsg=0, iMsgMAC=1;
	FILE	*fp=NULL;


	// Loop through command line arguments and process relevant command line options 
	for (int i=1; i<argc; i++)
	{
		nLength = (int)strlen(argv[i]);

		if ( (*(argv[i]) == '-') && (nLength > 1) )
		{
			switch( *(argv[i]+1) )
			{
			case 'c':	// COM port
			case 'C':
				port = strtol((argv[i] + 2), NULL, 0);
				break;
			case 'b':	// Baud rate
			case 'B':
				rate = strtol((argv[i] + 2), NULL, 0);
				break; 
			case 'e':	// File name to write to EEPROM
			case 'E':
				fp = fopen((argv[i]+2),"rb");
				bWriteEeprom=1;
				break; 
			case 's':	// Get Info and State
			case 'S':
				bGetInfo = 1;
				bGetState = 1;
				bGetOpMode = 1;
				break;
			case 'm':	// Set Mode
			case 'M':
				bSetOpMode = 1;
				switch ( *(argv[i]+2) )
				{
				case 'p':	// P2P
				case 'P':
					iOpMode=0;
					break;
				case 'm':	// Master
				case 'M':
					iOpMode=2;
					break;
				case 's':	// Slave or SPY
				case 'S':
					if ((*(argv[i]+3)== 'l') || (*(argv[i]+3)== 'L')) iOpMode=1;  //Slave
					else iOpMode=3;		//SPY
					break;
				}

				break;
			case 'd':	// Drive PIO
			case 'D':
				iDrivePIO = ((*(argv[i]+2)) - '0') << 6;
				iDrivePIO |= strtol(((const char *)argv[i] + 3), NULL, 0);
				break;
			case 't':	// Self test
			case 'T':
				iSelfTest = strtol(((const char *)argv[i] + 2), NULL, 0);
				break;
			case 'p':	// PH_SERVICE
			case 'P':
				switch ( *(argv[i]+2) )
				{
				case 't':	// PH_TEST
				case 'T':
					iPhService = 1;
					iPhParam = strtol(((const char *)argv[i] + 3), NULL, 0);
					break;
				case 'p':	// PH_PING
				case 'P':
					iPhService = 2;
					iPhParam = strtol(((const char *)argv[i] + 3), NULL, 0);
					break;
				case 'g':	// PH_GENERATE
				case 'G':
					iPhService = 4;
					iPhParam = strtol(((const char *)argv[i] + 3), NULL, 0);
					break;
				}
				break;
			}
		}
	}

	// Check parameters
	if (!port) {
		printf("Error! Invalid COM port number specified.\n");
		return 3;
	}
	if (!rate) {
		printf("Error! Invalid baudrate specified.\n");
		return 4;
	}
	if (bWriteEeprom && !fp) {
		printf("Error! Input file open error.\n");
		return 5;
	}
	if (!comp.InitPort(port,rate)) {
		printf("Error! COM port open error.\n");
		return 6;
	}
// Print basic information
	BYTE	buf[256], wbuf[256];	
	nLength=0;
	if (SendCommand(CMD_GET_INFO, buf, &nLength))
	{
		GET_INFO	*info=(GET_INFO*)(buf+1);
		modType=info->swMinor;	// 1=SFSK, 2=OFDM
		printf("\nFound %s modem: DevType %d, Serial#%lu, Soft v.%d.%d.%d.%d, Hard rev.%d \n", 
			(modType==1)?"SFSK":"OFDM",
				info->devType, info->serNumber,
				info->swMajor,info->swMinor,info->swExt,info->swBuild, info->hwRevision);
	}


//*************************************************
// Get Info
//*************************************************
	if (bGetInfo)
	{
		// Get device information
		nLength=0;
		printf("Getting modem info...\n");
		if (SendCommand(CMD_GET_INFO, buf, &nLength))
		{
			GET_INFO	*info=(GET_INFO*)(buf+1);
			modType=info->swMinor;	// 1=SFSK, 2=OFDM
			printf("\n\tFound %s modem: DevType %d, Serial#%lu, Soft v.%d.%d.%d.%d, Hard rev.%d \n", 
				(modType==1)?"SFSK":"OFDM",
				info->devType, info->serNumber,
				info->swMajor,info->swMinor,info->swExt,info->swBuild, info->hwRevision);
			printf("                   Baudrate Mask x%02X, Frame Size %d\n", 
				info->baudRateMask, info->frameSize);
			printf("\n\tFeatures supported:\n");
			if (info->LLC_T1) printf("\t\t- LLC 802.2 Type 1 \n");
			if (info->LLC_T2) printf("\t\t- LLC 802.2 Type 2 \n");
			if (info->LLC_T3) printf("\t\t- LLC 802.2 Type 3 \n");
			if (info->SNDP) printf("\t\t- SNDP Protocol \n");
			if (info->IP) printf("\t\t- TCP-IP Stack \n");
			if (info->SPY) printf("\t\t- SPY Mode \n");
			if (info->Master) printf("\t\t- Master Mode \n");
			if (info->Slave) printf("\t\t- Slave Mode \n");
			if (info->P2P) printf("\t\t- P2P Mode \n");
			if (info->PDM) printf("\t\t- Power Down Mode\n");
			if (info->UA) printf("\t\t- UART Comms\n");
			if (info->I2C) printf("\t\t- I2C Comms\n");
			if (info->SPI) printf("\t\t- SPI Comms\n");
			if (info->CustApp) printf("\t\t- CustApp supported\n");
			bGetState = 1;	// Print state information as well.
		}
		else {
			printf(" Error! Device info receive error.\n");
			return 1;
		}
	}
//*************************************************
// Get State
//*************************************************
	if (bGetState)
	{
		nRetCode = 1;
		printf("\n\tModem state...\n");
		nLength=0;
		if (!SendCommand(CMD_GET_STATE, buf, &nLength))
		{
			printf(" Error! GET_STATE command error.\n");
		}
		else
		{
			if (nLength>1) {
				GET_STATE	*st=(GET_STATE*)(buf+1);
				printf("\t\t- EN Signal: %d\n",st->en);
				printf("\t\t- FB Signal: %d\n",st->fb);
				printf("\t\t- FC Signal: %d\n",st->fc);
				printf("\t\t- AGC level of last RX frame: %d\n",st->agc);
				printf("\t\t- Mains Frequency State: ");
				switch(st->mf) {
					case 1: printf("50Hz detected\n"); break;
					case 2: printf("60Hz detected\n"); break;
					case 0: printf("No ZC detected\n"); break;
					default: printf("bad value\n");
				}
				nRetCode = 0;
				bGetOpMode = 1;		// Print operating Mode as well
			}
			else {
				printf(" Error! GET_STATE reply length error.\n");
			}
		}
	}

//*************************************************
// Operation Mode
//*************************************************
// GET 
	if (bGetOpMode)
	{
		nRetCode = 1;
		nLength=0;
		if (!SendCommand(CMD_OP_MODE, buf, &nLength))
		{
			printf(" Error! OP_MODE command error.\n");
		}
		else
		{
			if (nLength>1) {
				OP_MODE	*st=(OP_MODE*)(buf+1);
				switch(st->OpMode) {
					case 0: printf("\t\t- Modem set to P2P Mode\n"); break;
					case 1: printf("\t\t- Modem set to SLAVE Mode\n"); break;
					case 2: printf("\t\t- Modem set to Master Mode\n"); break;
					case 3: printf("\t\t- Modem set to SPY Mode\n"); break;
					default: printf("bad value\n");
				}
				switch(st->Interface) {
					case 0: printf("\t\t- Interface set to Firmware Default\n"); break;
					case 1: printf("\t\t- Interface set to PHY Layer\n"); break;
					case 2: printf("\t\t- Interface set to MAC Layer\n"); break;
					case 3: printf("\t\t- Interface set to LLC Layer\n"); break;
					default: printf("bad value\n");
				}
				nRetCode = 0;
			}
			else {
				printf(" Error! OP_MODE reply length error.\n");
			}
		}
	}
// SET	
	if (bSetOpMode)
	{
		nRetCode = 1;
		nLength=0;
		if (!SendCommand(CMD_OP_MODE, buf, &nLength))			// Get the current OPMode
		{
			printf(" Error! OP_MODE command error.\n");
		}
		OP_MODE *st=(OP_MODE*)(buf+1);
		buf[0] = st->Interface<<4 | iOpMode;				// Set new OpMode
		nLength= 1;											// Length of one data byte
		if (!SendCommand(CMD_OP_MODE, buf, &nLength))		// Send new OPMode
		{
			printf(" Error! OP_MODE command error.\n");
		}
		nLength=0;
		if (!SendCommand(CMD_OP_MODE, buf, &nLength))		// Get new OPMode
		{
			printf(" Error! OP_MODE command error.\n");
		}
		if (nLength>1) {
			OP_MODE	*st=(OP_MODE*)(buf+1);
			switch(st->OpMode) {
				case 0: printf("\t\t- Modem set to P2P Mode\n"); break;
				case 1: printf("\t\t- Modem set to SLAVE Mode\n"); break;
				case 2: printf("\t\t- Modem set to Master Mode\n"); break;
				case 3: printf("\t\t- Modem set to SPY Mode\n"); break;
				default: printf("bad value\n");
			}
			switch(st->Interface) {
				case 0: printf("\t\t- Interface set to Firmware Default\n"); break;
				case 1: printf("\t\t- Interface set to PHY Layer\n"); break;
				case 2: printf("\t\t- Interface set to MAC Layer\n"); break;
				case 3: printf("\t\t- Interface set to LLC Layer\n"); break;
				default: printf("bad value\n");
			}

		}
	}
//*************************************************
// Drive PIO
//*************************************************
	if (iDrivePIO)
	{
		nRetCode = 1;
		printf("Driving pin %d to state %d...\n", iDrivePIO&0x3F, iDrivePIO>>6);
		nLength=1;
		buf[0]=(BYTE)iDrivePIO;
		if (!SendCommand(CMD_DRIVE_PIO, buf, &nLength))
		{
			printf(" Error! DRIVE_PIO command error.\n");
		}
		else
		{
			if (*buf != CMD_OK)								// not OK
			{
				printf(" Error! DRIVE_PIO error %d.\n", buf[1]);
			}
			else 
			{
				printf(" Pin state set OK.\n");
				nRetCode = 0;
			}
		}
	}
//*************************************************
// Self test
//*************************************************
	if (iSelfTest!=-1)
	{
		nRetCode = 1;
		printf("Running self test (mode=%d)...\n",iSelfTest);
		nLength=1;
		buf[0]=(BYTE)iSelfTest;
		if (!SendCommand(CMD_SELFTEST, buf, &nLength))
		{
			printf(" Error! SELFTEST command error.\n");
		}
		else
		{
			if (nLength>1) {
				if (buf[1]==0) {
					printf(" SELFTEST passed OK.\n");
					nRetCode = 0;
				}
				else {
					printf(" SELFTEST not passed!\n");
					for (int i=0; i<nLength-2; i++) {
						printf(" %d) pin %d, test %d\n", i+1, buf[i+2]&0x7F, (buf[i+2]>>7) );
					}
				}
			}
			else {
				printf(" Error! SELFTEST reply length error.\n");
			}
		}
	}
		
//*************************************************
// PH_SERVICE (Phy Service)
//*************************************************
	if (iPhService)
	{
		nRetCode = 1;
		if (iPhService==1)
		{
			int	n=1;
			do {
				printf("Sending TEST frame %d...\n", n++);
				if (modType==1) nLength=36;		// S-FSK
				else            nLength=200;	// OFDM
				for (int i=0;i<nLength;i++) buf[1+i]=(BYTE)(0x55+i);
				buf[0]=(BYTE)iPhService;
				nLength++;
				if (!SendCommand(CMD_PH_SERVICE, buf, &nLength))
				{
					printf(" Error! PH_SERVICE command error.\n");
				}
				else
				{
					if (*buf == CMD_OK)	{
						printf(" TEST frame sent OK.\n");
						nRetCode = 0;
					}
					else {
						printf(" Error! PH_TEST service error.\n");
					}
				}
				if (iPhParam) {
					if (modType==1) Sleep(2000);	// S-FSK
					else Sleep(500);
					iPhParam--;
				}
			} while (iPhParam);
		}
		else if (iPhService==2)
		{
			int	totalBits=0, errBits=0;
			int n=1;
			do {
				printf("Sending PING frame %d to %d...\n", n++, iPhParam);
				if (modType==1) nLength=34;		// S-FSK
				else            nLength=200;	// OFDM
				for (int i=0;i<nLength;i++) buf[3+i]=(BYTE)(0x55+i);
				buf[0]=(BYTE)iPhService;
				*((WORD*)(&buf[1])) = iPhParam;	// destination address
				nLength+=3;
				for (int i=0;i<nLength-1;i++) wbuf[i]=buf[i+1];	// save sent data
				if (!SendCommand(CMD_PH_SERVICE, buf, &nLength))
				{
					printf(" Error! PH_SERVICE command error.\n");
				}
				else
				{
					if (*buf == CMD_OK)	{
						printf(" PING frame sent OK.\n");
						nLength=0;
						if (SendCommand(TCommand(0), buf, &nLength)) {
							if (nLength>3 && ((buf[0]&0x1F)==CMD_PH_SERVICE) && ((buf[1]&0x1F)==1)) {
								// check data
								int totalBits2=0, errBits2=0;
								for (int i=0; i<nLength-2; i++) {
									BYTE c=buf[2+i] ^ wbuf[i];
									for (int j=0; j<8; j++)
										if (c & (1<<j)) { errBits++; errBits2++; }
									totalBits+=8; totalBits2+=8;
								}
								printf(" Reply received. Len=%d, BER=%g, Total BER=%g\n",
									nLength-2, (errBits2*1.0)/totalBits2, (errBits*1.0)/totalBits);
							}
							else {
								printf(" Reply format error.\n");
							}
						}
						else {
							printf(" No reply to PING frame.\n");
						}
						nRetCode = 0;
					}
					else {
						printf(" Error! PH_PING service error %d.\n",buf[1]);
					}
				}
				if (modType==1) Sleep(2000);	// S-FSK
				else Sleep(500);
			} while (!_kbhit());
			_getch();
		}
		else if (iPhService==4)
		{
			printf("Setting Generator mode %d...\n", iPhParam);
			buf[0]=(BYTE)(iPhService | (iPhParam<<5));
			nLength=1;
			if (iPhParam==1) {	// Sinusoidal
				buf[1]=(BYTE)iCarrier;
				nLength++;
			}
			if (!SendCommand(CMD_PH_SERVICE, buf, &nLength))
			{
				printf(" Error! PH_SERVICE command error.\n");
			}
			else
			{
				if (*buf == CMD_OK)	{
					printf(" Generator mode set OK.\n");
					nRetCode = 0;
				}
				else {
					printf(" Error! PH_GENERATE service error.\n");
				}
			}
		}
	}
//*************************************************
// Write file to EEPROM
//*************************************************
	if (bWriteEeprom)
	{
		nRetCode = 1;
		int	addr=0, wlen;
		printf("Writing file to EEPROM...\n");
		while (1)
		{
			memcpy(buf,&addr,2);
			nLength=wlen=(int)(fread(buf+2,1,64,fp));					// save length for verification
			if (!nLength) {										// no more data
				if (addr) {										// something was written
					printf("\n EEPROM written OK.\n");
					nRetCode = 0;								// all done OK
				}
				break;
			}
			memcpy(wbuf,buf+2,wlen);							// save data for verification
			nLength+=2;											// add Addr field
			if (!SendCommand(CMD_EEPROM_WRITE, buf, &nLength))	// Write to EEPROM
			{
				printf(" Error! EEPROM write command error.\n");
				break;
			}
			else
			{
				if (*buf != CMD_OK)								// not OK
				{
					printf(" Error! EEPROM write error %d.\n", buf[1]);
					break;
				}
				else {											// OK
					BYTE	rbuf[256];
					int		len=4;
					memcpy(rbuf,&addr,2);
					memcpy(rbuf+2,&wlen,2);
					if (!SendCommand(CMD_EEPROM_READ, rbuf, &len))	// Read EEPROM
					{
						printf(" Error! EEPROM read command error.\n");
						break;
					}
					else
					{
						if ((len-1)==wlen) {					// check length
							if (!memcmp(wbuf,rbuf+1,wlen)) {	// compare data
								addr+=64;						// OK, increment address
								printf(".");					// just show progress
							}
							else {
								printf(" EEPROM verification error! addr=%d\n",addr);
								break;
							}
						}
						else {
							printf(" Error! EEPROM read length mismatch! (expected %d, got %d)\n",wlen,len);
							break;
						}
					}
				}
			}
		}
	}

	// clean up
	if (fp) fclose(fp);

	return nRetCode;
}
