#pragma once

#include "resource.h"

typedef enum {
	CMD_ERROR=0, CMD_OK, 
	CMD_GET_INFO, CMD_GET_STATE, 
	CMD_SPY_DATA, CMD_OP_MODE, 
	CMD_SET_RATE, CMD_SHUTDOWN,
	CMD_SELFTEST, CMD_DRIVE_PIO,
	CMD_reserved,
	CMD_IP_SERVICE, CMD_SN_SERVICE, CMD_DL_SERVICE,
	CMD_NM_SERVICE, CMD_MA_SERVICE, CMD_PH_SERVICE,
	CMD_MIB_READ, CMD_MIB_WRITE,
	CMD_EEPROM_READ, CMD_EEPROM_WRITE
} TCommand;

int ReceiveCommand(TCommand, BYTE *, int *);


typedef unsigned char	BYTE;
typedef unsigned short	WORD;
typedef unsigned long	DWORD;

#pragma pack(1)

typedef struct {
	WORD	devType;
	DWORD	serNumber;
	BYTE	swMajor;
	BYTE	swMinor;
	BYTE	swExt;
	BYTE	swBuild;
	BYTE	hwRevision;
	BYTE	baudRateMask;
	WORD	frameSize;
// Byte 1 features
	BYTE LLC_T1: 1;
	BYTE LLC_T2: 1;
	BYTE LLC_T3: 1;
	BYTE SNDP: 1;
	BYTE IP: 1;
	BYTE RES: 2;	//Reserved bit set to zero
	BYTE CustApp: 1;
// Byte 2 features
	BYTE SPY:1;	//SPY Mode
	BYTE Master:1;//Master Mode
	BYTE Slave:1;	//Slave Mode
	BYTE P2P:1;	//Peer to peer Mode
	BYTE PDM:1;	//Power Down Mode
	BYTE UA:1;	//UART Mode
	BYTE I2C:1;	//I2C Mode
	BYTE SPI:1;	//SPI Mode
} GET_INFO;

typedef struct {
	BYTE	mf	:2;
	BYTE	agc	:3;
	BYTE	fb	:1;
	BYTE	fc	:1;
	BYTE	en	:1;
} GET_STATE;

typedef struct {
	BYTE	ServiceType	:5;
	BYTE	QOS	:3;
	BYTE	MACAddress;
} DL_SERVICE;

typedef struct {
	BYTE OpMode		:4;
	BYTE Interface	:4;
} OP_MODE;

#pragma pack()
