/* =============================    main.c    ============================== */

// =============================   INCLUDES  ==================================
#include "dsk6455cfg.h" // contains definitions of BIOS objects
#include "main.h"	// contains program-wide definitions like BUFFSIZE, etc.
#include "edma.h"
#include "edma_int_dispatcher.h"
#include "edma_resource_allocation.h"
#include "mcbsp_aic23.h"
#include "scr_priority.h"
#include <csl_dat.h>	// DAT_copy, DAT_fill
#include <dsk6455.h>	// BSL
#include <dsk6455_aic23.h>	// BSL
#include <dsk6455_led.h>	// BSL
#include <c64.h>	// interrupt functions/defines
#include <stdint.h>  // used for definitions like uint32_t, ...

// =========    GLOBALS       ================================================
// Declare the ping & pong buffers together as a 2 dimensional array.
// ping = array[0], pong = array[1]. This simplifies variable names as
// well as any future dynamic memory management code
int16_t gBufferXmt[2][BUFFSIZE]; // Transmit PING & PONG buffers
int16_t gBufferRcv[2][BUFFSIZE]; // Receive PING & PONG  buffers

// AIC23 Codec configuration settings
DSK6455_AIC23_Config aic23_config = DSK6455_AIC23_DEFAULTCONFIG;

// =========    PROTOTYPES     ================================================
void init_buffers(void);

/*
 *  FUNCTION: main
 *
 *  PARAMETERS: none
 *
 *  DESCRIPTION: initializes clocks, peripherals, codec and interrupts
 *
 *  RETURNS: none
 *
 */
void main()
{
	// Turn on clocks to peripherals (EMAC, Timers, McBSPs, I2C, GPIO)
	// Configure PLL, DDR2, EMIFA and I2C
	DSK6455_init(); //Initialize the board support library, must be called first

	// Open the DAT module and then initialize the data buffers to zero
	init_buffers();

	DSK6455_LED_init(); // initialize the 4 LEDs to off state

	setup_edma(); 	// Start the EDMA controller

	// Setup prioritization of peripherals on switched central resource (SCR)
	// This needs to be called after setup_edma in order to use the EDMA handle.
	setup_scr_priority();

	// Initialize the McBSP for audio data channel
	// Configure the AIC23 codec through I2C control channel
	setup_mcbsp_aic23(&aic23_config);

	// Enable interrupt 5 (EDMA3 CC INT)
	// The configuration is in the tcf file.
	C64_enableIER(C64_EINT5);
	
	// Note that BIOS will enable NMIE and GIE after the return from main
}



/*
 *  FUNCTION: init_buffers
 *
 *  PARAMETERS: none
 *
 *  DESCRIPTION: Initializes the DAT module and does a DAT_fill of the buffers
 *
 *  RETURNS: none
 *
 */
void init_buffers(void)
{
	DAT_Setup datSetup;			//use for QDMA example
	int32_t id;
	uint32_t fillVal;

	// The DAT module needs to be opened with DAT_open one time only.  Once it
	// has been opened all future DAT calls (DAT_copy, DAT_fill, etc.) can
	// be called.  Note that the priority queue and the TCC will be set for
	// all future calls once you do the DAT_open.  If you wish to change the
	// queue or the TCC you would need to close and re-open.
	datSetup.qchNum = CSL_DAT_QCHA_0;		// pick a QDMA channel 0-3
	datSetup.regionNum = CSL_DAT_REGION_GLOBAL ;
	datSetup.tccNum = TCC_DAT;		// pick a TCC (use edma_resource_allocation.h) 
	datSetup.paramNum = PSET_DAT ;	// pick a PSET (use edma_resource_allocation.h)
	datSetup.priority = CSL_DAT_PRI_3; // pick a queue/TC (0-3)
	DAT_open(&datSetup);

	// Fill a linear block of memory with the specified fillVal using QDMA
	fillVal = 0;
	id = DAT_fill (gBufferXmt[0], sizeof(gBufferXmt), &fillVal);
	id = DAT_fill (gBufferRcv[0], sizeof(gBufferRcv), &fillVal);
	DAT_wait (id);

}
/* ==========================    END OF FILE    =========================== */
