#ifndef EDMA_RESOURCE_ALLOCATION_H_
#define EDMA_RESOURCE_ALLOCATION_H_

// ****************************************************************************
//  This file presents a method for keeping track of your QDMA/EDMA resources
//  in a project.  All Parameter RAM (PaRAM) allocations as well as TCC
//  assignments should be declared in here.  This file should be included by
//  any files that use EDMA resources.  It is recommended to put them in
//  ascending order in order to avoid repeats.  Also, it is recommended to add
//  a brief comment mentioning what file(s) the resource is used.  That way
//  you can do a "find" on a file name and see all the resources it is using.
// ****************************************************************************



// ****************************************************************************
// Parameter RAM Sets (PSETs): 0-255
// ****************************************************************************

// PSET used by DAT module in main.c
#define PSET_DAT						0

// ****************************************************************************
// Transfer Completion Codes (TCCs): 0-63
// ****************************************************************************

// TCC used by DAT module in main.c
#define TCC_DAT							0

#endif

