/* =============================    main.c    ============================== */

// =============================   INCLUDES  ==================================
#include "audio_appcfg.h" // contains definitions of BIOS objects
#include "main.h"	// contains program-wide definitions like BUFFSIZE, etc.
#include "mcbsp_aic23.h"
#include "scr_priority.h"
#include <dsk6455.h> // from the BSL
#include <dsk6455_aic23.h> // from the BSL
#include <dsk6455_led.h> // from the BSL
#include <string.h>  // used for memset, memcpy, ...
#include <stdint.h>  // used for definitions like uint32_t, ...

// =========    GLOBALS       ================================================
// Declare the ping & pong buffers together as a 2 dimensional array.
// ping = array[0], pong = array[1]. This simplifies variable names as
// well as any future dynamic memory management code
int16_t gBufferXmt[2][BUFFSIZE]; // Transmit PING & PONG buffers
int16_t gBufferRcv[2][BUFFSIZE]; // Receive PING & PONG  buffers

// AIC23 Codec configuration settings
DSK6455_AIC23_Config aic23_config = DSK6455_AIC23_DEFAULTCONFIG;

// =========    PROTOTYPES     ================================================
void init_buffers(void);

/*
 *  FUNCTION: main
 *
 *  PARAMETERS: none
 *
 *  DESCRIPTION: initializes clocks, peripherals, codec and interrupts
 *
 *  RETURNS: none
 *
 */
void main()
{
	// Turn on clocks to peripherals (EMAC, Timers, McBSPs, I2C, GPIO)
	// Configure PLL, DDR2, EMIFA and I2C
	DSK6455_init(); //Initialize the board support library, must be called first

	// initialize the data buffers to zero
	init_buffers();

	DSK6455_LED_init(); // initialize the 4 LEDs to off state

	// Setup prioritization of peripherals on switched central resource (SCR)
	// This needs to be called after setup_edma in order to use the EDMA handle.
	setup_scr_priority();

	// Initialize the McBSP for audio data channel
	// Configure the AIC23 codec through I2C control channel
	setup_mcbsp_aic23(&aic23_config);
}



/*
 *  FUNCTION: init_buffers
 *
 *  PARAMETERS: none
 *
 *  DESCRIPTION: Initializes the DAT module and does a DAT_fill of the buffers
 *
 *  RETURNS: none
 *
 */
void init_buffers(void)
{
	memset(gBufferRcv, 0, sizeof(gBufferRcv));
	memset(gBufferXmt, 0, sizeof(gBufferXmt));
}
/* ==========================    END OF FILE    =========================== */
