/* =========================    mcbsp_aic23.c    =========================== */

#include <dsk6455.h>		// from Spectrum Digital BSL
#include <dsk6455_aic23.h>	// from Spectrum Digital BSL
#include <csl_mcbsp.h>
#include <stdint.h>  // used for definitions like uint32_t, ...

CSL_McbspHandle ???;
CSL_McbspObj mcbspObj;
uint16_t *pDXR;
uint16_t *pDRR;

/*
 *  FUNCTION: setup_mcbsp_aic23
 *
 *  PARAMETERS: DSK6455_AIC23_Config *Config - AIC23 configuration structure
 *
 *  DESCRIPTION:  This function configures the AIC23 through I2C.  It also
 *                configures the McBSP to transmit/receive data to/from the
 *                AIC23.
 *
 *  RETURNS: none
 *
 */
void setup_mcbsp_aic23(DSK6455_AIC23_Config *Config)
{
    CSL_Status           status = CSL_SOK;

    status = CSL_mcbsp???(NULL);
    ??? = CSL_mcbsp??? (&mcbspObj, CSL_MCBSP_1, NULL, &status);
	pDRR = (uint16_t*)0x34000000;
	pDXR = (uint16_t*)0x34000010;

    /* Reset the AIC23 */ 
    DSK6455_AIC23_rset( 0, DSK6455_AIC23_RESET, 0 );

    /* Configure the rest of the AIC23 registers */ 
    DSK6455_AIC23_config( 0, Config );

	// Reset McBSP (FRST=GRST=XRST=RRST=0)
    hMcbsp1->regs->SPCR = 0x00000000;
    DSK6455_waitusec(300);

    /* Config MCBSP - See spru580 McBSP Reference Guide for further info */

	// clocks and frame syncs external
	// active high frame syncs
	hMcbsp1->regs->PCR = 	CSL_FMK(MCBSP_PCR_XIOEN, 0)	|	// bit13 0=serial port function, 1=GPIO
							CSL_FMK(MCBSP_PCR_RIOEN, 0) |	// bit12 0=serial port function, 1=GPIO
							CSL_FMK(MCBSP_PCR_FSXM, ?)	|	// bit11 0=FSX input, 1=FSX output (from SRGR)
							CSL_FMK(MCBSP_PCR_FSRM, ?)	|	// bit10 0=FSR input, 1=FSR output (from SRGR)
							CSL_FMK(MCBSP_PCR_CLKXM, ?)	|	// bit9  0=CLKX input, 1=CLKX output (from SRGR)
							CSL_FMK(MCBSP_PCR_CLKRM, ?)	|	// bit8  0=CLKR input, 1=CLKR output (from SRGR)
							CSL_FMK(MCBSP_PCR_DXSTAT, 0)|	// bit5  output value when using GPIO mode (XRST=0, XIOEN=1)
							CSL_FMK(MCBSP_PCR_FSXP, 0)	|	// bit3  0=FSX active high, 1=FSX active low	
							CSL_FMK(MCBSP_PCR_FSRP, 0)	|	// bit2  0=FSR active high, 1=FSR active low
							CSL_FMK(MCBSP_PCR_CLKXP, 1)	|	// bit1  0=DX sampled on rising edge of CLKX, 1=falling edge
							CSL_FMK(MCBSP_PCR_CLKRP, 1);	// bit0  0=DR sampled on rising edge of CLKR, 1=falling edge


	// Single phase, 16-bit elements, 2 elements (left and right) in phase 1
	// 0-bit delay
	hMcbsp1->regs->RCR = 	CSL_FMK(MCBSP_RCR_RPHASE, 0)	|	// bit31 0=single phase frame, 1=dual phase
							CSL_FMK(MCBSP_RCR_RFRLEN2, 0)	|	// bit30:24 phase 2 rcv frame length - 1 (e.g. 0 = 1 word)
							CSL_FMK(MCBSP_RCR_RWDLEN2, 0)	|	// bit23:21 phase 2 rcv word length, 0=8bit, 1=12bit, 2=16bit, 3=20bit, 4=24bit, 5=32bit
							CSL_FMK(MCBSP_RCR_RCOMPAND, 0)	|	// bit20:19 receive companding  0=no, MSB first; 1=no, LSB first; 2=yes, ulaw; 3=yes, A-law
							CSL_FMK(MCBSP_RCR_RFIG, 0)		|	// bit18 receive frame ignore;  0=restart if extra frame sync;   1=ignore extra frame syncs
							CSL_FMK(MCBSP_RCR_RDATDLY, 0)	|	// bit17:16  offset in bits btwn frame sync and data (0-2 bits)
							CSL_FMK(MCBSP_RCR_RFRLEN1, 1)	|	// bit14:8 phase 1 rcv frame length - 1 (e.g. 0 = 1 word)
							CSL_FMK(MCBSP_RCR_RWDLEN1, ?)	|	// bit7:5 phase 1 rcv word length, 0=8bit, 1=12bit, 2=16bit, 3=20bit, 4=24bit, 5=32bit
							CSL_FMK(MCBSP_RCR_RWDREVRS, 0);		// bit4   32-bit reversal; 0=disabled, 1=enabled

	hMcbsp1->regs->XCR = 	CSL_FMK(MCBSP_XCR_XPHASE, 0)	|	// bit31 0=single phase frame, 1=dual phase
							CSL_FMK(MCBSP_XCR_XFRLEN2, 0)	|	// bit30:24 phase 2 xmt frame length - 1 (e.g. 0 = 1 word)
							CSL_FMK(MCBSP_XCR_XWDLEN2, 0)	|	// bit23:21 phase 2 xmt word length, 0=8bit, 1=12bit, 2=16bit, 3=20bit, 4=24bit, 5=32bit
							CSL_FMK(MCBSP_XCR_XCOMPAND, 0)	|	// bit20:19 transmit companding  0=no, MSB first; 1=no, LSB first; 2=yes, ulaw; 3=yes, A-law
							CSL_FMK(MCBSP_XCR_XFIG, 0)		|	// bit18 transmit frame ignore;  0=restart if extra frame sync;   1=ignore extra frame syncs
							CSL_FMK(MCBSP_XCR_XDATDLY, 0)	|	// bit17:16  offset in bits btwn frame sync and data (0-2 bits)
							CSL_FMK(MCBSP_XCR_XFRLEN1, 1)	|	// bit14:8 phase 1 xmt frame length - 1 (e.g. 0 = 1 word)
							CSL_FMK(MCBSP_XCR_XWDLEN1, ?)	|	// bit7:5 phase 1 xmt word length, 0=8bit, 1=12bit, 2=16bit, 3=20bit, 4=24bit, 5=32bit
							CSL_FMK(MCBSP_XCR_XWDREVRS, 0); 	// bit4   32-bit reversal; 0=disabled, 1=enabled

	// not using sample rate generator - clocks and frame syncs external
	hMcbsp1->regs->SRGR =	CSL_FMK(MCBSP_SRGR_GSYNC, 0)|	// bit31 0=free running, 1=running+resync
							CSL_FMK(MCBSP_SRGR_CLKSP, 0)|	// bit30 CLKS polarity, 0=rising 1=falling
							CSL_FMK(MCBSP_SRGR_CLKSM, 0)|	// bit29 SRGR clock src, 0=CLKS, 1=CPU
							CSL_FMK(MCBSP_SRGR_FSGM, 0)	|	// bit28 frame sync generation; 0=DXR-to-XSR copy, 1=SRGR FSG
							CSL_FMK(MCBSP_SRGR_FPER, 0)	|	// bit27:16 frame period - 1 (e.g. 0 means 1, ..., 4095 means 4096)
							CSL_FMK(MCBSP_SRGR_FWID, 0)	|	// bit15:8 frame sync active time - 1 (e.g. 0 means 1, ..., 255 means 256) 
							CSL_FMK(MCBSP_SRGR_CLKGDV, 0);	// bit7:0 CLKG divider (0 means /1, ..., 255 means /256)

	// take transmitter and receiver out of reset (XRST=1, RRST=1)
	hMcbsp1->regs->SPCR = 	CSL_FMK(MCBSP_SPCR_FREE, 0)		|	// bit25 free run mode 0=disable, 1=enable
							CSL_FMK(MCBSP_SPCR_SOFT, 0)		|	// bit24 0=hard stop, 1=soft stop
							CSL_FMK(MCBSP_SPCR_FRST, 0)		|	// bit23 0=FSG disabled, 1=FSG enabled
							CSL_FMK(MCBSP_SPCR_GRST, 0)		|	// bit22 0=SRGR disabled, 1=SRGR enabled
							CSL_FMK(MCBSP_SPCR_XINTM, ?)	|	// bit21:20 xmt interrupt mode; 0=XRDY, 1=end of block, 2=new frame, 3=XSYNCERR
							CSL_FMK(MCBSP_SPCR_XRST, 1)		|	// bit16 0=transmitter disabled, 1=transmitter enabled
							CSL_FMK(MCBSP_SPCR_DLB, 0)		|	// bit15 digital loopback, 0=disabled, 1=enabled
							CSL_FMK(MCBSP_SPCR_RJUST, 0)	|	// bit14:13 receive justification; 0=right w/zero-fill, 1=right w/sign-extend, 2=left w/zero-fill (3 rsvd)
							CSL_FMK(MCBSP_SPCR_CLKSTP, 0)	|	// bit12:11 0=disabled, 1=rsvd, 2 and 3 for SPI mode
							CSL_FMK(MCBSP_SPCR_DXENA, 0)	|	// bit7 DX enabler 0=off, 1=on
							CSL_FMK(MCBSP_SPCR_RINTM, ?)	|	// bit5:4 rcv interrupt mode; 0=RRDY, 1=end of block, 2=new frame, 3=RSYNCERR
							CSL_FMK(MCBSP_SPCR_RRST, 1);		// bit0 0=receiver disabled, 1=receiver enabled

}

