/* =========================    scr_priority.c    ========================== */

#include <csl_bwmngmt.h>
#include <cslr_dev.h>
//#include "edma.h"

void setup_scr_priority(void)
{
	CSL_BwmngmtHandle hBwmngmt;
    CSL_BwmngmtObj bwmngmtObj;
    CSL_Status status;


  	// ************************************************************************
	// Switched Central Resource Prioritization
  	// ************************************************************************

    status = CSL_bwmngmtInit(NULL);
    hBwmngmt = CSL_bwmngmtOpen(&bwmngmtObj, CSL_BWMNGMT, NULL, &status);

    // Set priorities for SRIO, HOST (HPI/PCI), and EMAC
	// Using default reset values
	// SRIO=1, HOST=2, EMAC=1
	// See "PRI_ALLOC" in 6455 Datasheet
	((CSL_DevRegs*)CSL_DEV_REGS)->PRI_ALLOC = 0x00000211;

	// Set priorities for EDMA queues
    // Init Q0/Q1=0(highest),Q2=4, Q3=7 (lowest) priority.
	// See "QUEPRI" in EDMA3 Reference Guide
	//hEdmaModule->regs->QUEPRI = 0x00007400;

    // Setup the priority for Master DMA port of the Megamodule
	// Recommended to elevate the default priority 7 to something higher like 1
	// See "Bandwidth Management" chapter in Megamodule Reference Guide
    hBwmngmt->regs->MAPARBEXT = 0x00010000;	// MDMAARBE

  	// ************************************************************************
	// Megamodule Arbitration
  	// ************************************************************************
	// Access prioritization within the megamodule
	// See "Bandwidth Management" chapter in Megamodule Reference Guide

	// CPU priority when accessing
	// PRI can be 0-7 (1 default)
	// MAXWAIT can be 0 (always stalls for higher priority), 1, 2, 4, 8, 16 (default), 32
    hBwmngmt->regs->CPUARBEXT  = 0x00010010;	// CPUARBE
    hBwmngmt->regs->CPUARBL2  = 0x00010010;		// CPUARBU
    hBwmngmt->regs->CPUARBL1D  = 0x00010010;	// CPUARBD

	// PRI is programmed as part of the IDMA transfer parameters
	// MAXWAIT can be 0 (always stalls for higher priority), 1, 2, 4, 8, 16 (default), 32
    hBwmngmt->regs->IDMAARBEXT = 0x00000010;	// IDMAARBE
    hBwmngmt->regs->IDMAARBL2 = 0x00000010;		// IDMAARBU
    hBwmngmt->regs->IDMAARBL1D = 0x00000010;	// IDMAARBD

	// The slave DMA port always takes on the priority of the request initiator
	// MAXWAIT can be 0 (always stalls for higher priority), 1 (default), 2, 4, 8, 16, 32
    hBwmngmt->regs->SLAPARBEXT = 0x00000001;	// SDMAARBE
    hBwmngmt->regs->SLAPARBL2 = 0x00000001;		// SDMAARBU
    hBwmngmt->regs->SLAPARBL1D = 0x00000001;	// SDMAARBD

	// Global user-initiated cache transactions always have highest priority (0)
	// Block user-initiated cache transactions always have lowest priority (7)
	// MAXWAIT can be 0 (always stalls for higher priority), 1, 2, 4, 8, 16, 32 (default)
    hBwmngmt->regs->UCARBL2   = 0x00000020;		// UCARBD
    hBwmngmt->regs->UCARBL1D   = 0x00000020;	// UCARBU
}

