//--------------------------------------------------------------------------
// NDK LAB 3A: UDP sender using sockets programming
//--------------------------------------------------------------------------
//
// Author: Rafael de Souza, Arnie Reynoso
// Copyright 2007 by Texas Instruments Inc.
//--------------------------------------------------------------------------

#include <stdio.h>
#include <netmain.h>
#include <_stack.h>

char sendBuffer[1500];
char recvBuffer[1500];
char *UnicastAddr = "192.168.1.39";	// PC address

void udp_test()
{
    SOCKET   send = INVALID_SOCKET;     // Sender socket. 
    struct   sockaddr_in sout1;         // Sender socket address structure
    int sentCnt;

    // Allocate the file environment for this task
    fdOpenSession( TaskSelf() );

    // Create the send socket
    send = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if( send == INVALID_SOCKET )
        goto leave;

    // Send socket: set Port = 5000, IP destination address = ANY
    bzero( &sout1, sizeof(struct sockaddr_in) );
    sout1.sin_family = AF_INET;
    sout1.sin_len    = sizeof( sout1 );
    sout1.sin_port   = htons(5000);

    // Bind send socket
    if ( bind( send, (PSA) &sout1, sizeof(sout1) ) < 0 )
        {
        printf("Send: %d",fdError());
        goto leave;
        }

    strcpy( sendBuffer, "Are you there?" );
        
    for(;;)
    {
         sout1.sin_addr.s_addr = inet_addr(UnicastAddr); // PC address is the destination
         sout1.sin_port = htons(7); // Echo port (7) is where we want to send data

         // Send to PC every 5 sec
         do
         {
             TaskSleep(5000);
             sentCnt = sendto( send, sendBuffer, 15, 0, &sout1, sizeof(sout1) );
         } while (sentCnt < 0);

        printf (" Message sent to ethernet \n");           
        
    }

leave:
    // We only get here on a fatal error - close the sockets
    if( send != INVALID_SOCKET )
        fdClose( send );
    
    printf("Fatal Error\n");

    // This task is killed by the system - here, we block
    TaskBlock( TaskSelf() );
}
