/* =====================    edma_int_dispatcher.c    ======================= */

#include <stdint.h>  // used for definitions like uint32_t, ...
#include <csl_edma3.h>
#include "edma_int_dispatcher.h"

/* Global Edma Tcc handler table */
EdmaTccHandler TccHandlerTable[64];

#define InvokeHandle(num)       TccHandlerTable[num]()

/*
 * =============================================================================
 *   @func  edma_int_dispatcher
 *  
 *   @arg
 *      handle        - Edma module handle
 *
 *   @desc
 *      This is the interrupt handler routine for edma interrupt
 *
 *   @return
 *      NONE
 *
 * =============================================================================
 */
void edma_int_dispatcher (
    CSL_Edma3Handle       *hModule
)
{
    CSL_BitMask32       maskVal;
    CSL_Edma3CmdIntr    regionIntr;
    uint32_t            tcc;
    uint32_t            intr;
    uint32_t            intrh;
    
    /* Read the IPR and AND with IER to check for any IPR/IER combo set */
    regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
    CSL_edma3GetHwStatus(*hModule,CSL_EDMA3_QUERY_INTRPEND, &regionIntr);
	regionIntr.intr = regionIntr.intr & (*hModule)->regs->IER;
	regionIntr.intrh = regionIntr.intrh & (*hModule)->regs->IERH;

    while (regionIntr.intr || regionIntr.intrh)
    {
        intr    = regionIntr.intr;
        intrh = regionIntr.intrh;
        tcc   = 0;
        
        while (intr) {
            maskVal = 1 << tcc;
            if (intr & maskVal) {
                InvokeHandle(tcc);
                intr &= ~maskVal;
            }
            tcc++;      
        }       
        
        tcc = 0;
        while (intrh) {
            maskVal = 1 << tcc;
            if (intrh & maskVal) {
                InvokeHandle((tcc+32));
                intrh &= ~maskVal;
            }       
            tcc++;
        }
        
        CSL_edma3HwControl(*hModule,CSL_EDMA3_CMD_INTRPEND_CLEAR,&regionIntr);       
        CSL_edma3GetHwStatus(*hModule,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);         
		regionIntr.intr = regionIntr.intr & (*hModule)->regs->IER;
		regionIntr.intrh = regionIntr.intrh & (*hModule)->regs->IERH;
    }           
}

/*
 * =============================================================================
 *   @func  edma_int_hook
 *  
 *   @arg
 *      tcc        - TCC number
 *      fxn        - Pointer to function which points to edma isr
 *
 *   @desc
 *      This is the interrupt handler routine for edma interrupt
 *
 *   @return
 *      NONE
 *
 * =============================================================================
 */
void edma_int_hook (
    uint16_t          tcc, 
    EdmaTccHandler    fxn
)
{
    TccHandlerTable[tcc] = (fxn);
}

