/* ============================    tasks.c    ============================== */

// =============================   INCLUDES  ==================================
#include "audio_appcfg.h"
#include <dsk6455_dip.h>	// access to BSL DIP switch API
#include <dsk6455_led.h>
#include "main.h"	// contains program-wide definitions like BUFFSIZE, etc.
#include <csl_dat.h>
#include <stdint.h>  // used for definitions like uint32_t, ...

// =========    Global       ================================================

// make volatile so compiler doesn't optimize
// global such that you can change load through watch window
volatile int32_t load=50, inner_loop=235000;

/*
 *  FUNCTION: tskDipLED
 *
 *  PARAMETERS: none
 *
 *  DESCRIPTION: This is a periodic function designed to blink an LED and
 *               add CPU load when a dip switch is depressed
 *
 *  RETURNS: none
 *
 */
void tskDipLED(void)
{
// make volatile so compiler doesn't optimize
volatile int32_t i, j;

	while(1)
	{
		SEM_pend(&waitPRD, SYS_FOREVER);

		DSK6455_LED_toggle(0);		// toggle LED D10

		// If dip switch 0 on SW1 is depressed then insert dummy load.
		// The CPU load can be configured through the watch window by
		// changing the variable called "load".
		if (DSK6455_DIP_get(0)==0)
		{
			// dummy load
			for(i=0; i<load; i++)
			{
				for(j=0; j<inner_loop; j++);
			}
		}
	}
}


/*
 *  FUNCTION: procBuffTsk
 *
 *  PARAMETERS: none
 *
 *  DESCRIPTION:  This function processes the buffer of receive data.  Currently
 *                the function simply copies receive to transmit (i.e. it does
 *                a pass through).  In a real application this would be
 *                replaced by a signal processing algorithm.
 *
 *  RETURNS: none
 *
 */
void procBuffTsk(void)
{
	int16_t pingPong = PING;

	while (1)
	{
	    SEM_pend(&rcvBuffReady, SYS_FOREVER);
	    SEM_pend(&xmtBuffReady, SYS_FOREVER);

		// following this comment line is where you would put your DSP algorithm
	    DAT_copy(gBufferRcv[pingPong], gBufferXmt[pingPong], BUFFSIZE*sizeof(int16_t));
	    pingPong ^= 1; // switch buffer index for the next run

	}		
}

/* ==========================    END OF FILE    =========================== */

